/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySiltCrab
extends EntityMob
implements IEntityBL {
    private EntityAIAttackMelee aiAttack;
    private EntityAIAvoidEntity<EntityPlayer> aiRunAway;
    private EntityAINearestAttackableTarget<EntityPlayer> aiTarget;
    private int aggroCooldown = 200;
    private boolean canAttack = false;

    public EntitySiltCrab(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.6f);
        this.field_70138_W = 2.0f;
    }

    protected void func_184651_r() {
        this.aiAttack = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiRunAway = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 10.0f, 0.7, 0.7);
        this.aiTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(1, this.aiRunAway);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, this.aiTarget);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public int func_70641_bl() {
        return 5;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.aggroCooldown == 200 && !this.canAttack) {
                this.field_70714_bg.func_85156_a(this.aiRunAway);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_75776_a(1, this.aiTarget);
                this.canAttack = true;
            }
            if (this.aggroCooldown == 0 && this.canAttack) {
                this.field_70714_bg.func_85156_a((EntityAIBase)this.aiAttack);
                this.field_70715_bh.func_85156_a(this.aiTarget);
                this.field_70714_bg.func_75776_a(1, this.aiRunAway);
                this.canAttack = false;
            }
            if (this.aggroCooldown < 201) {
                ++this.aggroCooldown;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return !source.equals(DamageSource.field_76369_e) && super.func_70097_a(source, damage);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.func_70032_d((Entity)player) <= 1.5f && this.canAttack) {
            this.aggroCooldown = 0;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean attacked = super.func_70652_k(entityIn);
        if (attacked) {
            this.func_184185_a(SoundRegistry.CRAB_SNIP, 1.0f, 1.0f);
        }
        return attacked;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SILT_CRAB;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

