/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.FieldWrapper;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.ConfigProperty;
import thebetweenlands.common.config.remapper.ConfigRemapper;
import thebetweenlands.common.config.remapper.Remapper1;

public class ConfigHelper {
    @Nullable
    private static Configuration fileConfig;
    private static Configuration loadedConfig;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("thebetweenlands".equals(event.getModID())) {
            ConfigManager.sync((String)"thebetweenlands", (Config.Type)Config.Type.INSTANCE);
            Configuration newConfig = new Configuration(new File(BetweenlandsConfig.configDir, "config.cfg"));
            newConfig.load();
            loadedConfig = newConfig;
            ConfigHelper.initProperties(false);
        }
    }

    public static void loadExistingConfig() {
        fileConfig = null;
        BetweenlandsConfig.configDir = new File(Loader.instance().getConfigDir(), "thebetweenlands");
        File configFile = new File(BetweenlandsConfig.configDir, "config.cfg");
        if (configFile.exists()) {
            fileConfig = new Configuration(configFile);
            fileConfig.load();
        }
    }

    public static void init() {
        Configuration oldConfig;
        File versionFile = new File(BetweenlandsConfig.configDir, "config_version");
        Configuration newConfig = new Configuration(new File(BetweenlandsConfig.configDir, "config.cfg"));
        newConfig.load();
        String configVersion = null;
        if (fileConfig == null) {
            configVersion = "1.0.0";
            oldConfig = new Configuration(new File(BetweenlandsConfig.configDir, "config.cfg"));
            oldConfig.load();
        } else {
            if (versionFile.exists()) {
                try {
                    configVersion = FileUtils.readFileToString((File)versionFile, (Charset)null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            oldConfig = fileConfig;
        }
        ConfigRemapper.register(new Remapper1());
        Pair<Configuration, String> remap = ConfigRemapper.remap(oldConfig, newConfig, configVersion);
        if (remap != null) {
            File backupFile = new File(oldConfig.getConfigFile().getParentFile(), "config (" + (configVersion == null ? "no version" : configVersion) + ").cfg.backup");
            Configuration backup = ConfigRemapper.clear(new Configuration(backupFile, oldConfig.getDefinedConfigVersion()));
            ConfigRemapper.copy(oldConfig, backup);
            backup.save();
            newConfig = (Configuration)remap.getKey();
            newConfig.save();
            ConfigHelper.reloadConfig();
        }
        loadedConfig = newConfig;
        ConfigHelper.initProperties(false);
        try {
            FileUtils.writeStringToFile((File)versionFile, (String)"1.0.0", (Charset)null, (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reloadConfig() {
        try {
            Field configCacheField = ConfigManager.class.getDeclaredField("CONFIGS");
            configCacheField.setAccessible(true);
            Map configCache = (Map)configCacheField.get(null);
            configCache.put(new File(BetweenlandsConfig.configDir, "config.cfg").getAbsolutePath(), null);
            ConfigManager.sync((String)"thebetweenlands", (Config.Type)Config.Type.INSTANCE);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void postInit() {
        ConfigHelper.initProperties(true);
    }

    private static void initProperties(boolean post) {
        ConfigHelper.initProperties(BetweenlandsConfig.class, null, post);
    }

    private static void initProperties(Class<?> cls, @Nullable Object inst, boolean post) {
        for (Field f : cls.getDeclaredFields()) {
            if (!Modifier.isPublic(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) != (inst == null)) continue;
            if (ConfigProperty.class.isAssignableFrom(f.getType())) {
                try {
                    ConfigProperty property = (ConfigProperty)f.get(inst);
                    if (property == null) continue;
                    if (!post) {
                        property.init();
                        continue;
                    }
                    property.postInitGame();
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
            if (FieldWrapper.hasWrapperFor((Field)f) || f.getType().getSuperclass() == null || !f.getType().getSuperclass().equals(Object.class) || f.isAnnotationPresent(Config.Ignore.class)) continue;
            try {
                Object obj = f.get(inst);
                if (obj == null) continue;
                ConfigHelper.initProperties(obj.getClass(), obj, post);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

