/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config;

import java.io.File;
import net.minecraftforge.common.config.Config;
import thebetweenlands.common.config.properties.BlockListProperty;
import thebetweenlands.common.config.properties.IntSetProperty;
import thebetweenlands.common.config.properties.ItemDecayFoodProperty;
import thebetweenlands.common.config.properties.ItemListProperty;
import thebetweenlands.common.config.properties.PortalDimensionWhitelist;
import thebetweenlands.common.config.properties.PortalTargetList;
import thebetweenlands.common.config.properties.StringSetProperty;

@Config(modid="thebetweenlands", category="", name="thebetweenlands/config")
public class BetweenlandsConfig {
    @Config.Ignore
    public static File configDir;
    @Config.Ignore
    private static final String LANG_PREFIX = "config.thebetweenlands.";
    @Config.Name(value="world_and_dimension")
    @Config.LangKey(value="config.thebetweenlands.world_and_dimension")
    public static final WorldAndDimension WORLD_AND_DIMENSION;
    @Config.Name(value="rendering")
    @Config.LangKey(value="config.thebetweenlands.rendering")
    public static final Rendering RENDERING;
    @Config.Name(value="general")
    @Config.LangKey(value="config.thebetweenlands.general")
    public static final General GENERAL;
    @Config.Name(value="mob_spawning")
    @Config.LangKey(value="config.thebetweenlands.mob_spawning")
    public static final MobSpawning MOB_SPAWNING;
    @Config.Name(value="compatibility")
    @Config.LangKey(value="config.thebetweenlands.compatibility")
    public static final Compatibility COMPATIBILITY;
    @Config.Name(value="online_event_overrides")
    @Config.LangKey(value="config.thebetweenlands.online_event_overrides")
    public static final EventOverrides EVENT_OVERRIDES;
    @Config.Name(value="debug")
    @Config.LangKey(value="config.thebetweenlands.debug")
    public static final Debug DEBUG;

    static {
        WORLD_AND_DIMENSION = new WorldAndDimension();
        RENDERING = new Rendering();
        GENERAL = new General();
        MOB_SPAWNING = new MobSpawning();
        COMPATIBILITY = new Compatibility();
        EVENT_OVERRIDES = new EventOverrides();
        DEBUG = new Debug();
    }

    public static class Debug {
        @Config.Name(value="debug_mode")
        @Config.LangKey(value="config.thebetweenlands.debug_mode")
        @Config.Comment(value={"If true, enables debug mode with additional features for testing or development"})
        public boolean debug = false;
        @Config.Name(value="debug_model_loader")
        @Config.LangKey(value="config.thebetweenlands.debug_model_loader")
        @Config.Comment(value={"If true, enables the model loader debug logger"})
        public boolean debugModelLoader = false;
        @Config.Name(value="debug_recipe_overrides")
        @Config.LangKey(value="config.thebetweenlands.debug_recipe_overrides")
        @Config.Comment(value={"If true, enables the recipe overrides debug logger"})
        public boolean debugRecipeOverrides = false;
        @Config.Name(value="dump_packed_textures")
        @Config.LangKey(value="config.thebetweenlands.dump_packed_textures")
        @Config.Comment(value={"If true, mod will dump the packed model textures on startup"})
        public boolean dumpPackedTextures = false;
    }

    public static class EventOverrides {
        @Config.Name(value="online_event_overrides_enabled")
        @Config.LangKey(value="config.thebetweenlands.online_event_overrides_enabled")
        @Config.Comment(value={"If true this allows the developers to remotely enable certain environment events (such as the seasonal events for example) over a file hosted on our repository (https://raw.githubusercontent.com/Angry-Pixel/The-Betweenlands/environment_event_overrides/overrides.json). If you do not wish to use this feature it can be fully disabled by setting this to false"})
        public boolean onlineEnvironmentEventOverrides = true;
        @Config.Name(value="check_interval")
        @Config.LangKey(value="config.thebetweenlands.check_interval")
        @Config.Comment(value={"Check interval in seconds"})
        @Config.RangeInt(min=60, max=0x6666666)
        public int checkInterval = 1800;
        @Config.Name(value="failed_recheck_interval")
        @Config.LangKey(value="config.thebetweenlands.failed_recheck_interval")
        @Config.Comment(value={"Recheck interval in seconds if previous check has failed"})
        @Config.RangeInt(min=10, max=0x6666666)
        public int failedRecheckInterval = 60;
        @Config.Name(value="failed_recheck_count")
        @Config.LangKey(value="config.thebetweenlands.failed_recheck_count")
        @Config.Comment(value={"How many times a connection can fail before the '(Default) Remote Reset Time' starts counting down and how many times 'Failed Recheck Interval' is used before falling back to 'Check Interval'"})
        @Config.RangeInt(min=0)
        public int failedRecheckCount = 3;
        @Config.Name(value="default_remote_reset_time")
        @Config.LangKey(value="config.thebetweenlands.default_remote_reset_time")
        @Config.Comment(value={"Default time in seconds before an event that no longer has an override resets its state"})
        @Config.RangeInt(min=0, max=0x6666666)
        public int defaultRemoteResetTime = 180;
    }

    public static class Compatibility {
        @Config.Name(value="show_non_bl_fluids")
        @Config.LangKey(value="config.thebetweenlands.show_non_bl_fluids")
        @Config.Comment(value={"If fluids from other mods should show in BL buckets in the creative tab or in JEI"})
        public boolean showNonBLFluids = true;
        @Config.Name(value="show_non_bl_gem_recipes")
        @Config.LangKey(value="config.thebetweenlands.show_non_bl_gem_recipes")
        @Config.Comment(value={"If true, non BL items will show in the JEI recipe for middle gems"})
        public boolean showNonBLGemRecipes = true;
    }

    public static class MobSpawning {
        @Config.Name(value="max_entities_per_loaded_area")
        @Config.LangKey(value="config.thebetweenlands.max_entities_per_loaded_area")
        @Config.Comment(value={"The maximum amount of naturally spawned entities per loaded area (in most cases this means per player)"})
        @Config.RangeInt(min=0)
        public int maxEntitiesPerLoadedArea = 250;
        @Config.Name(value="hard_entity_limit")
        @Config.LangKey(value="config.thebetweenlands.hard_entity_limit")
        @Config.Comment(value={"The maximum amount of naturally spawned entities in the Betweenlands per world"})
        @Config.RangeInt(min=0)
        public int hardEntityLimit = 600;
    }

    public static class General {
        @Config.Name(value="bl_main_menu")
        @Config.LangKey(value="config.thebetweenlands.bl_main_menu")
        @Config.Comment(value={"If true, the main menu will be replaced by the Betweenlands main menu"})
        public boolean blMainMenu = true;
        @Config.Name(value="rowboat_view")
        @Config.LangKey(value="config.thebetweenlands.rowboat_view")
        @Config.Comment(value={"If true, the camera perspective will be switch to rowboat when you enter a rowboat, otherwise first-person"})
        public boolean rowboatView = true;
        @Config.Name(value="use_food_sickness")
        @Config.LangKey(value="config.thebetweenlands.use_food_sickness")
        @Config.Comment(value={"If true the food sickness system will be enabled in the Betweenlands"})
        public boolean useFoodSicknessInBetweenlands = true;
        @Config.Name(value="use_food_sickness_outside_betweenlands")
        @Config.LangKey(value="config.thebetweenlands.use_food_sickness_outside_betweenlands")
        @Config.Comment(value={"If true the food sickness system will be enabled outside the Betweenlands"})
        public boolean useFoodSicknessOutsideBetweenlands = false;
        @Config.Name(value="reverse_rotten_food")
        @Config.LangKey(value="config.thebetweenlands.reverse_rotten_food")
        @Config.Comment(value={"Whether rotten food should turn back into normal food when leaving the dimension"})
        public boolean reverseRottenFood = true;
        @Config.Name(value="use_rotten_food")
        @Config.LangKey(value="config.thebetweenlands.use_rotten_food")
        @Config.Comment(value={"Whether food from the overworld should rot when going into the dimension"})
        public boolean useRottenFood = true;
        @Config.Name(value="use_decay")
        @Config.LangKey(value="config.thebetweenlands.use_decay")
        @Config.Comment(value={"Whether the player decay mechanics should be active in the dimension"})
        public boolean useDecay = true;
        @Config.Name(value="decay_dimension_list")
        @Config.LangKey(value="config.thebetweenlands.decay_dimension_list")
        @Config.Comment(value={"List of dimension IDs where decay should also be enabled if decay is enabled"})
        public int[] decayDimensionList = new int[0];
        @Config.Ignore
        public final IntSetProperty decayDimensionListSet = new IntSetProperty(() -> BetweenlandsConfig.GENERAL.decayDimensionList);
        @Config.Name(value="decay_food_list")
        @Config.LangKey(value="config.thebetweenlands.decay_food_list")
        @Config.Comment(value={"A list of items that can heal decay. Syntax is \"modid:itemname:meta/decay/saturation\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] decayFoodListUnparsed = new String[0];
        @Config.Ignore
        public final ItemDecayFoodProperty decayFoodList = new ItemDecayFoodProperty(() -> BetweenlandsConfig.GENERAL.decayFoodListUnparsed);
        @Config.Name(value="use_corrosion")
        @Config.LangKey(value="config.thebetweenlands.use_corrosion")
        @Config.Comment(value={"Whether the tool corrosion mechanics should be active in the dimension"})
        public boolean useCorrosion = true;
        @Config.Name(value="use_tool_weakness")
        @Config.LangKey(value="config.thebetweenlands.use_tool_weakness")
        @Config.Comment(value={"Whether overworld tools should be weakened in the dimension"})
        public boolean useToolWeakness = true;
        @Config.Name(value="use_torch_blacklist")
        @Config.LangKey(value="config.thebetweenlands.use_torch_blacklist")
        @Config.Comment(value={"Whether torches should turn into damp torches in the dimension"})
        public boolean useTorchBlacklist = true;
        @Config.Name(value="use_fire_tool_blacklist")
        @Config.LangKey(value="config.thebetweenlands.use_fire_tool_blacklist")
        @Config.Comment(value={"Whether fire tools (e.g. Flint and Steel) should be blacklisted from working in the dimension"})
        public boolean useFireToolBlacklist = true;
        @Config.Name(value="use_potion_blacklist")
        @Config.LangKey(value="config.thebetweenlands.use_potion_blacklist")
        @Config.Comment(value={"Whether potions should turn into tainted potions in the dimension"})
        public boolean usePotionBlacklist = true;
        @Config.Name(value="use_fertilizer_blacklist")
        @Config.LangKey(value="config.thebetweenlands.use_fertilizer_blacklist")
        @Config.Comment(value={"Whether fertilizers (e.g. Bonemeal) should be blacklisted from working in the dimension"})
        public boolean useFertilizerBlacklist = true;
        @Config.Name(value="caving_rope_indicator")
        @Config.LangKey(value="config.thebetweenlands.caving_rope_indicator")
        @Config.Comment(value={"Adds an indicator next to the crosshair that shows whether the player is connected to the caving rope and how much rope is left"})
        public boolean cavingRopeIndicator = true;
        @Config.Name(value="override_conflicting_vanilla_recipes")
        @Config.LangKey(value="config.thebetweenlands.override_conflicting_vanilla_recipes")
        @Config.Comment(value={"If true, Betweenlands recipes that conflict with oredict'd vanilla recipes will take priority over the vanilla recipes (should be true unless you intend to fix the recipes yourself with another mod)"})
        @Config.RequiresMcRestart
        public boolean overrideConflictingVanillaRecipes = true;
        @Config.Name(value="override_any_conflicting_recipes")
        @Config.LangKey(value="config.thebetweenlands.override_any_conflicting_recipes")
        @Config.Comment(value={"If true, Betweenlands recipes that conflict with any oredict'd recipes will take priority over the oredict'd recipes (should be true unless you intend to fix the recipes yourself with another mod)"})
        @Config.RequiresMcRestart
        public boolean overrideAnyConflictingRecipes = true;
        @Config.Name(value="rotten_food_whitelist")
        @Config.LangKey(value="config.thebetweenlands.rotten_food_whitelist")
        @Config.Comment(value={"A list of items that should be whitelisted from rotting in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] rottenFoodWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty rottenFoodWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.rottenFoodWhitelistUnparsed);
        @Config.Name(value="rotten_food_blacklist")
        @Config.LangKey(value="config.thebetweenlands.rotten_food_blacklist")
        @Config.Comment(value={"A list of items that should turn into Rotten Food in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] rottenFoodBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty rottenFoodBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.rottenFoodBlacklistUnparsed);
        @Config.Name(value="tainting_whitelist")
        @Config.LangKey(value="config.thebetweenlands.tainting_whitelist")
        @Config.Comment(value={"A list of items that should be whitelisted from turning into Tainted Potions in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] taintingWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty taintingWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.taintingWhitelistUnparsed);
        @Config.Name(value="tainting_blacklist")
        @Config.LangKey(value="config.thebetweenlands.tainting_blacklist")
        @Config.Comment(value={"A list of items that should turn into Tainted Potions in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] taintingBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty taintingBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.taintingBlacklistUnparsed);
        @Config.Name(value="fire_tool_whitelist")
        @Config.LangKey(value="config.thebetweenlands.fire_tool_whitelist")
        @Config.Comment(value={"A list of items that should be allowed to create fire in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] fireToolWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty fireToolWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.fireToolWhitelistUnparsed);
        @Config.Name(value="fire_tool_blacklist")
        @Config.LangKey(value="config.thebetweenlands.fire_tool_blacklist")
        @Config.Comment(value={"A list of items that should not be able to create fire in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] fireToolBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty fireToolBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.fireToolBlacklistUnparsed);
        @Config.Name(value="fertilizer_whitelist")
        @Config.LangKey(value="config.thebetweenlands.fertilizer_whitelist")
        @Config.Comment(value={"A list of items that should be allowed to fertilize plants in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] fertilizerWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty fertilizerWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.fertilizerWhitelistUnparsed);
        @Config.Name(value="fertilizer_blacklist")
        @Config.LangKey(value="config.thebetweenlands.fertilizer_blacklist")
        @Config.Comment(value={"A list of items that should not be able to fertilize plants in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] fertilizerBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty fertilizerBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.fertilizerBlacklistUnparsed);
        @Config.Name(value="tool_weakness_whitelist")
        @Config.LangKey(value="config.thebetweenlands.tool_weakness_whitelist")
        @Config.Comment(value={"A list of items that should not be weakened in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] toolWeaknessWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty toolWeaknessWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.toolWeaknessWhitelistUnparsed);
        @Config.Name(value="tool_weakness_blacklist")
        @Config.LangKey(value="config.thebetweenlands.tool_weakness_blacklist")
        @Config.Comment(value={"A list of items that should be weakened in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] toolWeaknessBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty toolWeaknessBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.toolWeaknessBlacklistUnparsed);
        @Config.Name(value="torch_whitelist")
        @Config.LangKey(value="config.thebetweenlands.torch_whitelist")
        @Config.Comment(value={"A list of items that should not turn into damp torches when placed in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] torchWhitelistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty torchWhitelist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.torchWhitelistUnparsed);
        @Config.Name(value="torch_blacklist")
        @Config.LangKey(value="config.thebetweenlands.torch_blacklist")
        @Config.Comment(value={"A list of items that should turn into damp torches when placed in the dimension. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] torchBlacklistUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty torchBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.torchBlacklistUnparsed);
        @Config.Name(value="pouch_blacklist")
        @Config.LangKey(value="config.thebetweenlands.pouch_blacklist")
        @Config.Comment(value={"A list of items that should not be allowed in the lurker skin pouch. Syntax is \"modid:itemname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] pouchBlackListUnparsed = new String[0];
        @Config.Ignore
        public final ItemListProperty pouchBlacklist = new ItemListProperty(() -> BetweenlandsConfig.GENERAL.pouchBlackListUnparsed);
        @Config.Name(value="moving_wall_blacklist")
        @Config.LangKey(value="config.thebetweenlands.moving_wall_blacklist")
        @Config.Comment(value={"A list of blocks that should not be broken by the moving walls. Syntax is \"modid:blockname:meta\", meta can be * for wildcard, if no meta is provided 0 is used"})
        public String[] movingWallBlacklistUnparsed = new String[]{"tombmanygraves:grave_block"};
        @Config.Ignore
        public final BlockListProperty movingWallBlacklist = new BlockListProperty(() -> BetweenlandsConfig.GENERAL.movingWallBlacklistUnparsed);
        @Config.Name(value="caving_rope_despawn_time")
        @Config.LangKey(value="config.thebetweenlands.caving_rope_despawn_time")
        @Config.Comment(value={"After how many seconds caving rope should despawn after the player is no longer connected"})
        @Config.RangeInt(min=0, max=0x6666666)
        public int cavingRopeDespawnTime = 1200;
        @Config.Name(value="equipment_hotbar_side")
        @Config.LangKey(value="config.thebetweenlands.equipment_hotbar_side")
        @Config.Comment(value={"Change this to 1 or 0 to change on which side of the hotbar the equipment is shown"})
        @Config.RangeInt(min=0, max=1)
        public int equipmentHotbarSide = 0;
        @Config.Name(value="equipment_visible")
        @Config.LangKey(value="config.thebetweenlands.equipment_visible")
        @Config.Comment(value={"Whether equipment should be shown on the HUD"})
        public boolean equipmentVisible = true;
        @Config.Name(value="equipment_horziontal_spacing")
        @Config.LangKey(value="config.thebetweenlands.equipment_horziontal_spacing")
        @Config.Comment(value={"Horizontal spacing between equipment items"})
        @Config.RangeInt(min=-32, max=32)
        public int equipmentHorizontalSpacing = 8;
        @Config.Name(value="equipment_vertical_spacing")
        @Config.LangKey(value="config.thebetweenlands.equipment_vertical_spacing")
        @Config.Comment(value={"Vertical spacing between equipment items"})
        @Config.RangeInt(min=-32, max=32)
        public int equipmentVerticalSpacing = -13;
        @Config.Name(value="equipment_zone")
        @Config.LangKey(value="config.thebetweenlands.equipment_zone")
        @Config.Comment(value={"Zone in which the equipment items are shown on the HUD.\n0: Hotbar\n1: Top left\n2: Top right\n3: Bottom right\n4: Bottom left\n5: Center left\n6: Center top\n7: Center right\n8: Center bottom"})
        @Config.RangeInt(min=0, max=8)
        public int equipmentZone = 0;
        @Config.Name(value="equipment_zone_offset_x")
        @Config.LangKey(value="config.thebetweenlands.equipment_zone_offset_x")
        @Config.Comment(value={"X offset of the equipment items relative to the equipment zone"})
        public int equipmentOffsetX = 0;
        @Config.Name(value="equipment_zone_offset_y")
        @Config.LangKey(value="config.thebetweenlands.equipment_zone_offset_y")
        @Config.Comment(value={"Y offset of the equipment items relative to the equipment zone"})
        public int equipmentOffsetY = 0;
        @Config.Name(value="decay_bar_zone")
        @Config.LangKey(value="config.thebetweenlands.decay_bar_zone")
        @Config.Comment(value={"Zone in which the decay bar is shown on the HUD.\n0: Hotbar\n1: Top left\n2: Top right\n3: Bottom right\n4: Bottom left\n5: Center left\n6: Center top\n7: Center right\n8: Center bottom"})
        @Config.RangeInt(min=0, max=8)
        public int decayBarZone = 0;
        @Config.Name(value="decay_bar_zone_offset_x")
        @Config.LangKey(value="config.thebetweenlands.decay_bar_zone_offset_x")
        @Config.Comment(value={"X offset of the decay bar relative to the decay zone"})
        public int decayBarOffsetX = 0;
        @Config.Name(value="decay_bar_zone_offset_y")
        @Config.LangKey(value="config.thebetweenlands.decay_bar_zone_offset_y")
        @Config.Comment(value={"Y offset of the decay bar relative to the decay zone"})
        public int decayBarOffsetY = 0;
        @Config.Name(value="decay_percentage")
        @Config.LangKey(value="config.thebetweenlands.decay_percentage")
        @Config.Comment(value={"Whether the decay health reduction should be percentual"})
        public boolean decayPercentual = false;
        @Config.Name(value="decay_min_health")
        @Config.LangKey(value="config.thebetweenlands.decay_min_health")
        @Config.Comment(value={"Minimum player health when absolute decay is applied"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public float decayMinHealth = 6.0f;
        @Config.Name(value="decay_min_health_percent")
        @Config.LangKey(value="config.thebetweenlands.decay_min_health_percent")
        @Config.Comment(value={"Minimum player health percentage when percentual decay is applied"})
        @Config.RangeDouble(min=0.0, max=3.4028234663852886E38)
        public float decayMinHealthPercentage = 0.15f;
        @Config.Name(value="item_usage_tooltip")
        @Config.LangKey(value="config.thebetweenlands.item_usage_tooltip")
        @Config.Comment(value={"Whether the item usage tooltip (\"Used In: Infuser, Compost Bin\" etc.) should be shown"})
        public boolean itemUsageTooltip = true;
        @Config.Name(value="online_gallery")
        @Config.LangKey(value="config.thebetweenlands.online_gallery")
        @Config.Comment(value={"Whether the online fan art gallery picture frame should be enabled and be allowed to download fan art that has been manually picked by the developers to be shown in the gallery picture frame"})
        public boolean onlineGallery = true;
    }

    public static class Rendering {
        @Config.Name(value="wisp_quality")
        @Config.LangKey(value="config.thebetweenlands.wisp_quality")
        @Config.RangeInt(min=0, max=100)
        public int wispQuality = 50;
        @Config.Name(value="use_shader")
        @Config.LangKey(value="config.thebetweenlands.use_shader")
        @Config.Comment(value={"Some features in the Betweenlands use shaders for special effects. If you don't have a dedicated graphics card or want to use other mods with shaders you should set this to false. May have an impact on performance depending on your computer. Forces FBOs to be enabled"})
        public boolean useShader = true;
        @Config.Name(value="shader_priority")
        @Config.LangKey(value="config.thebetweenlands.shader_priority")
        @Config.Comment(value={"Shader rendering priority. Some other mods are not compatible with Betweenlands shaders (e.g. LadyLib/Dissolution) due to order conflicts. If you run into such an incompatibility try using a different priority. However rendering the shader earlier may introduce other rendering artifacts so this should be left as default if there are no conflicts.\n0: Late (Default)\n1: Normal\n2: Early"})
        @Config.RangeInt(min=0, max=2)
        public int shaderPriority = 0;
        @Config.Name(value="dimension_shader_only")
        @Config.LangKey(value="config.thebetweenlands.dimension_shader_only")
        @Config.Comment(value={"Whether the shaders should only be active in the Betweenlands dimension (if they are enabled)"})
        public boolean dimensionShaderOnly = false;
        @Config.Name(value="fullbright_blocks")
        @Config.LangKey(value="config.thebetweenlands.fullbright_blocks")
        @Config.Comment(value={"Some blocks glow in the dark (eg Life Crystal Ore) which doesn't work in some cases. If you run into problems like broken textures for such blocks then set this to false"})
        @Config.RequiresMcRestart
        public boolean fullbrightBlocks = true;
        @Config.Name(value="sky_texture_resolution")
        @Config.LangKey(value="config.thebetweenlands.sky_texture_resolution")
        @Config.Comment(value={"Only works when shaders are enabled. Determines the resolution of the shader sky texture. Bigger resolutions may have a bad impact on performance"})
        @Config.RangeInt(min=16)
        @Config.RequiresMcRestart
        public int skyResolution = 1024;
        @Config.Name(value="sky_rift_clouds")
        @Config.LangKey(value="config.thebetweenlands.sky_rift_clouds")
        @Config.Comment(value={"Whether clouds should be rendered in sky rifts"})
        public boolean skyRiftClouds = true;
    }

    public static class WorldAndDimension {
        @Config.Name(value="dimension_id")
        @Config.LangKey(value="config.thebetweenlands.dimension_id")
        @Config.RequiresMcRestart
        public int dimensionId = 20;
        @Config.Name(value="druid_circle_frequency")
        @Config.LangKey(value="config.thebetweenlands.druid_circle_frequency")
        @Config.Comment(value={"Higher numbers decrease rate"})
        @Config.RangeInt(min=2)
        public int druidCircleFrequency = 80;
        @Config.Name(value="dimension_brightness")
        @Config.LangKey(value="config.thebetweenlands.dimension_brightness")
        @Config.RangeInt(min=0, max=100)
        public int dimensionBrightness = 75;
        @Config.Name(value="enable_seasonal_events")
        @Config.LangKey(value="config.thebetweenlands.enable_seasonal_events")
        @Config.Comment(value={"If true seasonal events will occur during special periods during a year"})
        public boolean enableSeasonalEvents = true;
        @Config.Name(value="portal_dimension_whitelist")
        @Config.LangKey(value="config.thebetweenlands.portal_dimension_whitelist")
        @Config.Comment(value={"Betweenlands portals will only work in these dimensions"})
        public int[] portalDimensionWhitelist = new int[]{0, -1};
        @Config.Ignore
        public final IntSetProperty portalDimensionWhitelistSet = new PortalDimensionWhitelist();
        @Config.Name(value="portal_default_return_dimension")
        @Config.LangKey(value="config.thebetweenlands.portal_default_return_dimension")
        @Config.Comment(value={"The return dimension that is used when creating a portal in the Betweenlands dimension and entering it for the first time"})
        public int portalDefaultReturnDimension = 0;
        @Config.Name(value="portal_max_link_dist")
        @Config.LangKey(value="config.thebetweenlands.portal_max_link_dist")
        @Config.Comment(value={"The maximum link distance in blocks between two portals"})
        public int portalMaxLinkDist = 1500;
        @Config.Name(value="activate_rift_on_first_join")
        @Config.LangKey(value="config.thebetweenlands.activate_rift_on_first_join")
        @Config.Comment(value={"If true, the Rift will appear whenever a player joins the dimension for the first time"})
        public boolean activateRiftOnFirstJoin = true;
        @Config.Name(value="activate_rift_on_first_join_duration")
        @Config.LangKey(value="config.thebetweenlands.activate_rift_on_first_join_duration")
        @Config.Comment(value={"Minimum duration in seconds the rift should stay active when a player joins the dimension for the first time. See 'Activate Rift On First Join'"})
        @Config.RangeInt(min=0, max=0x6666666)
        public int minRiftOnFirstJoinDuration = 1800;
        @Config.Name(value="start_in_betweenlands")
        @Config.LangKey(value="config.thebetweenlands.start_in_betweenlands")
        @Config.Comment(value={"If true, the players will directly start out in the Betweenlands instead of the Overworld"})
        public boolean startInBetweenlands = false;
        @Config.Name(value="start_in_portal")
        @Config.LangKey(value="config.thebetweenlands.start_in_portal")
        @Config.Comment(value={"If \"Start in Betweenlands\" is enabled: whether a portal should be generated at the spawn and the players should spawn in it"})
        public boolean startInPortal = false;
        @Config.Name(value="portal_dimension_targets")
        @Config.LangKey(value="config.thebetweenlands.portal_dimension_targets")
        @Config.Comment(value={"Custom saplings or blocks can be specified here to work with the Swamp Talisman. Syntax is \"modid:blockname:meta/dim\", meta can be * for wildcard, if no meta is provided 0 is used. The dimension (\"dim\") specifies to which dimension the portal will lead to"})
        public String[] portalDimensionTargets = new String[0];
        @Config.Ignore
        public final PortalTargetList portalDimensionTargetsList = new PortalTargetList();
        @Config.Name(value="portal_unsafe_biomes")
        @Config.LangKey(value="config.thebetweenlands.portal_unsafe_biomes")
        @Config.Comment(value={"A list of unsafe biomes for the portal to try avoid generating in"})
        public String[] portalUnsafeBiomes = new String[]{"minecraft:ocean", "minecraft:river", "minecraft:frozen_ocean", "minecraft:frozen_river", "minecraft:mushroom_island_shore", "minecraft:beaches", "minecraft:deep_ocean", "minecraft:stone_beach", "minecraft:cold_beach"};
        @Config.Ignore
        public final StringSetProperty portalUnsafeBiomesSet = new StringSetProperty(() -> this.portalUnsafeBiomes);
        @Config.Name(value="portal_biome_search_range")
        @Config.LangKey(value="config.thebetweenlands.portal_biome_search_range")
        @Config.Comment(value={"The biome search range used to find a suitable biome when a portal is generated. If you find that a suitable biome isn't found reliably enough this can be increased at the cost of taking more time to generate portals"})
        @Config.RangeInt(min=16, max=0x7FFFFFFF)
        public int portalBiomeSearchRange = 256;
        @Config.Name(value="generate_portal_in_end")
        @Config.LangKey(value="config.thebetweenlands.generate_portal_in_end")
        @Config.Comment(value={"Whether custom portals that teleport to the End should create a Portal Tree in the End"})
        public boolean generatePortalInEnd = false;
    }
}

