/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.api.capability.ICustomStepSoundCapability;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.block.property.PropertyIntegerUnlisted;
import thebetweenlands.common.entity.WeedWoodBushUncollidableEntity;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class BlockWeedwoodBush
extends Block
implements IShearable,
ISickleHarvestable,
ITintedBlock,
IFarmablePlant {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyIntegerUnlisted POS_X = new PropertyIntegerUnlisted("pos_x");
    public static final PropertyIntegerUnlisted POS_Y = new PropertyIntegerUnlisted("pos_x");
    public static final PropertyIntegerUnlisted POS_Z = new PropertyIntegerUnlisted("pos_z");

    public BlockWeedwoodBush() {
        super(Material.field_151585_k);
        this.func_149711_c(0.35f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH, UP, DOWN}, new IUnlistedProperty[]{POS_X, POS_Y, POS_Z});
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)ItemMisc.EnumItemMisc.WEEDWOOD_STICK.create(1));
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.ITEMS_MISC;
    }

    public int func_180651_a(IBlockState state) {
        return ItemMisc.EnumItemMisc.WEEDWOOD_STICK.getID();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177978_c()))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177974_f()))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177968_d()))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177976_e()))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177984_a()))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos.func_177977_b())));
    }

    public boolean canConnectTo(IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == this;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess worldIn, BlockPos pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        return state.withProperty((IUnlistedProperty)POS_X, (Object)pos.func_177958_n()).withProperty((IUnlistedProperty)POS_Y, (Object)pos.func_177956_o()).withProperty((IUnlistedProperty)POS_Z, (Object)pos.func_177952_p());
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (entityIn instanceof EntityPlayer || entityIn instanceof WeedWoodBushUncollidableEntity) {
            return;
        }
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        ICustomStepSoundCapability cap;
        if (entity instanceof EntityPlayer) {
            entity.field_70159_w *= 0.06;
            entity.field_70179_y *= 0.06;
        }
        if (entity.field_70170_p.field_72995_K && (cap = (ICustomStepSoundCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_CUSTOM_STEP_SOUND, null)) != null && entity.field_82151_R > cap.getNextWeedwoodBushStep()) {
            AxisAlignedBB aabb = entity.func_174813_aQ();
            for (BlockPos.MutableBlockPos checkPos : BlockPos.func_177975_b((BlockPos)new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), (BlockPos)new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f))) {
                if (entity.field_70170_p.func_180495_p((BlockPos)checkPos).func_177230_c() != BlockRegistry.WEEDWOOD_BUSH) continue;
                BlockWeedwoodBush.spawnLeafParticles(entity.field_70170_p, (BlockPos)checkPos, Math.min((entity.field_82151_R - cap.getNextWeedwoodBushStep()) * 40.0f, 1.0f));
            }
            entity.field_70170_p.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundRegistry.GECKO_HIDE, SoundCategory.BLOCKS, 0.4f, entity.field_70170_p.field_73012_v.nextFloat() * 0.3f + 0.7f, false);
            cap.setNextWeeedwoodBushStep(entity.field_82151_R + 0.8f);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemShears) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.025f);
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(BlockRegistry.WEEDWOOD_BUSH);
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    protected static void spawnLeafParticles(World world, BlockPos pos, float strength) {
        int leafCount = (int)(60.0f * strength) + 1;
        float x = (float)pos.func_177958_n() + 0.5f;
        float y = (float)pos.func_177956_o() + 0.5f;
        float z = (float)pos.func_177952_p() + 0.5f;
        while (leafCount-- > 0) {
            float dx = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
            float dy = world.field_73012_v.nextFloat() * 2.0f - 0.5f;
            float dz = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
            float mag = 0.01f + world.field_73012_v.nextFloat() * 0.07f;
            BLParticles.WEEDWOOD_LEAF.spawn(world, x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(dx * mag, dy * mag, dz * mag));
        }
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public boolean canSpreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        return world.func_175623_d(targetPos) && this.func_176196_c(world, targetPos);
    }

    @Override
    public float getSpreadChance(World world, BlockPos pos, IBlockState state, BlockPos taretPos, Random rand) {
        return 0.35f;
    }

    @Override
    public void spreadTo(World world, BlockPos pos, IBlockState state, BlockPos targetPos, Random rand) {
        world.func_175656_a(targetPos, this.func_176223_P());
    }

    @Override
    public void decayPlant(World world, BlockPos pos, IBlockState state, Random rand) {
        world.func_175698_g(pos);
    }

    @Override
    public int getCompostCost(World world, BlockPos pos, IBlockState state, Random rand) {
        return 2;
    }
}

