/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.misc.ItemBarrel;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntityBarrel;

public class BlockBarrel
extends BasicBlock
implements ITileEntityProvider,
BlockRegistry.ICustomItemBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private final boolean isHeatResistant;

    public BlockBarrel(IBlockState material, boolean isHeatResistant) {
        super(material.func_185904_a());
        this.func_149672_a(material.func_177230_c().func_185467_w());
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isHeatResistant = isHeatResistant;
    }

    public boolean isHeatResistant(World world, BlockPos pos, IBlockState state) {
        return this.isHeatResistant;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileEntityBarrel) {
            IItemHandler playerInventory;
            IFluidHandler handler;
            TileEntityBarrel tile = (TileEntityBarrel)world.func_175625_s(pos);
            if (player.func_70093_af()) {
                return false;
            }
            if (!heldItem.func_190926_b() && (handler = (IFluidHandler)heldItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null && (playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                FluidActionResult fluidActionResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)tile, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!world.field_72995_K ? 1 : 0) != 0);
                if (fluidActionResult.isSuccess()) {
                    if (!world.field_72995_K) {
                        player.func_184611_a(hand, fluidActionResult.getResult());
                    }
                    return true;
                }
                fluidActionResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)tile, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player, (!world.field_72995_K ? 1 : 0) != 0);
                if (fluidActionResult.isSuccess()) {
                    if (!world.field_72995_K) {
                        player.func_184611_a(hand, fluidActionResult.getResult());
                    }
                    return true;
                }
            }
            if (!world.field_72995_K && tile != null) {
                player.openGui((Object)TheBetweenlands.instance, 16, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBarrel();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public ItemBlock getItemBlock() {
        return new ItemBarrel(this);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        Item item;
        TileEntity te;
        if (!worldIn.field_72995_K && !player.func_184812_l_() && worldIn.func_82736_K().func_82766_b("doTileDrops") && (te = worldIn.func_175625_s(pos)) instanceof TileEntityBarrel && (item = Item.func_150898_a((Block)worldIn.func_180495_p(pos).func_177230_c())) instanceof ItemBarrel) {
            InventoryHelper.func_180173_a((World)worldIn, (double)((double)pos.func_177958_n() + 0.5), (double)((double)pos.func_177956_o() + 0.5), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)((ItemBarrel)item).fromBarrel((TileEntityBarrel)te));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && world.func_175625_s(pos) instanceof TileEntityBarrel) {
            TileEntityBarrel tile = (TileEntityBarrel)world.func_175625_s(pos);
            tile.fill(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 500), true);
        }
    }
}

