/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.advancments;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import thebetweenlands.common.advancments.BLTrigger;

public class SwatShieldTrigger
extends BLTrigger<Instance, Listener> {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "swat_shield");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Listener createListener(PlayerAdvancements playerAdvancements) {
        return new Listener(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        EntityPredicate entityPredicates = EntityPredicate.func_192481_a((JsonElement)json.get("entity"));
        return new Instance(entityPredicates);
    }

    public void trigger(EntityPlayerMP player, EntityLivingBase entity) {
        Listener listener = (Listener)this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.trigger(player, entity);
        }
    }

    public void revert(EntityPlayerMP player) {
        Listener listener = (Listener)this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.revert();
        }
    }

    static class Listener
    extends BLTrigger.Listener<Instance> {
        public Listener(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        public void trigger(EntityPlayerMP player, EntityLivingBase entity) {
            ArrayList<ICriterionTrigger.Listener> list = new ArrayList<ICriterionTrigger.Listener>();
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(player, entity)) continue;
                list.add(listener);
                break;
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }

        public void revert() {
            ArrayList<Tuple> criterions = new ArrayList<Tuple>();
            for (ICriterionTrigger.Listener listener : this.listeners) {
                AdvancementProgress progress = this.playerAdvancements.func_192747_a(listener.field_192161_b);
                if (progress.func_192105_a() || !progress.func_192108_b()) continue;
                for (Map.Entry entry : listener.field_192161_b.func_192073_f().entrySet()) {
                    CriterionProgress criterionProgress;
                    if (!(((Criterion)entry.getValue()).func_192143_a() instanceof Instance) || (criterionProgress = progress.func_192106_c((String)entry.getKey())) == null || !criterionProgress.func_192151_a()) continue;
                    criterions.add(new Tuple((Object)listener.field_192161_b, entry.getKey()));
                }
            }
            for (Tuple criterion : criterions) {
                this.playerAdvancements.func_192744_b((Advancement)criterion.func_76341_a(), (String)criterion.func_76340_b());
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final EntityPredicate entity;

        public Instance(EntityPredicate entity) {
            super(ID);
            this.entity = entity;
        }

        public boolean test(EntityPlayerMP player, EntityLivingBase entity) {
            return this.entity.func_192482_a(player, (Entity)entity);
        }
    }
}

