/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.common.block.terrain.BlockWisp;

public class ParticleWisp
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private float prevFlameScale;
    private float flameScale;
    private int brightness;

    protected ParticleWisp(World world, double x, double y, double z, double mx, double my, double mz, float scale, int bright) {
        super(world, x, y, z, mx, my, mz);
        this.field_187129_i = this.field_187129_i * 0.01 + mx;
        this.field_187130_j = this.field_187130_j * 0.01 + my;
        this.field_187131_k = this.field_187131_k * 0.01 + mz;
        this.field_187126_f = this.field_187123_c = (x += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187127_g = this.field_187124_d = (y += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187128_h = this.field_187125_e = (z += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.flameScale = scale;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 1000;
        this.brightness = bright;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float currentX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks);
        float currentY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks);
        float currentZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks);
        this.field_70544_f = this.prevFlameScale + (this.flameScale - this.prevFlameScale) * partialTicks;
        float distance = 0.0f;
        if (!BlockWisp.canSee(this.field_187122_b, new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h))) {
            distance = MathHelper.func_76131_a((float)ParticleWisp.getDistanceToViewer(currentX, currentY, currentZ, partialTicks), (float)10.0f, (float)20.0f);
        }
        this.func_82338_g(1.0f - MathHelper.func_76126_a((float)(0.15707964f * distance)));
        float scale = 0.1f * this.field_70544_f;
        float minU = this.field_187119_C.func_94209_e();
        float maxU = this.field_187119_C.func_94212_f();
        float minV = this.field_187119_C.func_94206_g();
        float maxV = this.field_187119_C.func_94210_h();
        float borderU = (maxU - minU) / (float)this.field_187119_C.func_94211_a();
        float borderV = (maxV - minV) / (float)this.field_187119_C.func_94216_b();
        minU += borderU;
        maxU -= borderU;
        minV += borderV;
        maxV -= borderV;
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        buff.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buff.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buff.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buff.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public int func_189214_a(float partialTicks) {
        if (this.brightness < 0) {
            return super.func_189214_a(partialTicks);
        }
        return this.brightness;
    }

    public static float getDistanceToViewer(double x, double y, double z, float partialRenderTicks) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null) {
            double dx = (double)((float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialRenderTicks)) - x;
            double dy = (double)((float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialRenderTicks)) - y;
            double dz = (double)((float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialRenderTicks)) - z;
            return MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz)));
        }
        return 0.0f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevFlameScale = this.flameScale;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.96;
        this.field_187131_k *= 0.96;
        if (this.field_70546_d++ >= this.field_70547_e || this.flameScale <= 0.0f) {
            this.func_187112_i();
        }
        if (this.field_70546_d != 0) {
            if (this.flameScale > 0.0f) {
                this.flameScale = (float)((double)this.flameScale - 0.025);
            }
            this.field_187130_j += 8.0E-5;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleWisp> {
        public Factory() {
            super(ParticleWisp.class, ParticleTextureStitcher.create(ParticleWisp.class, new ResourceLocation("thebetweenlands:particle/wisp")));
        }

        @Override
        public ParticleWisp createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleWisp(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.scale, args.data.getInt(0));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(255);
        }
    }
}

