/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.util.ModelConverter;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.TexturePacker;
import thebetweenlands.util.Vec3UV;

public class ModelFromModelBase
implements IModel,
TexturePacker.ITexturePackable {
    public final ResourceLocation texture;
    public final ResourceLocation particleTexture;
    public final int width;
    public final int height;
    public final IVertexProcessor vertexProcessor;
    public final boolean ambientOcclusion;
    public final boolean doubleFace;
    public final ModelBase model;
    public final ModelConverter.Model convertedModel;
    @Nullable
    protected final TexturePacker packer;
    protected final Set<ResourceLocation> usedTextures = new HashSet<ResourceLocation>();
    protected final Map<ModelCacheKey, ModelConverter.Model> derivativeModelCache;

    public ModelFromModelBase(ModelFromModelBase parent, ResourceLocation particleTexture, int width, int height, @Nullable IVertexProcessor vertexProcessor, boolean doubleFace, boolean ambientOcclusion) {
        this.derivativeModelCache = parent.derivativeModelCache;
        this.packer = null;
        this.model = parent.model;
        this.texture = parent.texture;
        this.width = width;
        this.height = height;
        this.vertexProcessor = vertexProcessor;
        this.particleTexture = particleTexture;
        this.convertedModel = parent.convertedModel;
        this.doubleFace = doubleFace;
        this.ambientOcclusion = ambientOcclusion;
        if (this.particleTexture != null) {
            this.usedTextures.add(this.particleTexture);
        }
    }

    protected ModelFromModelBase(Builder builder) {
        this(new HashMap<ModelCacheKey, ModelConverter.Model>(), builder.packer, builder.explicitNoPacker, builder.model, builder.texture, builder.particleTexture, builder.width, builder.height, builder.vertexProcessor, builder.doubleFace, builder.ambientOcclusion);
    }

    private ModelFromModelBase(Map<ModelCacheKey, ModelConverter.Model> modelCache, TexturePacker packer, boolean explicitNoPacker, ModelBase model, ResourceLocation texture, ResourceLocation particleTexture, int width, int height, @Nullable IVertexProcessor vertexProcessor, boolean doubleFace, boolean ambientOcclusion) {
        if (!explicitNoPacker) {
            Preconditions.checkNotNull((Object)packer, (Object)"Texture packer should not be null for non-derived models! If required set packer to null explicitly.");
        }
        this.derivativeModelCache = modelCache;
        this.packer = packer;
        this.model = model;
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.vertexProcessor = vertexProcessor;
        this.particleTexture = particleTexture;
        this.doubleFace = doubleFace;
        this.ambientOcclusion = ambientOcclusion;
        ModelCacheKey key = new ModelCacheKey(model, texture, vertexProcessor);
        ModelConverter.Model cachedConvertedModel = this.derivativeModelCache.get(key);
        if (cachedConvertedModel == null) {
            ModelConverter converter = new ModelConverter(packer != null ? new ModelConverter.Packing(texture, width, height, packer, this) : null, model, 0.0625, this.doubleFace);
            cachedConvertedModel = converter.getModel();
            this.derivativeModelCache.put(key, cachedConvertedModel);
        }
        this.convertedModel = cachedConvertedModel;
        if (this.particleTexture != null) {
            this.usedTextures.add(this.particleTexture);
        }
        if (packer == null) {
            this.usedTextures.add(this.texture);
        }
    }

    private ModelFromModelBase(Map<ModelCacheKey, ModelConverter.Model> modelCache, ModelBase model, ModelConverter.Model convertedModel, ResourceLocation texture, ResourceLocation particleTexture, int width, int height, @Nullable IVertexProcessor vertexProcessor, boolean doubleFace, boolean ambientOcclusion) {
        this.derivativeModelCache = modelCache;
        this.packer = null;
        this.model = model;
        this.texture = texture;
        this.width = width;
        this.height = height;
        this.vertexProcessor = vertexProcessor;
        this.particleTexture = particleTexture;
        this.convertedModel = convertedModel;
        this.doubleFace = doubleFace;
        this.ambientOcclusion = ambientOcclusion;
        if (this.particleTexture != null) {
            this.usedTextures.add(this.particleTexture);
        }
    }

    @Override
    public void onPacked() {
        for (ModelConverter.Box box : this.convertedModel.getBoxes()) {
            for (ModelConverter.Quad quad : box.getQuads()) {
                for (Vec3UV vert : quad.getVertices()) {
                    this.usedTextures.add(vert.packedQuad.getPackedLocation());
                }
            }
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.usedTextures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new ModelBakedModelBase(this.vertexProcessor, state.apply(Optional.empty()), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, format, this.convertedModel, bakedTextureGetter, bakedTextureGetter.apply(this.texture), bakedTextureGetter.apply(this.particleTexture), this.width, this.height, this.ambientOcclusion);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public ModelFromModelBase process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        ResourceLocation particleTexture = this.particleTexture;
        if (customData.containsKey((Object)"particle_texture")) {
            particleTexture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"particle_texture")), (String)"particle_texture"));
        }
        if (particleTexture == null) {
            particleTexture = TextureMap.field_174945_f;
        }
        boolean ambientOcclusion = this.ambientOcclusion;
        if (customData.containsKey((Object)"ambient_occlusion")) {
            ambientOcclusion = JsonUtils.func_151216_b((JsonElement)parser.parse((String)customData.get((Object)"ambient_occlusion")), (String)"ambient_occlusion");
        }
        boolean doubleFace = this.doubleFace;
        if (customData.containsKey((Object)"double_face")) {
            doubleFace = JsonUtils.func_151216_b((JsonElement)parser.parse((String)customData.get((Object)"double_face")), (String)"double_face");
        }
        ResourceLocation texture = this.texture;
        if (customData.containsKey((Object)"texture")) {
            texture = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"texture")), (String)"texture"));
        }
        if (texture == null) {
            texture = TextureMap.field_174945_f;
        }
        if (Objects.equal((Object)texture, (Object)this.texture)) {
            return new ModelFromModelBase(this.derivativeModelCache, this.model, this.convertedModel, texture, particleTexture, this.width, this.height, this.vertexProcessor, doubleFace, ambientOcclusion);
        }
        return new ModelFromModelBase(this.derivativeModelCache, this.packer, this.packer == null, this.model, texture, particleTexture, this.width, this.height, this.vertexProcessor, doubleFace, ambientOcclusion);
    }

    public static class ModelBakedModelBase
    implements IBakedModel {
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        protected final VertexFormat format;
        protected final TextureAtlasSprite particleTexture;
        protected final boolean ambientOcclusion;
        protected List<BakedQuad> quads;

        protected ModelBakedModelBase(IVertexProcessor vertexProcessor, Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, ModelConverter.Model convertedModel, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, TextureAtlasSprite texture, TextureAtlasSprite particleTexture, int width, int height, boolean ambientOcclusion) {
            this.transformation = transformation.orElse(null);
            this.transforms = transforms;
            this.format = format;
            this.particleTexture = particleTexture;
            QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation);
            for (ModelConverter.Box box : convertedModel.getBoxes()) {
                for (ModelConverter.Quad quad : box.getQuads()) {
                    for (int i = 0; i < quad.getVertices().length; ++i) {
                        Vec3UV vert = quad.getVertices()[i];
                        TextureAtlasSprite quadSprite = vert.packedQuad != null ? bakedTextureGetter.apply(vert.packedQuad.getPackedLocation()) : texture;
                        float u = vert.getU(16.0f, width);
                        float v = vert.getV(16.0f, height);
                        if (vertexProcessor != null) {
                            vert = vertexProcessor.process(vert, quad, box, builder);
                        }
                        if (vert == null) continue;
                        builder.setSprite(quadSprite);
                        builder.addVertex(vert.x + 0.5, 1.5 - vert.y, vert.z + 0.5, u, v);
                    }
                }
            }
            this.quads = builder.build().nonCulledQuads;
            this.ambientOcclusion = ambientOcclusion;
        }

        public List<BakedQuad> func_188616_a(IBlockState stateOld, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    public static class Builder {
        private ModelBase model;
        private ResourceLocation texture;
        private ResourceLocation particleTexture;
        private int width;
        private int height;
        @Nullable
        private IVertexProcessor vertexProcessor;
        private boolean doubleFace = true;
        private boolean explicitNoPacker = false;
        @Nullable
        private TexturePacker packer;
        private boolean ambientOcclusion = true;

        public Builder(ModelBase model, ResourceLocation texture, int width, int height) {
            this.model = model;
            this.texture = this.particleTexture = texture;
            this.width = width;
            this.height = height;
        }

        public Builder packer(@Nullable TexturePacker packer) {
            this.packer = packer;
            this.explicitNoPacker = packer == null;
            return this;
        }

        public Builder processor(@Nullable IVertexProcessor vertexProcessor) {
            this.vertexProcessor = vertexProcessor;
            return this;
        }

        public Builder texture(ResourceLocation texture, int width, int height) {
            this.texture = texture;
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder particleTexture(ResourceLocation particleTexture) {
            this.particleTexture = particleTexture;
            return this;
        }

        public Builder doubleFace(boolean doubleFace) {
            this.doubleFace = doubleFace;
            return this;
        }

        public Builder ambientOcclusion(boolean ao) {
            this.ambientOcclusion = ao;
            return this;
        }

        public ModelFromModelBase build() {
            return new ModelFromModelBase(this);
        }
    }

    private static class ModelCacheKey {
        private final String model;
        private final ResourceLocation texture;
        private final String vertexProcessor;

        private ModelCacheKey(ModelBase model, ResourceLocation texture, IVertexProcessor vertexProcessor) {
            this.model = model.getClass().getName();
            this.texture = texture;
            this.vertexProcessor = vertexProcessor == null ? "null" : vertexProcessor.getClass().getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
            result = 31 * result + (this.texture == null ? 0 : this.texture.hashCode());
            result = 31 * result + (this.vertexProcessor == null ? 0 : this.vertexProcessor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelCacheKey other = (ModelCacheKey)obj;
            if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
                return false;
            }
            if (this.texture == null ? other.texture != null : !this.texture.equals((Object)other.texture)) {
                return false;
            }
            return !(this.vertexProcessor == null ? other.vertexProcessor != null : !this.vertexProcessor.equals(other.vertexProcessor));
        }
    }

    public static interface IVertexProcessor {
        public Vec3UV process(Vec3UV var1, ModelConverter.Quad var2, ModelConverter.Box var3, QuadBuilder var4);
    }
}

