/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.audio.ambience.AmbienceType;

@SideOnly(value=Side.CLIENT)
public class AmbienceSound
extends MovingSound {
    private boolean fadeOut = false;
    private boolean isLowPriority = false;
    public final EntityPlayer player;
    public final AmbienceType type;
    public final AmbienceManager mgr;

    public AmbienceSound(SoundEvent sound, SoundCategory category, AmbienceType type, EntityPlayer player, AmbienceManager mgr) {
        super(sound, category);
        this.type = type;
        this.player = player;
        this.field_147659_g = true;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147662_b = 0.1f;
        this.field_147663_c = this.type.getPitch();
        this.mgr = mgr;
    }

    public void func_73660_a() {
        if (this.player == null || this.player.field_70170_p == null) {
            this.stopImmediately();
            return;
        }
        this.field_147660_d = (float)this.player.field_70165_t;
        this.field_147661_e = (float)this.player.field_70163_u;
        this.field_147658_f = (float)this.player.field_70161_v;
        if (!this.field_147668_j) {
            this.field_147663_c = this.type.getPitch();
        }
        float desiredVolume = this.type.getVolume();
        int fadeTicks = Math.max(this.type.getFadeTime(), 1);
        float incr = Math.max((this.field_147662_b + Math.abs(desiredVolume - this.field_147662_b)) / (float)fadeTicks, 0.001f);
        if (this.isStopping()) {
            desiredVolume = 0.0f;
        }
        if (this.isLowPriority) {
            desiredVolume = Math.min(desiredVolume, this.mgr.getLowerPriorityVolume());
        }
        if (this.field_147662_b > desiredVolume) {
            this.field_147662_b -= incr;
            if (this.field_147662_b < desiredVolume) {
                this.field_147662_b = desiredVolume;
                if (this.isStopping()) {
                    this.field_147668_j = true;
                }
            }
        } else if (this.field_147662_b < desiredVolume) {
            this.field_147662_b += incr;
            if (this.field_147662_b > desiredVolume) {
                this.field_147662_b = desiredVolume;
            }
        }
        if (this.field_147662_b <= 0.0f && this.isStopping()) {
            this.field_147668_j = true;
        }
        if (this.field_147668_j) {
            this.field_147659_g = false;
        }
    }

    public void stop() {
        this.fadeOut = true;
    }

    public boolean isFadingOut() {
        return this.fadeOut;
    }

    public void cancelFade() {
        this.fadeOut = false;
    }

    public void stopImmediately() {
        this.field_147668_j = true;
        this.field_147659_g = false;
    }

    public boolean isStopping() {
        return this.field_147668_j || this.fadeOut || !this.type.isActive();
    }

    void setLowPriority(boolean lowPriority) {
        this.isLowPriority = lowPriority;
    }
}

