/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.item;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.util.NBTHelper;

public interface ICorrodible {
    @SideOnly(value=Side.CLIENT)
    @Nullable
    default public ResourceLocation[] getCorrodibleVariants() {
        return null;
    }

    public static <I extends Item> ResourceLocation[] getItemCorrodibleVariants(I item) {
        ResourceLocation[] variants = ((ICorrodible)item).getCorrodibleVariants();
        if (variants == null) {
            return new ResourceLocation[]{item.getRegistryName()};
        }
        return variants;
    }

    default public int getMaxCoating(ItemStack stack) {
        return 600;
    }

    default public int getMaxCorrosion(ItemStack stack) {
        return 255;
    }

    default public int getCoating(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("Coating", 3)) {
            return nbt.func_74762_e("Coating");
        }
        return 0;
    }

    default public int getCorrosion(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("Corrosion", 3)) {
            return nbt.func_74762_e("Corrosion");
        }
        return 0;
    }

    default public void setCoating(ItemStack stack, int coating) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74768_a("Coating", coating);
    }

    default public void setCorrosion(ItemStack stack, int corrosion) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74768_a("Corrosion", corrosion);
    }
}

