/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModCreativeTabs;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockTank
extends BlockContainer {
    protected BlockTank() {
        super(Material.field_151592_s);
        this.func_149663_c("tank");
        this.setRegistryName("tank");
        this.func_149647_a(ModCreativeTabs.TAB_CAR);
        this.func_149711_c(0.5f);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack stack = new ItemStack((Block)this);
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityTank)) {
            BlockTank.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            BlockTank.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound comp = new NBTTagCompound();
        fluid.writeToNBT(comp);
        compound.func_74782_a("fluid", (NBTBase)comp);
        stack.func_77982_d(compound);
        BlockTank.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound fluidComp;
        FluidStack fluidStack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)(fluidComp = stack.func_77978_p().func_74775_l("fluid")))) != null) {
            tooltip.add(new TextComponentTranslation("tooltip.fluid", new Object[]{fluidStack.getLocalizedName()}).func_150254_d());
            tooltip.add(new TextComponentTranslation("tooltip.amount", new Object[]{fluidStack.amount}).func_150254_d());
        }
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound comp = stack.func_77978_p();
        if (!comp.func_74764_b("fluid")) {
            return;
        }
        NBTTagCompound fluidTag = comp.func_74775_l("fluid");
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityTank)) {
            return;
        }
        TileEntityTank tank = (TileEntityTank)te;
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        tank.setFluid(fluidStack);
        tank.synchronize();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTank();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack == null) {
            return false;
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack != null) {
            BlockTank.handleEmpty(stack, worldIn, pos, playerIn, hand);
            return true;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler != null) {
            BlockTank.handleFill(stack, worldIn, pos, playerIn, hand);
            return true;
        }
        return false;
    }

    public static boolean handleEmpty(ItemStack stack, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
        if (res.isSuccess()) {
            playerIn.func_184611_a(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(ItemStack stack, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((IInventory)playerIn.field_71071_by);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (EntityPlayer)playerIn, (boolean)true);
        if (result.isSuccess()) {
            playerIn.func_184611_a(hand, result.result);
            return true;
        }
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }
}

