/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.BlockLureTree;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;

public class TileEntityLureTree
extends TileEntityBase
implements ITickable {
    private static ArrayList<TreeFood> TREE_FOODS = new ArrayList();
    int currentFood = 0;
    int chargeTicks = 0;
    private static ArrayList<Class<? extends Entity>> BLACKLIST = new ArrayList();

    public static ArrayList<TreeFood> getTreeFoods() {
        return TREE_FOODS;
    }

    public static void addTreeFood(TreeFood recipe) {
        TREE_FOODS.add(recipe);
    }

    public static void addTreeFood(ItemStack stack, int amount) {
        TREE_FOODS.add(new TreeFood(stack, amount));
    }

    public static TreeFood getTreeFood(ItemStack stack) {
        for (TreeFood food : TREE_FOODS) {
            if (!food.matches(stack)) continue;
            return food;
        }
        return null;
    }

    public static void addBlacklistEntry(Class<? extends Entity> entity) {
        BLACKLIST.add(entity);
    }

    public void func_73660_a() {
        if (!this.isDead() && this.currentFood > 0) {
            if (this.chargeTicks < InteractionBWA.MAXCHARGE) {
                ++this.chargeTicks;
                --this.currentFood;
            } else if (!this.field_145850_b.field_72995_K) {
                if (this.attractAnimals(this.field_145850_b.field_73012_v.nextInt(2) + 1)) {
                    this.chargeTicks = 0;
                }
            } else {
                this.chargeTicks = 0;
            }
        }
    }

    public boolean attractAnimals(int amt) {
        List spawnable;
        Random random = this.field_145850_b.field_73012_v;
        Biome biome = this.field_145850_b.func_180494_b(this.field_174879_c);
        int spawned = 0;
        if (biome != null && !(spawnable = biome.func_76747_a(EnumCreatureType.CREATURE)).isEmpty()) {
            block2: for (int i = 0; i < amt; ++i) {
                Biome.SpawnListEntry entry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)random, (List)spawnable);
                int x = this.field_174879_c.func_177958_n() + random.nextInt(InteractionBWA.RADIUS * 2 + 1) - InteractionBWA.RADIUS;
                int z = this.field_174879_c.func_177952_p() + random.nextInt(InteractionBWA.RADIUS * 2 + 1) - InteractionBWA.RADIUS;
                if (BLACKLIST.contains(entry.field_76300_b)) continue;
                for (int y = this.field_174879_c.func_177956_o(); y > this.field_174879_c.func_177956_o() - 4; --y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.field_145850_b.func_175623_d(pos) && WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)this.field_145850_b, (BlockPos)pos)) {
                        EntityLiving entityliving;
                        try {
                            entityliving = (EntityLiving)entry.field_76300_b.getConstructor(World.class).newInstance(this.field_145850_b);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            continue;
                        }
                        entityliving.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        this.field_145850_b.func_72838_d((Entity)entityliving);
                        if (entityliving == null) continue block2;
                        entityliving.func_70656_aK();
                        ++spawned;
                        continue block2;
                    }
                    if (this.field_145850_b.isSideSolid(pos, EnumFacing.UP)) continue block2;
                }
            }
        }
        return spawned > 0;
    }

    public boolean isDead() {
        if (this.field_145850_b == null) {
            return true;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof BlockLureTree && (Boolean)state.func_177229_b((IProperty)BlockLureTree.ACTIVE) == false;
    }

    public boolean feed(ItemStack stack) {
        TreeFood food = TileEntityLureTree.getTreeFood(stack);
        if (food != null && this.currentFood < InteractionBWA.MAXFOOD - food.amount) {
            this.currentFood = Math.min(InteractionBWA.MAXFOOD, this.currentFood + food.amount);
            return true;
        }
        return false;
    }

    public boolean onActivated(EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing facing) {
        if (this.isDead()) {
            return false;
        }
        ItemStack insertstack = heldItem.func_77946_l();
        insertstack.func_190920_e(1);
        boolean flag = this.feed(insertstack);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (flag && state.func_177229_b((IProperty)BlockLureTree.FACING) == facing) {
            if (!playerIn.func_184812_l_()) {
                heldItem.func_190918_g(1);
                playerIn.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem.func_190916_E() == 0 ? ItemStack.field_190927_a : heldItem);
            }
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_74768_a("chargeticks", this.chargeTicks);
        compound.func_74768_a("food", this.currentFood);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.currentFood = compound.func_74762_e("food");
        this.chargeTicks = compound.func_74762_e("chargeticks");
    }

    public static class TreeFood {
        public ItemStack stack;
        public int amount;

        public TreeFood(ItemStack stack, int amount) {
            this.stack = stack;
            this.amount = amount;
        }

        public boolean matches(ItemStack stack) {
            return ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)stack);
        }
    }
}

