/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.item;

import betterwithaddons.BetterWithAddons;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemPaperArmor
extends ItemArmor
implements ISpecialArmor {
    public static final ItemArmor.ArmorMaterial PAPER = EnumHelper.addArmorMaterial((String)"paper", (String)"betterwithaddons:paper", (int)10, (int[])new int[]{1, 4, 5, 2}, (int)5, (SoundEvent)SoundEvents.field_187728_s, (float)0.0f);
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};

    public ItemPaperArmor(EntityEquipmentSlot equipmentSlotIn) {
        super(PAPER, 2, equipmentSlotIn);
        this.func_77637_a(BetterWithAddons.instance.creativeTab);
        MinecraftForge.EVENT_BUS.register(((Object)((Object)this)).getClass());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "betterwithaddons:textures/entity/paper" + (this.field_77881_a.func_188452_c() == 2 ? "2" : "1") + ".png";
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return true;
    }

    @SubscribeEvent
    public static void onWear(LivingEvent.LivingUpdateEvent event) {
        int equippedPieces = 0;
        EntityLivingBase entity = event.getEntityLiving();
        for (EntityEquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack armor = entity.func_184582_a(slot);
            if (!(armor.func_77973_b() instanceof ItemPaperArmor)) continue;
            ++equippedPieces;
            if (!entity.func_70027_ad()) continue;
            armor.func_77972_a(1, entity);
        }
        if (entity.func_70026_G() && equippedPieces > 0) {
            PotionEffect wetness = new PotionEffect(MobEffects.field_76421_d, 1200, Math.max(0, equippedPieces - 1), true, false);
            entity.func_70690_d(wetness);
        }
    }

    private int getWornPieces(EntityLivingBase player) {
        int equippedPieces = 0;
        for (EntityEquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack armor = player.func_184582_a(slot);
            if (!(armor.func_77973_b() instanceof ItemPaperArmor)) continue;
            ++equippedPieces;
        }
        return equippedPieces;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        ISpecialArmor.ArmorProperties armorProperties = new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
        armorProperties.Armor = this.field_77879_b + this.getWetnessBonus(entity);
        armorProperties.Toughness = this.field_189415_e;
        return armorProperties;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return this.getWetnessBonus((EntityLivingBase)player);
    }

    private int getWetnessBonus(EntityLivingBase entity) {
        return entity.func_70026_G() && this.getWornPieces(entity) > 3 ? 1 : 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
    }
}

