/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.crafting.manager.CraftingManagerSpindle;
import betterwithaddons.crafting.recipes.HopperCratingRecipe;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.interaction.ModInteractions;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.IngredientSized;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;

public class InteractionCondensedOutputs
extends Interaction {
    public static boolean ENABLED = true;
    public static boolean LOSE_BINDER = false;
    public static boolean CAULDRON_COMPRESSES_SLIME = true;
    public static boolean SPINDLE_COMPRESSES_BOLTS = true;
    public static boolean HOPPER_COMPRESSES_CRATES = true;
    public static int SPINUP_TIME = 40;
    public ItemStack bagStack;
    public ItemStack crateStack;
    public ItemStack congealedStack;
    public ItemStack boltStack;
    public ItemStack bundleStack;

    @Override
    protected String getName() {
        return "addons.CondensedOutputs";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the Condensed Outputs module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        LOSE_BINDER = this.loadPropBool("LoseBinder", "When uncrafting condensed materials, the binding material is not returned.", LOSE_BINDER);
        SPINDLE_COMPRESSES_BOLTS = this.loadPropBool("Spinning", "Whether the spindle can compress items into bolts.", SPINDLE_COMPRESSES_BOLTS);
        CAULDRON_COMPRESSES_SLIME = this.loadPropBool("Congealing", "Whether cauldrons can congeal items.", CAULDRON_COMPRESSES_SLIME);
        HOPPER_COMPRESSES_CRATES = this.loadPropBool("Crating", "Whether filtered hoppers can fill crates.", HOPPER_COMPRESSES_CRATES);
        this.doesNotNeedRestart(() -> {
            SPINUP_TIME = this.loadPropInt("SpindleTime", "The amount of time in ticks it takes for the spindle to spin up once.", SPINUP_TIME);
        });
    }

    @Override
    public boolean isActive() {
        return ENABLED;
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public List<Interaction> getDependencies() {
        return Arrays.asList(ModInteractions.bwm);
    }

    @Override
    public List<Interaction> getIncompatibilities() {
        return null;
    }

    @Override
    public void preInit() {
        ConditionModule.MODULES.put("CondensedOutputs", this::isActive);
    }

    @Override
    public void init() {
        if (!LOSE_BINDER) {
            ModItems.MATERIAL_BAG.setContainer(this.bagStack);
            ModItems.MATERIAL_CRATE.setContainer(this.crateStack);
            ModItems.MATERIAL_CONGEALED.setContainer(this.congealedStack);
            ModItems.MATERIAL_BOLT.setContainer(this.boltStack);
            ModItems.MATERIAL_BUNDLE.setContainer(this.bundleStack);
        }
        BWRegistry.CAULDRON.addUnstokedRecipe((Ingredient)StackIngredient.fromOre((int)9, (String)"dung"), new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.DUNG.getMeta()));
        CraftingManagerSpindle.getInstance().addRecipe(new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HEMP_CLOTH)}, IngredientSized.fromOredict("fiberHemp", 9), false);
        CraftingManagerSpindle.getInstance().addRecipe(new ItemStack[]{new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.ROPE.getMeta())}, IngredientSized.fromStacks(new ItemStack(BWMBlocks.ROPE, 9)), false);
    }

    @Override
    public void postInit() {
    }

    @Override
    void modifyRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry registry = (ForgeRegistry)event.getRegistry();
        this.bagStack = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HEMP_CLOTH, (int)1);
        this.crateStack = new ItemStack(Blocks.field_150344_f, 1);
        this.congealedStack = new ItemStack(Items.field_151123_aH, 1);
        this.boltStack = new ItemStack((Block)ModBlocks.SPINDLE, 1);
        this.bundleStack = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HEMP_FIBERS, (int)1);
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "seed", new ItemStack(Items.field_151014_N));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "seed_hemp", new ItemStack(BWMBlocks.HEMP));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "seed_melon", new ItemStack(Items.field_151081_bc));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "seed_pumpkin", new ItemStack(Items.field_151080_bb));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "seed_beets", new ItemStack(Items.field_185163_cU));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "cocoa", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "redstone", new ItemStack(Items.field_151137_ax));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "glowstone", new ItemStack(Items.field_151114_aO));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "sugar", new ItemStack(Items.field_151102_aT));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "gunpowder", new ItemStack(Items.field_151016_H));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "flour", new ItemStack(BWMBlocks.RAW_PASTRY, 1, BlockRawPastry.EnumType.BREAD.getMetadata()));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "sulfur", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.BRIMSTONE));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "nitre", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NITER));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "sawdust", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SAWDUST));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "sawdust_soul", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SOUL_DUST));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "potash", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.POTASH));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "hellfire", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        this.addBaggingRecipe((ForgeRegistry<IRecipe>)registry, "kibble", new ItemStack(BWMItems.KIBBLE));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "pork", new ItemStack(Items.field_151157_am));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "pork_raw", new ItemStack(Items.field_151147_al));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "steak", new ItemStack(Items.field_151083_be));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "steak_raw", new ItemStack(Items.field_151082_bd));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "chicken", new ItemStack(Items.field_151077_bg));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "chicken_raw", new ItemStack(Items.field_151076_bf));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "mutton", new ItemStack(Items.field_179557_bn));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "mutton_raw", new ItemStack(Items.field_179561_bm));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "rabbit", new ItemStack(Items.field_179559_bp));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "rabbit_raw", new ItemStack(Items.field_179558_bo));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "egg", new ItemStack(Items.field_151110_aK));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "slime", new ItemStack(Items.field_151123_aH));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "enderpearl", new ItemStack(Items.field_151079_bi));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "cactus", new ItemStack((Block)Blocks.field_150434_aF));
        this.addCratingRecipe((ForgeRegistry<IRecipe>)registry, "inksac", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "mushroom", new ItemStack((Block)Blocks.field_150338_P));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "amanita", new ItemStack((Block)Blocks.field_150337_Q));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "bone", new ItemStack(Items.field_151103_aS));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "flesh", new ItemStack(Items.field_151078_bh));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "eye", new ItemStack(Items.field_151070_bp));
        this.addCongealingRecipe((ForgeRegistry<IRecipe>)registry, "wart", new ItemStack(Items.field_151075_bm));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "fabric", "fabricHemp", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HEMP_CLOTH));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "vine", new ItemStack(Blocks.field_150395_bd));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "paper", "paper", new ItemStack(Items.field_151121_aF));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "leather", new ItemStack(Items.field_151116_aA));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "scoured_leather", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SCOURED_LEATHER));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "tanned_leather", ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.TANNED_LEATHER));
        this.addRollupRecipe((ForgeRegistry<IRecipe>)registry, "string", "string", new ItemStack(Items.field_151007_F));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "feather", new ItemStack(Items.field_151008_G));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "blazerods", new ItemStack(Items.field_151072_bj));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "arrows", new ItemStack(Items.field_151032_g));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "oak", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.OAK.func_176839_a()));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "birch", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.BIRCH.func_176839_a()));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "spruce", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a()));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "jungle", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.JUNGLE.func_176839_a()));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "acacia", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.ACACIA.func_176839_a()));
        this.addBundlingRecipe((ForgeRegistry<IRecipe>)registry, "darkoak", new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a()));
    }

    private void addBaggingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack material) {
        ItemStack output = ModItems.MATERIAL_BAG.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.bagStack);
        this.addUncondensingRecipe(registry, id, output, material);
    }

    private void addCratingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack material) {
        ItemStack output = ModItems.MATERIAL_CRATE.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.crateStack);
        this.addUncondensingRecipe(registry, id, output, material);
        if (HOPPER_COMPRESSES_CRATES) {
            HopperInteractions.addHopperRecipe((HopperInteractions.HopperRecipe)new HopperCratingRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{material}), output));
        }
    }

    private void addCongealingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack material) {
        ItemStack output = ModItems.MATERIAL_CONGEALED.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.congealedStack);
        this.addUncondensingRecipe(registry, id, output, material);
        if (CAULDRON_COMPRESSES_SLIME) {
            ItemStack material8 = material.func_77946_l();
            material8.func_190920_e(8);
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{this.getIngredient(this.congealedStack), this.getIngredient(material8)}), (List)Lists.newArrayList((Object[])new ItemStack[]{output}));
        }
    }

    private StackIngredient getIngredient(ItemStack stack) {
        return StackIngredient.fromStacks((ItemStack[])new ItemStack[]{stack});
    }

    private void addRollupRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack material) {
        ItemStack output = ModItems.MATERIAL_BOLT.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.boltStack);
        this.addUncondensingRecipe(registry, id, output, material);
        if (SPINDLE_COMPRESSES_BOLTS) {
            ItemStack material8 = material.func_77946_l();
            material8.func_190920_e(8);
            CraftingManagerSpindle.getInstance().addRecipe(new ItemStack[]{output}, IngredientSized.fromStacks(material8), true);
        }
    }

    private void addRollupRecipe(ForgeRegistry<IRecipe> registry, String id, String material, ItemStack materialStack) {
        ItemStack output = ModItems.MATERIAL_BOLT.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.boltStack);
        this.addUncondensingRecipe(registry, id, output, materialStack);
        if (SPINDLE_COMPRESSES_BOLTS) {
            CraftingManagerSpindle.getInstance().addRecipe(new ItemStack[]{output}, IngredientSized.fromOredict(material, 8), true);
        }
    }

    private void addBundlingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack material) {
        ItemStack output = ModItems.MATERIAL_BUNDLE.getMaterial(id);
        this.addCondensingRecipe(registry, id, output, material, this.bundleStack);
        this.addUncondensingRecipe(registry, id, output, material);
    }

    private void addCondensingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack output, ItemStack material, ItemStack frame) {
        ItemStack outmaterial = material.func_77946_l();
        outmaterial.func_190920_e(8);
        ResourceLocation compressLoc = new ResourceLocation("betterwithaddons", "compress_" + id);
        registry.register(new ShapedOreRecipe(compressLoc, output, new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), material, Character.valueOf('b'), frame}).setRegistryName(compressLoc));
    }

    private void addCondensingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack condensed, String material, ItemStack frame) {
        ResourceLocation compressLoc = new ResourceLocation("betterwithaddons", "compress_" + id);
        registry.register(new ShapedOreRecipe(compressLoc, condensed, new Object[]{"aaa", "aba", "aaa", Character.valueOf('a'), material, Character.valueOf('b'), frame}).setRegistryName(compressLoc));
    }

    private void addUncondensingRecipe(ForgeRegistry<IRecipe> registry, String id, ItemStack condensed, ItemStack material) {
        ItemStack outmaterial = material.func_77946_l();
        outmaterial.func_190920_e(8);
        ResourceLocation uncompressLoc = new ResourceLocation("betterwithaddons", "uncompress_" + id);
        registry.register(new ShapelessOreRecipe(uncompressLoc, outmaterial, new Object[]{condensed}).setRegistryName(uncompressLoc));
    }
}

