/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.crafting.recipes.DoorSawRecipe;
import betterwithaddons.handler.BurnHandler;
import betterwithaddons.handler.EggIncubationHandler;
import betterwithaddons.handler.SoapHandler;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.interaction.InteractionBWM;
import betterwithaddons.interaction.ModInteractions;
import betterwithaddons.item.ModItems;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.BlockRecipe;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.hardcore.world.HCBonemeal;
import betterwithmods.module.tweaks.MineshaftGeneration;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;

public class InteractionBTWTweak
extends Interaction {
    public static boolean ENABLED = true;
    public static boolean SAW_RECYCLING = true;
    public static boolean EGG_INCUBATION = true;
    public static boolean SLIPPERY_WHEN_WET = true;
    public static boolean ASH_FERTILIZER = true;
    public static boolean WOOL_RECYCLING = true;
    public static boolean LOGS_SMELT_TO_ASH = true;
    public static boolean LOGS_BURN_TO_ASH = true;
    public static boolean REPLACE_WRITABLE_BOOK_RECIPE = true;
    public static boolean RUSTY_MINESHAFTS = true;
    public static boolean INFESTED_MINESHAFTS = true;
    public static boolean BONEMEAL_TO_GLUE = false;
    public static int WRITING_TABLE_COST = 1;
    public static int EGG_INCUBATION_TIME = 5400;

    @Override
    protected String getName() {
        return "addons.BTWTweak";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the BTWTweak module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        SAW_RECYCLING = this.loadPropBool("SawRecycling", "Many wooden blocks can be recycled by putting them infront of a saw, at a bit of a loss.", SAW_RECYCLING);
        EGG_INCUBATION = this.loadPropBool("EggIncubation", "Allows eggs to be incubated into chicken by placing them on a Block of Padding with a lit Light Block above.", EGG_INCUBATION);
        SLIPPERY_WHEN_WET = this.loadPropBool("SlipperyWhenWet", "Water running over blocks of soap will make them slippery.", SLIPPERY_WHEN_WET);
        ASH_FERTILIZER = this.loadPropBool("AshFertilizer", "Potash is a valid fertilizer.", ASH_FERTILIZER);
        WOOL_RECYCLING = this.loadPropBool("WoolRecycling", "Wool can be rendered back into it's components. You might want to disable this if you use mods that violate Hardcore Shearing.", WOOL_RECYCLING);
        LOGS_SMELT_TO_ASH = this.loadPropBool("LogsSmeltToAsh", "Logs burn into ash in a furnace. This only works if they wouldn't burn into anything else.", LOGS_SMELT_TO_ASH);
        LOGS_BURN_TO_ASH = this.loadPropBool("LogsBurnToAsh", "Logs burn into ash in world.", LOGS_BURN_TO_ASH);
        REPLACE_WRITABLE_BOOK_RECIPE = this.loadPropBool("ReplaceWritableBookRecipe", "Changes writable books to require the Ink and Quill item.", REPLACE_WRITABLE_BOOK_RECIPE);
        RUSTY_MINESHAFTS = this.loadPropBool("RustedMineshafts", "Rails in Mineshafts are rusted and melt down into much less iron.", RUSTY_MINESHAFTS);
        INFESTED_MINESHAFTS = this.loadPropBool("InfestedMineshafts", "Logs in Mineshafts are infested by Termites and crumble into sawdust when harvested.", INFESTED_MINESHAFTS);
        BONEMEAL_TO_GLUE = this.loadPropBool("BonemealToGlue", "Bonemeal can be turned to glue in a stoked Crucible.", BONEMEAL_TO_GLUE);
        this.doesNotNeedRestart(() -> {
            WRITING_TABLE_COST = this.loadPropInt("WritingTableCost", "How many levels it costs to rename an item or create a nametag.", WRITING_TABLE_COST);
            EGG_INCUBATION_TIME = this.loadPropInt("EggIncubationTime", "How long it takes for an egg to hatch using incubation, in ticks.", EGG_INCUBATION_TIME);
        });
    }

    @Override
    public boolean isActive() {
        return ENABLED;
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public List<Interaction> getDependencies() {
        return Arrays.asList(ModInteractions.bwm);
    }

    @Override
    public List<Interaction> getIncompatibilities() {
        return null;
    }

    @Override
    public void preInit() {
        if (SLIPPERY_WHEN_WET) {
            MinecraftForge.EVENT_BUS.register((Object)new SoapHandler(BWMBlocks.AESTHETIC.func_176223_P().func_177226_a((IProperty)BlockAesthetic.TYPE, (Comparable)BlockAesthetic.EnumType.SOAP)));
        }
        if (EGG_INCUBATION) {
            MinecraftForge.EVENT_BUS.register((Object)new EggIncubationHandler());
        }
        if (REPLACE_WRITABLE_BOOK_RECIPE) {
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("minecraft", "writable_book"));
        }
        if (LOGS_BURN_TO_ASH) {
            MinecraftForge.EVENT_BUS.register(BurnHandler.class);
        }
        ConditionModule.MODULES.put("ReplaceWritableBookRecipe", () -> REPLACE_WRITABLE_BOOK_RECIPE);
    }

    @Override
    void modifyRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry registry = (ForgeRegistry)event.getRegistry();
        ResourceLocation resloc = new ResourceLocation("betterwithaddons", "ink_and_quill_conversion");
        registry.register(new ShapelessOreRecipe(resloc, new ItemStack((Item)ModItems.INK_AND_QUILL), new Object[]{ModItems.MATERIAL_TWEAK.getMaterial("ink_and_quill")}).setRegistryName(resloc));
    }

    @Override
    public void init() {
        if (ASH_FERTILIZER) {
            StackIngredient.mergeStacked((List)Lists.newArrayList((Object[])new StackIngredient[]{HCBonemeal.FERTILIZERS, StackIngredient.fromOre((String)"dustPotash"), StackIngredient.fromOre((String)"dustAsh")}));
        }
        ModItems.MATERIAL_TWEAK.setDisabled("ink_and_quill");
        if (RUSTY_MINESHAFTS) {
            MineshaftGeneration.rail = piece -> ModBlocks.RUSTY_RAIL.func_176223_P();
        }
        if (INFESTED_MINESHAFTS) {
            MineshaftGeneration.supports = piece -> ModBlocks.TERMITE_LOG.func_176223_P();
        }
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Block)ModBlocks.RUSTY_RAIL, 2), new ItemStack(Items.field_191525_da));
        BWRegistry.WOOD_SAW.addRecipe(new ItemStack((Block)ModBlocks.TERMITE_LOG, 1, Short.MAX_VALUE), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SAWDUST, (int)2));
        if (WOOL_RECYCLING && InteractionBWM.HARDCORE_SHEARING) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                BWRegistry.CAULDRON.addStokedRecipe(new ItemStack(Blocks.field_150325_L, 1, color.func_176765_a()), new ItemStack[]{new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.WICKER.getMeta()), ModItems.WOOL.getByColor(color, 4)}).setPriority(-1);
            }
        }
        if (BONEMEAL_TO_GLUE) {
            BWRegistry.CAULDRON.addStokedRecipe((Ingredient)StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 64, EnumDyeColor.WHITE.func_176767_b())}), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GLUE));
        }
        if (SAW_RECYCLING) {
            BlockPlanks.EnumType[] woodtypes;
            BWRegistry.WOOD_SAW.addRecipe(new ItemStack(Blocks.field_150342_X), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 4), new ItemStack(Items.field_151122_aG, 3)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack((Block)Blocks.field_150486_ae)}), this.getSiding(BlockPlanks.EnumType.OAK, 6));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_150421_aI)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 6), new ItemStack(Items.field_151045_i, 1)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_150468_ap)}), new ItemStack(Items.field_151055_y, 2));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_150323_B)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 6), new ItemStack(Items.field_151137_ax, 1)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_150415_aT)}), this.getSiding(BlockPlanks.EnumType.OAK, 2));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(BWMBlocks.WOODEN_AXLE)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getCorner(BlockPlanks.EnumType.OAK, 2), new ItemStack(BWMBlocks.ROPE, 1)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(BWMBlocks.BELLOWS)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 2), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.LEATHER_BELT), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GEAR), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.TANNED_LEATHER_CUT, (int)3)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(BWMBlocks.WOODEN_GEARBOX)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 3), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GEAR, (int)3), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.REDSTONE_LATCH)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{BlockMechMachines.getStack((BlockMechMachines.EnumType)BlockMechMachines.EnumType.HOPPER)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getMoulding(BlockPlanks.EnumType.OAK, 3), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GEAR, (int)1), new ItemStack(Blocks.field_150452_aw, 1)}));
            BWRegistry.WOOD_SAW.addRecipe(new ItemStack(BWMBlocks.PLATFORM), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getMoulding(BlockPlanks.EnumType.OAK, 3), new ItemStack(BWMBlocks.WICKER, 2)}));
            BWRegistry.WOOD_SAW.addRecipe(BlockMechMachines.getStack((BlockMechMachines.EnumType)BlockMechMachines.EnumType.PULLEY), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 3), new ItemStack(Items.field_151042_j), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GEAR), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.REDSTONE_LATCH)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(BWMBlocks.SAW)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 1), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.LEATHER_BELT), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.GEAR), new ItemStack(Items.field_151042_j, 2)}));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(BWMBlocks.PUMP)}), (List)Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 3), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SCREW), new ItemStack(BWMBlocks.GRATE, 1, BlockPlanks.EnumType.OAK.func_176839_a())}));
            for (BlockPlanks.EnumType woodtype : woodtypes = BlockPlanks.EnumType.values()) {
                BWRegistry.WOOD_SAW.addRecipe(new ItemStack(BWMBlocks.WOOD_BENCH, 1, woodtype.func_176839_a()), this.getCorner(woodtype, 2));
                BWRegistry.WOOD_SAW.addRecipe(new ItemStack(BWMBlocks.WOOD_TABLE, 1, woodtype.func_176839_a()), this.getCorner(woodtype, 3));
            }
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180413_ao, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.OAK, 4)}), new ItemStack(Items.field_179570_aq)));
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180412_aq, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.BIRCH, 4)}), new ItemStack(Items.field_179568_as)));
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180414_ap, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.SPRUCE, 4)}), new ItemStack(Items.field_179569_ar)));
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180411_ar, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.JUNGLE, 4)}), new ItemStack(Items.field_179567_at)));
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180410_as, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.ACACIA, 4)}), new ItemStack(Items.field_179572_au)));
            BWRegistry.WOOD_SAW.addRecipe((BlockRecipe)new DoorSawRecipe(Blocks.field_180409_at, Lists.newArrayList((Object[])new ItemStack[]{this.getSiding(BlockPlanks.EnumType.DARK_OAK, 4)}), new ItemStack(Items.field_179571_av)));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180390_bo)}), this.getMoulding(BlockPlanks.EnumType.OAK, 3));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180392_bq)}), this.getMoulding(BlockPlanks.EnumType.BIRCH, 3));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180391_bp)}), this.getMoulding(BlockPlanks.EnumType.SPRUCE, 3));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180386_br)}), this.getMoulding(BlockPlanks.EnumType.JUNGLE, 3));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180387_bt)}), this.getMoulding(BlockPlanks.EnumType.ACACIA, 3));
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)new BlockDropIngredient(new ItemStack[]{new ItemStack(Blocks.field_180385_bs)}), this.getMoulding(BlockPlanks.EnumType.DARK_OAK, 3));
        }
    }

    private ItemStack getSiding(BlockPlanks.EnumType type, int count) {
        return MiniBlocks.fromParent((Block)((Block)MiniBlocks.SIDINGS.get(Material.field_151575_d)), (IBlockState)Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)type), (int)count);
    }

    private ItemStack getMoulding(BlockPlanks.EnumType type, int count) {
        return MiniBlocks.fromParent((Block)((Block)MiniBlocks.MOULDINGS.get(Material.field_151575_d)), (IBlockState)Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)type), (int)count);
    }

    private ItemStack getCorner(BlockPlanks.EnumType type, int count) {
        return MiniBlocks.fromParent((Block)((Block)MiniBlocks.CORNERS.get(Material.field_151575_d)), (IBlockState)Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)type), (int)count);
    }

    @Override
    public void postInit() {
        if (LOGS_SMELT_TO_ASH) {
            for (ItemStack log : OreDictionary.getOres((String)"logWood")) {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(log);
                if (!result.func_190926_b()) continue;
                GameRegistry.addSmelting((ItemStack)log, (ItemStack)ModItems.MATERIAL_TWEAK.getMaterial("ash"), (float)0.1f);
            }
        }
    }
}

