/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.interaction.InteractionBWR;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAesthetic;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SoulSandHandler {
    private LinkedList<EntityXPOrb> TrackedItems = new LinkedList();
    private LinkedList<EntityXPOrb> TrackedItemsAdd = new LinkedList();
    private Iterator<EntityXPOrb> TrackedItemsIterator;

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        int xp;
        Entity entity = event.getEntity();
        if (entity instanceof EntityXPOrb && (xp = ((EntityXPOrb)entity).func_70526_d()) > 0) {
            this.TrackedItemsAdd.add((EntityXPOrb)entity);
        }
    }

    @SubscribeEvent
    public void xpTick(TickEvent.WorldTickEvent tickEvent) {
        World world = tickEvent.world;
        if (!world.field_72995_K) {
            this.handleXP();
        }
    }

    private void handleXP() {
        if (this.TrackedItemsIterator == null || !this.TrackedItemsIterator.hasNext()) {
            this.TrackedItems.addAll(this.TrackedItemsAdd);
            this.TrackedItemsAdd.clear();
            this.TrackedItemsIterator = this.TrackedItems.iterator();
        } else {
            EntityXPOrb entity = this.TrackedItemsIterator.next();
            World world = entity.field_70170_p;
            int xpValue = entity.func_70526_d();
            BlockPos pos = entity.func_180425_c();
            boolean remove = false;
            if (entity.field_70128_L) {
                remove = true;
            } else {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() != BWMBlocks.AESTHETIC || state.func_177229_b((IProperty)BlockAesthetic.TYPE) != BlockAesthetic.EnumType.DUNG) {
                    return;
                }
                if (!(this.isValidInfusionWall(world, pos.func_177984_a(), EnumFacing.DOWN) && this.isValidInfusionWall(world, pos.func_177977_b(), EnumFacing.UP) && this.isValidInfusionWall(world, pos.func_177968_d(), EnumFacing.NORTH) && this.isValidInfusionWall(world, pos.func_177978_c(), EnumFacing.SOUTH) && this.isValidInfusionWall(world, pos.func_177976_e(), EnumFacing.EAST) && this.isValidInfusionWall(world, pos.func_177974_f(), EnumFacing.WEST))) {
                    return;
                }
                AxisAlignedBB aabb = new AxisAlignedBB(pos);
                List orbs = world.func_72872_a(EntityXPOrb.class, aabb);
                int totalxp = 0;
                for (EntityXPOrb orb : orbs) {
                    totalxp += orb.func_70526_d();
                    orb.func_70106_y();
                }
                if (world.field_73012_v.nextInt(InteractionBWR.SOULSAND_INFUSION_THRESHOLD) < totalxp) {
                    world.func_175656_a(pos, Blocks.field_150425_aM.func_176223_P());
                    for (int i = 0; i < 3; ++i) {
                        world.func_175718_b(2004, pos, 0);
                    }
                }
            }
            if (remove) {
                this.TrackedItemsIterator.remove();
            }
        }
    }

    private boolean isValidInfusionWall(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return (double)state.func_185887_b(world, pos) >= 5.0 && state.isSideSolid((IBlockAccess)world, pos, facing);
    }
}

