/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithaddons.block.BetterRedstone.BlockPCB;
import betterwithaddons.block.BlockLattice;
import betterwithaddons.block.BlockRopeSideways;
import betterwithaddons.block.EriottoMod.BlockZenSand;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.interaction.InteractionBWM;
import betterwithaddons.item.ModItems;
import betterwithaddons.item.rbdtools.IConvenientTool;
import betterwithaddons.potion.ModPotions;
import betterwithaddons.util.InventoryUtil;
import betterwithmods.common.BWMBlocks;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AssortedHandler {
    static Random rng = new Random();
    private final int BossCleanupThreshold = 10;
    private final float HardnessThreshold = 5.0f;
    private HashMap<UUID, BossInfoServer> BossList = new HashMap();

    @SubscribeEvent
    public void tillZenGardenEvent(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = event.getItemStack();
        EnumFacing facing = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        EnumFacing tillDirection = player.func_174811_aO();
        BlockZenSand replaceSand = null;
        if (stack.func_77973_b() instanceof ItemHoe && facing == EnumFacing.UP) {
            if (state.func_177230_c() == Blocks.field_150354_m) {
                if (state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
                    replaceSand = ModBlocks.ZEN_RED_SAND;
                }
                if (state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.SAND) {
                    replaceSand = ModBlocks.ZEN_SAND;
                }
            } else if (state.func_177230_c() == Blocks.field_150425_aM) {
                replaceSand = ModBlocks.ZEN_SOUL_SAND;
            } else if (state.func_177230_c() == ModBlocks.IRON_SAND) {
                replaceSand = ModBlocks.ZEN_IRON_SAND;
            }
        }
        if (replaceSand != null) {
            world.func_175656_a(pos, replaceSand.func_176223_P().func_177226_a(BlockZenSand.SHAPE, (Comparable)((Object)BlockZenSand.SandDirection.getByDirections(tillDirection))));
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void attachPergolaEvent(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = event.getItemStack();
        EnumFacing facing = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        if (facing == null || facing.func_176740_k() == EnumFacing.Axis.Y) {
            return;
        }
        Ingredient rope = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BWMBlocks.ROPE));
        if (rope.apply(stack) && BlockRopeSideways.canFastenBlock(state.func_177230_c())) {
            int totalRope = !player.func_184812_l_() ? InventoryUtil.countItemInPlayer(rope, player) : InteractionBWA.ROPE_LIMIT;
            int consumedRope = this.attachRope(world, pos, facing, Math.min(totalRope, InteractionBWA.ROPE_LIMIT));
            if (consumedRope > 0) {
                if (!player.func_184812_l_()) {
                    InventoryUtil.consumeItemFromPlayer(rope, consumedRope, player);
                }
                event.setCancellationResult(EnumActionResult.SUCCESS);
                event.setCanceled(true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("info.rope.too_far", new Object[0]), true);
            }
        }
    }

    private int attachRope(World world, BlockPos pos, EnumFacing facing, int limit) {
        IBlockState checkState;
        int i;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos);
        int consumedRope = 0;
        for (i = 0; i <= limit; ++i) {
            checkPos.func_189536_c(facing);
            checkState = world.func_180495_p((BlockPos)checkPos);
            if (i > 0 && BlockRopeSideways.canFastenBlock(checkState.func_177230_c())) break;
            if (checkState.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos) || checkState.func_177230_c() == ModBlocks.ROPE_SIDEWAYS && !((BlockRopeSideways.EnumRopeShape)((Object)checkState.func_177229_b(BlockRopeSideways.SHAPE))).has(facing.func_176740_k())) continue;
            return 0;
        }
        if (i > limit) {
            return 0;
        }
        while (i > 0) {
            checkPos.func_189536_c(facing.func_176734_d());
            checkState = world.func_180495_p((BlockPos)checkPos);
            BlockRopeSideways.EnumRopeShape placedRope = facing.func_176740_k() == EnumFacing.Axis.X ? BlockRopeSideways.EnumRopeShape.X : BlockRopeSideways.EnumRopeShape.Z;
            IBlockState placedState = ModBlocks.ROPE_SIDEWAYS.func_176223_P().func_177226_a(BlockRopeSideways.SHAPE, (Comparable)((Object)placedRope));
            if (checkState.func_177230_c() == ModBlocks.ROPE_SIDEWAYS) {
                placedState = checkState.func_177226_a(BlockRopeSideways.SHAPE, (Comparable)((Object)((BlockRopeSideways.EnumRopeShape)((Object)checkState.func_177229_b(BlockRopeSideways.SHAPE))).add(placedRope)));
            }
            world.func_180501_a((BlockPos)checkPos, placedState, 2);
            ++consumedRope;
            --i;
        }
        return consumedRope;
    }

    @SubscribeEvent
    public void attachRopeEvent(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = event.getItemStack();
        EnumFacing facing = event.getFace();
        EntityPlayer player = event.getEntityPlayer();
        Ingredient rope = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)BWMBlocks.ROPE));
        if (rope.apply(stack) && state.func_177230_c() instanceof BlockFence && state.func_177230_c() != ModBlocks.ROPE_POST) {
            ModBlocks.ROPE_POST.placeFencePost(world, pos);
            state = world.func_180495_p(pos);
            int totalRope = !player.func_184812_l_() ? InventoryUtil.countItemInPlayer(rope, player) : InteractionBWA.ROPE_LIMIT + 1;
            int consumedRope = 1;
            if (BlockRopeSideways.canFastenBlock(state.func_177230_c())) {
                consumedRope += this.attachRope(world, pos, facing, Math.min(totalRope - 1, InteractionBWA.ROPE_LIMIT));
            }
            if (!player.func_184812_l_()) {
                InventoryUtil.consumeItemFromPlayer(rope, consumedRope, player);
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Items.field_151134_bR && InteractionBWM.HIDDEN_ENCHANTS) {
            event.getToolTip().clear();
            event.getToolTip().add(TextFormatting.WHITE + I18n.func_135052_a((String)"item.ancient_manuscript.name", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living == null || living.field_70170_p == null) {
            return;
        }
        Random rand = living.field_70170_p.field_73012_v;
        if (living instanceof EntityShulker && rand.nextFloat() < 1.0f) {
            event.getEntityLiving().func_70099_a(ModItems.MATERIAL.getMaterial("ender_cream", 1 + rand.nextInt(2)), 0.0f);
        }
    }

    @SubscribeEvent
    public void blockNeighborUpdate(BlockEvent.NeighborNotifyEvent notifyEvent) {
        World world = notifyEvent.getWorld();
        this.makeRedstonePCB(world, notifyEvent.getPos());
    }

    private void makeRedstonePCB(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        Block bottomblock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!world.field_72995_K && block instanceof BlockRedstoneWire && bottomblock instanceof BlockPCB) {
            world.func_175656_a(pos, ModBlocks.PCB_WIRE.func_176223_P());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void harvestBlock(BlockEvent.HarvestDropsEvent event) {
        ItemStack tool;
        Item item;
        IBlockState state = event.getState();
        EntityPlayer player = event.getHarvester();
        if (player != null && (item = (tool = player.func_184614_ca()).func_77973_b()) instanceof IConvenientTool) {
            IConvenientTool toolItem = (IConvenientTool)item;
            if (!toolItem.canCollect(tool, state)) {
                return;
            }
            for (ItemStack drop : event.getDrops()) {
                InventoryUtil.addItemToPlayer(player, drop);
            }
            event.getDrops().clear();
        }
    }

    @SubscribeEvent
    public void beginTrack(PlayerEvent.StartTracking trackEvent) {
        if (!trackEvent.getEntityPlayer().func_130014_f_().field_72995_K) {
            Entity target = trackEvent.getTarget();
            EntityPlayerMP player = (EntityPlayerMP)trackEvent.getEntityPlayer();
            UUID uuid = target.func_110124_au();
            if (this.BossList.containsKey(uuid)) {
                BossInfoServer bossInfo = this.BossList.get(uuid);
                bossInfo.func_186760_a(player);
            }
        }
    }

    @SubscribeEvent
    public void endTrack(PlayerEvent.StopTracking trackEvent) {
        if (!trackEvent.getEntityPlayer().func_130014_f_().field_72995_K) {
            Entity target = trackEvent.getTarget();
            EntityPlayerMP player = (EntityPlayerMP)trackEvent.getEntityPlayer();
            UUID uuid = target.func_110124_au();
            if (this.BossList.containsKey(uuid)) {
                BossInfoServer bossInfo = this.BossList.get(uuid);
                bossInfo.func_186761_b(player);
            }
        }
    }

    @SubscribeEvent
    public void breakBlock(PlayerEvent.BreakSpeed breakEvent) {
        World world = breakEvent.getEntity().func_130014_f_();
        BlockPos breakpos = breakEvent.getPos();
        IBlockState blockstate = world.func_180495_p(breakpos);
        float hardnessmod = 1.0f;
        if (!(blockstate.func_177230_c() instanceof BlockLattice) && this.isNextToHardener(world, breakpos)) {
            hardnessmod = 2.0f;
        }
        float newspeed = breakEvent.getNewSpeed() * (1.0f / hardnessmod);
        breakEvent.setNewSpeed(newspeed);
    }

    private boolean isNextToHardener(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos nextpos = pos.func_177972_a(facing);
            IBlockState state = world.func_180495_p(nextpos);
            if (!(state.func_177230_c() instanceof BlockLattice)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent updateEvent) {
        EntityLivingBase entity = updateEvent.getEntityLiving();
        World world = entity.func_130014_f_();
        UUID uuid = entity.func_110124_au();
        BlockPos pos = entity.func_180425_c();
        if (!world.field_72995_K) {
            if (entity.func_70644_a((Potion)ModPotions.boss)) {
                if (!this.BossList.containsKey(uuid)) {
                    BossInfoServer displayData = (BossInfoServer)new BossInfoServer(entity.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(false);
                    this.BossList.put(uuid, displayData);
                    List entities = world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(pos).func_72321_a(24.0, 24.0, 24.0));
                    if (entities != null) {
                        for (EntityPlayerMP ply : entities) {
                            displayData.func_186760_a(ply);
                        }
                    }
                } else {
                    BossInfoServer bossInfo = this.BossList.get(uuid);
                    bossInfo.func_186735_a(entity.func_110143_aJ() / entity.func_110138_aP());
                }
            } else if (world.func_73046_m().func_71259_af() % 10 == 0 && this.BossList.containsKey(uuid)) {
                BossInfoServer bossInfo = this.BossList.get(uuid);
                for (EntityPlayerMP ply : bossInfo.func_186757_c()) {
                    bossInfo.func_186761_b(ply);
                }
                this.BossList.remove(uuid);
            }
        }
    }

    @SubscribeEvent
    public void livingAttacked(LivingAttackEvent event) {
        EntityLivingBase living;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && !event.isCanceled() && event.getAmount() > 0.0f && (living = event.getEntityLiving()).func_70644_a((Potion)ModPotions.cannonball) && (event.getSource().func_94541_c() || event.getSource() == DamageSource.field_76379_h)) {
            if (event.getSource() == DamageSource.field_76379_h) {
                living.func_184589_d((Potion)ModPotions.cannonball);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState blockstate = world.func_180495_p(pos);
        EntityPlayer player = event.getEntityPlayer();
        if (blockstate.func_177230_c() instanceof BlockBanner) {
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            BlockBanner bannerblock = (BlockBanner)blockstate.func_177230_c();
            if (stack.func_190926_b() && player.func_70093_af() && player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                ItemStack bannerstack = bannerblock.func_185473_a(world, pos, blockstate);
                player.func_184609_a(hand);
                world.func_175713_t(pos);
                world.func_175698_g(pos);
                player.func_184201_a(EntityEquipmentSlot.HEAD, bannerstack);
                if (!event.getWorld().field_72995_K) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

