/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.entity;

import betterwithaddons.item.ItemGreatarrow;
import betterwithaddons.item.ModItems;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityGreatarrow
extends EntityArrow {
    public boolean impactSoundPlayed = false;
    private static final DataParameter<ItemStack> ARROW_TYPE = EntityDataManager.func_187226_a(EntityGreatarrow.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Float> BLOCK_BREAK_POWER = EntityDataManager.func_187226_a(EntityGreatarrow.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityGreatarrow(World worldIn) {
        super(worldIn);
    }

    public EntityGreatarrow(World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
    }

    public EntityGreatarrow(World worldIn, IPosition pos) {
        super(worldIn, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ARROW_TYPE, (Object)new ItemStack((Item)ModItems.GREATARROW));
        this.field_70180_af.func_187214_a(BLOCK_BREAK_POWER, (Object)Float.valueOf(3.0f));
    }

    public void setBlockBreakPower(float amt) {
        this.field_70180_af.func_187227_b(BLOCK_BREAK_POWER, (Object)Float.valueOf(amt));
    }

    public Float getBlockBreakPower() {
        return (Float)this.field_70180_af.func_187225_a(BLOCK_BREAK_POWER);
    }

    public void setArrowStack(ItemStack stack) {
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        this.field_70180_af.func_187227_b(ARROW_TYPE, (Object)stack);
    }

    protected ItemStack func_184550_j() {
        return (ItemStack)this.field_70180_af.func_187225_a(ARROW_TYPE);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.spawnPotionParticles(4);
        }
    }

    public void spawnPotionParticles(int particleCount) {
        if (particleCount > 0) {
            for (int i = 0; i < particleCount; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        boolean isnormalhit = true;
        ItemGreatarrow arrowtype = this.getArrowType();
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity == null) {
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            IBlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            Block block = blockstate.func_177230_c();
            float hardness = block.getExplosionResistance(this.field_70170_p, blockpos, (Entity)this, null);
            float blockBreakPower = this.getBlockBreakPower().floatValue();
            if (this.breakBlockWithParticles(blockpos, blockBreakPower)) {
                blockBreakPower -= hardness;
                isnormalhit = false;
                if (!this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 2; ++i) {
                        BlockPos sideblock = blockpos.func_177967_a(EnumFacing.func_176741_a((Random)this.field_70146_Z), 1);
                        float sidehardness = this.field_70170_p.func_180495_p(sideblock).func_177230_c().getExplosionResistance(this.field_70170_p, sideblock, (Entity)this, null);
                        if (!this.breakBlockWithParticles(sideblock, blockBreakPower)) continue;
                        blockBreakPower -= sidehardness;
                    }
                }
            }
            this.setBlockBreakPower(blockBreakPower);
            this.field_70165_t -= (double)((float)(this.field_70165_t + this.field_70159_w - raytraceResultIn.field_72307_f.field_72450_a));
            this.field_70163_u -= (double)((float)(this.field_70163_u + this.field_70181_x - raytraceResultIn.field_72307_f.field_72448_b));
            this.field_70161_v -= (double)((float)(this.field_70161_v + this.field_70179_y - raytraceResultIn.field_72307_f.field_72449_c));
            if (!this.impactSoundPlayed) {
                this.func_184185_a(SoundEvents.field_187599_cE, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.impactSoundPlayed = true;
            }
            arrowtype.hitBlock(this, blockpos, blockstate, !isnormalhit);
        }
        if (isnormalhit) {
            super.func_184549_a(raytraceResultIn);
        }
        if (this.field_70254_i) {
            arrowtype.hitBlockFinal(this);
        }
    }

    protected void func_184548_a(EntityLivingBase living) {
        super.func_184548_a(living);
        ItemGreatarrow arrowtype = this.getArrowType();
        arrowtype.hitEntity(this, (Entity)living);
    }

    private ItemGreatarrow getArrowType() {
        ItemStack arrowstack = this.func_184550_j();
        ItemGreatarrow arrowtype = ModItems.GREATARROW;
        if (!arrowstack.func_190926_b() && arrowstack.func_77973_b() instanceof ItemGreatarrow) {
            arrowtype = (ItemGreatarrow)arrowstack.func_77973_b();
        }
        return arrowtype;
    }

    protected boolean breakBlockWithParticles(BlockPos blockpos, float power) {
        IBlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        float hardness = block.getExplosionResistance(this.field_70170_p, blockpos, (Entity)this, null);
        if (hardness <= power) {
            if (!this.field_70170_p.field_72995_K && !blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)this.field_70170_p, blockpos)) {
                this.field_70170_p.func_175718_b(2001, blockpos, Block.func_176210_f((IBlockState)blockstate));
                this.field_70170_p.func_175655_b(blockpos, true);
            }
            return true;
        }
        return false;
    }
}

