/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelToolShardInner
implements IModel {
    private final ImmutableList<ResourceLocation> textures;
    private static final float NORTH_Z = 0.4685f;
    private static final float SOUTH_Z = 0.5315f;
    private static final float Z_OFFSET = 1.25E-4f;

    public ModelToolShardInner(ImmutableList<ResourceLocation> textures) {
        this.textures = textures;
    }

    private static ImmutableList<ResourceLocation> getTextureListFromMap(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size(); ++i) {
            if (!textures.containsKey((Object)("layer" + i))) continue;
            builder.add((Object)new ResourceLocation((String)textures.get((Object)("layer" + i))));
        }
        return builder.build();
    }

    public ModelToolShardInner retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size() + this.textures.size(); ++i) {
            if (textures.containsKey((Object)("layer" + i))) {
                builder.add((Object)new ResourceLocation((String)textures.get((Object)("layer" + i))));
                continue;
            }
            if (i >= this.textures.size()) continue;
            builder.add(this.textures.get(i));
        }
        return new ModelToolShardInner((ImmutableList<ResourceLocation>)builder.build());
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional transform = state.apply(Optional.empty());
        for (int i = 0; i < this.textures.size(); ++i) {
            ResourceLocation tex = (ResourceLocation)this.textures.get(i);
            if (tex.toString().equals("minecraft:missingno")) continue;
            TextureAtlasSprite sprite = bakedTextureGetter.apply(tex);
            String breakLocation = new ResourceLocation("betterwithaddons", "items/breakmask").toString();
            TextureAtlasSprite breakTemplate = Minecraft.func_71410_x().func_147117_R().func_110572_b(breakLocation);
            builder.addAll(ModelToolShardInner.getQuadsForSprite(i, breakTemplate, sprite, format, transform));
        }
        TextureAtlasSprite particle = bakedTextureGetter.apply(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0));
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedItemModel(builder.build(), particle, Maps.immutableEnumMap((Map)map), ItemOverrideList.field_188022_a);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite template, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uSpriteMax = sprite.func_94211_a();
        int vSpriteMax = sprite.func_94216_b();
        int uMaskMax = template.func_94211_a();
        int vMaskMax = template.func_94216_b();
        int uMax = Math.max(uMaskMax, uSpriteMax);
        int vMax = Math.max(vMaskMax, vSpriteMax);
        float un = (float)uSpriteMax / 16.0f;
        float vn = (float)vSpriteMax / 16.0f;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] spritepixels = sprite.func_147965_a(f)[0];
            int[] maskpixels = template.func_147965_a(0)[0];
            for (int v = 0; v < vMax; ++v) {
                for (int u = 0; u < uMax; ++u) {
                    int maskindex;
                    int spriteindex = ModelToolShardInner.mapToSmallerPixel(u, v, uMax, vMax, uSpriteMax, vSpriteMax);
                    if (ModelToolShardInner.isTransparent(spritepixels, maskpixels, spriteindex, maskindex = ModelToolShardInner.mapToSmallerPixel(u, v, uMax, vMax, uMaskMax, vMaskMax))) continue;
                    int color = maskpixels[maskindex];
                    float x1 = (float)u / (float)uMax;
                    float x2 = (float)(u + 1) / (float)uMax;
                    float y1 = (float)(vMax - 1 - v) / (float)vMax;
                    float y2 = (float)(vMax - v) / (float)vMax;
                    float u1 = sprite.func_94214_a((double)((float)u / un));
                    float u2 = sprite.func_94214_a((double)((float)(u + 1) / un));
                    float v1 = sprite.func_94207_b((double)((float)v / vn));
                    float v2 = sprite.func_94207_b((double)((float)(v + 1) / vn));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, color, x1, y1, 0.46875f, u1, v2, x1, y2, 0.46875f, u1, v1, x2, y2, 0.46875f, u2, v1, x2, y1, 0.46875f, u2, v2));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, color, x1, y1, 0.53125f, u1, v2, x2, y1, 0.53125f, u2, v2, x2, y2, 0.53125f, u2, v1, x1, y2, 0.53125f, u1, v1));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, color, x2, y1, 0.46875f, u2, v2, x2, y1, 0.53125f, u2, v1, x1, y1, 0.53125f, u1, v1, x1, y1, 0.46875f, u1, v2));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, color, x1, y2, 0.46875f, u1, v2, x1, y2, 0.53125f, u1, v1, x2, y2, 0.53125f, u2, v1, x2, y2, 0.46875f, u2, v2));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.EAST, sprite, tint, color, x2, y1, 0.46875f, u1, v2, x2, y2, 0.46875f, u1, v1, x2, y2, 0.53125f, u2, v1, x2, y1, 0.53125f, u2, v2));
                    builder.add((Object)ModelToolShardInner.buildQuad(format, transform, EnumFacing.WEST, sprite, tint, color, x1, y1, 0.53125f, u2, v2, x1, y2, 0.53125f, u2, v1, x1, y2, 0.46875f, u1, v1, x1, y1, 0.46875f, u1, v2));
                }
            }
        }
        return builder.build();
    }

    private static int multiplyColors(int color1, int color2) {
        int r = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        int g = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int b = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int a = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        return r | g << 8 | b << 16 | a << 24;
    }

    private static int getPixelIndex(int u, int v, int uMax, int vMax) {
        return u + v * vMax;
    }

    private static int mapToSmallerPixel(int u, int v, int uMax, int vMax, int uMin, int vMin) {
        int uMod = uMax / uMin;
        int vMod = vMax / vMin;
        return ModelToolShardInner.getPixelIndex(u / uMod % uMin, v / vMod % uMin, uMin, vMin);
    }

    private static boolean isTransparent(int[] pixels, int[] maskpixels, int index, int maskindex) {
        return (pixels[index] >> 24 & 0xFF) == 0 || (maskpixels[maskindex] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<BakedQuad> builder, BitSet faces, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)ModelToolShardInner.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.func_94211_a();
        float y0 = (float)v / (float)sprite.func_94216_b();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case WEST: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case EAST: {
                y1 = ((float)v + 1.0f) / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case UP: {
                x1 = ((float)u + 1.0f) / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float u1 = 16.0f * (x1 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float v0 = 16.0f * (1.0f - y0 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        float v1 = 16.0f * (1.0f - y1 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        switch (side) {
            case WEST: 
            case EAST: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.func_94216_b();
                v1 += 0.5f / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: 
            case UP: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.func_94211_a();
                u1 -= 0.5f / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case WEST: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case EAST: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case DOWN: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case UP: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ModelToolShardInner.buildQuad(format, transform, side.func_176734_d(), sprite, tint, 0, x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z2, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z2, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static final BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, int color, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        ModelToolShardInner.putVertex(builder, format, transform, side, color, x0, y0, z0, u0, v0);
        ModelToolShardInner.putVertex(builder, format, transform, side, color, x1, y1, z1, u1, v1);
        ModelToolShardInner.putVertex(builder, format, transform, side, color, x2, y2, z2, u2, v2);
        ModelToolShardInner.putVertex(builder, format, transform, side, color, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int color, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        transform.get().getMatrix().transform((Tuple4f)vec);
                        builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

