/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block.Factorization;

import betterwithaddons.block.BlockBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMatcher
extends BlockBase {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final IProperty<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockMatcher() {
        super("block_matcher", Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)((EnumFacing.Axis)state.func_177229_b(AXIS)));
        if (fromPos.equals((Object)pos.func_177967_a(facing, 1)) || fromPos.equals((Object)pos.func_177967_a(facing, -1))) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        byte match = this.match(worldIn, pos, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)((EnumFacing.Axis)state.func_177229_b(AXIS))));
        if (match > 2 != (Boolean)state.func_177229_b((IProperty)ACTIVE)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(match > 2)));
        } else {
            worldIn.markAndNotifyBlock(pos, worldIn.func_175726_f(pos), state, state, 3);
        }
        worldIn.func_175684_a(pos, (Block)this, 1);
    }

    private byte match(World world, BlockPos pos, EnumFacing axis) {
        BlockPos frontpos = pos.func_177972_a(axis);
        IBlockState frontbs = world.func_180495_p(frontpos);
        Block frontBlock = frontbs.func_177230_c();
        boolean frontAir = frontBlock.isAir(frontbs, (IBlockAccess)world, frontpos);
        BlockPos backpos = pos.func_177972_a(axis.func_176734_d());
        IBlockState backbs = world.func_180495_p(backpos);
        Block backBlock = backbs.func_177230_c();
        boolean backAir = backBlock.isAir(backbs, (IBlockAccess)world, backpos);
        if (frontAir && backAir) {
            return 0;
        }
        if (frontBlock == backBlock) {
            if (BlockMatcher.sameState(frontbs, backbs)) {
                return 4;
            }
            return 3;
        }
        if (frontbs.func_185904_a() == backbs.func_185904_a()) {
            return 2;
        }
        if (frontbs.func_185887_b(world, frontpos) == backbs.func_185887_b(world, backpos)) {
            return 1;
        }
        return 0;
    }

    public static boolean sameState(IBlockState abs, IBlockState bbs) {
        return abs == bbs;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176740_k());
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)ACTIVE) != false ? 15 : 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.match(worldIn, pos, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)((EnumFacing.Axis)blockState.func_177229_b(AXIS))));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 4 : 0) | ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, AXIS});
    }
}

