/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockBase;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.IHasVariants;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockThornRose
extends BlockBase
implements IPlantable,
IHasVariants {
    public static final int MAX_AGE = 9;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)9);

    protected BlockThornRose() {
        super("thorn_rose", Material.field_151575_d);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(BetterWithAddons.instance.creativeTab);
        this.func_149675_a(true);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canSurvive(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            int grownflowers = 0;
            EnumFacing stemfacing = this.getStem(worldIn, pos, rand);
            if (age < 9) {
                for (int i = 0; i < 5; ++i) {
                    EnumFacing growdir = EnumFacing.func_176741_a((Random)rand);
                    BlockPos checkpos = pos.func_177972_a(growdir);
                    if (ModBlocks.THORNS.canSurvive(worldIn, pos) && this.func_176196_c(worldIn, checkpos) && this.isGoodPlaceToGrow(worldIn, checkpos)) {
                        worldIn.func_180501_a(pos, ModBlocks.THORNS.setStem(ModBlocks.THORNS.func_176223_P(), stemfacing), 2);
                        this.growFlower(worldIn, checkpos, age, growdir.func_176734_d(), rand);
                        ++grownflowers;
                    }
                    if (grownflowers >= 2) break;
                }
                if (grownflowers == 0) {
                    EnumFacing growdir = EnumFacing.func_176741_a((Random)rand);
                    BlockPos checkpos = pos.func_177972_a(growdir);
                    if (ModBlocks.THORNS.canSurvive(worldIn, pos) && this.func_176196_c(worldIn, checkpos)) {
                        worldIn.func_180501_a(pos, ModBlocks.THORNS.setStem(ModBlocks.THORNS.func_176223_P(), stemfacing), 2);
                        this.growFlower(worldIn, checkpos, age, growdir.func_176734_d(), rand);
                        ++grownflowers;
                    }
                }
                if (grownflowers == 0) {
                    if (age >= 8) {
                        this.placeDeadFlower(worldIn, pos);
                    } else {
                        this.placeGrownFlower(worldIn, pos, age + 1);
                    }
                }
            } else if (this.hasAdjacentFlower(worldIn, pos)) {
                if (ModBlocks.THORNS.canSurvive(worldIn, pos)) {
                    worldIn.func_180501_a(pos, ModBlocks.THORNS.setStem(ModBlocks.THORNS.func_176223_P(), stemfacing), 2);
                } else {
                    worldIn.func_175655_b(pos, true);
                }
            }
        }
    }

    private EnumFacing getStem(World world, BlockPos pos, Random rand) {
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos checkpos = pos.func_177972_a(enumfacing);
            IBlockState blockstate = world.func_180495_p(checkpos);
            if (blockstate.func_177230_c() != ModBlocks.THORNS && !this.isProperSoil((IBlockAccess)world, checkpos, enumfacing)) continue;
            facings.add(enumfacing);
        }
        return facings.isEmpty() ? EnumFacing.DOWN : (EnumFacing)facings.get(rand.nextInt(facings.size()));
    }

    private boolean hasAdjacentFlower(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos checkpos = pos.func_177972_a(enumfacing);
            IBlockState blockstate = world.func_180495_p(checkpos);
            if (blockstate.func_177230_c() != this || (Integer)blockstate.func_177229_b((IProperty)AGE) < 9) continue;
            return true;
        }
        return false;
    }

    private boolean isGoodPlaceToGrow(World world, BlockPos pos) {
        boolean hassidewall = false;
        int vines = 0;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos checkpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(checkpos).func_177230_c();
            if (world.isSideSolid(checkpos, enumfacing.func_176734_d())) {
                hassidewall = true;
            }
            if (!this.isVine(block)) continue;
            ++vines;
        }
        return this.canSurvive(world, pos) && hassidewall && vines <= 2;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (age == 9) {
            list.add(ModItems.MATERIAL.getMaterial("thornrose", 1));
        } else if (age == 0) {
            list.add(new ItemStack((Block)this, 1));
        }
        return list;
    }

    private boolean isVine(Block block) {
        return block == this || block == ModBlocks.THORNS;
    }

    private void growFlower(World world, BlockPos pos, int age, EnumFacing stem, Random rand) {
        if (age >= 8) {
            if (rand.nextInt(5) == 0) {
                this.placeDeadFlower(world, pos);
            } else if (ModBlocks.THORNS.func_176196_c(world, pos)) {
                world.func_180501_a(pos, ModBlocks.THORNS.setStem(ModBlocks.THORNS.func_176223_P(), stem), 2);
            }
        } else if (rand.nextInt(5) == 0) {
            this.placeGrownFlower(world, pos, age);
        } else {
            this.placeGrownFlower(world, pos, age + 1);
        }
    }

    private void placeGrownFlower(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
    }

    private void placeDeadFlower(World world, BlockPos pos) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(9)), 2);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if ((Integer)state.func_177229_b((IProperty)AGE) < 9 && entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 5.0f);
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Desert;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canSurvive(worldIn, pos);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.canSurvive(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public boolean canSurvive(World world, BlockPos pos) {
        int adjacentVines = 0;
        int adjacentSoil = 0;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (this.isVine(block)) {
                ++adjacentVines;
                continue;
            }
            if (!this.isProperSoil((IBlockAccess)world, blockpos, enumfacing)) continue;
            ++adjacentSoil;
        }
        return (adjacentSoil > 0 || adjacentVines > 0) && adjacentVines <= 3;
    }

    public boolean isProperSoil(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block == Blocks.field_150354_m || block == Blocks.field_150341_Y || block == Blocks.field_150417_aV && state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a) == BlockStoneBrick.EnumType.MOSSY || block.canSustainPlant(world.func_180495_p(pos), world, pos, facing.func_176734_d(), (IPlantable)this);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        ArrayList<ModelResourceLocation> rlist = new ArrayList<ModelResourceLocation>();
        rlist.add(new ModelResourceLocation("betterwithaddons:seed_thorns", "inventory"));
        return rlist;
    }

    @Override
    public String getVariantName(int meta) {
        return null;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

