/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import betterwithaddons.block.BlockLoom;
import betterwithaddons.block.ISpindle;
import betterwithaddons.crafting.manager.CraftingManagerSpindle;
import betterwithaddons.crafting.recipes.SpindleRecipe;
import betterwithaddons.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSpindle
extends BlockBase
implements ISpindle {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"ison");
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockSpindle() {
        super("spindle", Material.field_151575_d);
        this.func_149711_c(2.0f).func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
            case Z: {
                return Z_AABB;
            }
        }
        return null;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)facing.func_176740_k()).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta >> 1 & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)ISACTIVE) != false ? 1 : 0) | ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal() << 1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ISACTIVE, AXIS});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        IBlockState checkState = world.func_180495_p(other);
        if (checkState.func_177230_c() instanceof BlockLoom) {
            world.func_180497_b(pos, (Block)this, 5, 5);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 5, 5);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean powered = this.isPowered(world, pos);
        boolean isOn = this.isBlockOn((IBlockAccess)world, pos);
        if (isOn != powered) {
            this.setBlockOn(world, pos, powered);
            world.func_180497_b(pos, (Block)this, 5, 5);
        }
    }

    public boolean isPowered(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = this.getFacingFromAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
        return this.isSpinningWheelPowering(world, pos.func_177972_a(facing), facing.func_176734_d()) != this.isSpinningWheelPowering(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public boolean isSpinningWheelPowering(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block instanceof BlockLoom && ((BlockLoom)block).isActive(state) && ((BlockLoom)block).getFacing(world, pos) != facing;
    }

    public void setBlockOn(World world, BlockPos pos, boolean powered) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(powered)));
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
    }

    @Override
    public void spinUp(World world, BlockPos pos, IBlockState state, EnumFacing dir) {
        CraftingManagerSpindle manager;
        SpindleRecipe recipe;
        List list = world.func_175647_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)), EntitySelectors.field_94557_a);
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (list.size() > 0 && (recipe = (manager = CraftingManagerSpindle.getInstance()).getMostValidRecipe(list)) != null) {
            ItemUtil.consumeItem(list, recipe.input);
            ArrayList<ItemStack> ret = recipe.getOutput();
            if (ret != null && ret.size() > 0) {
                ArrayList<EnumFacing> validDirections = new ArrayList<EnumFacing>();
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    IBlockState check;
                    if (facing.func_176740_k() == axis || facing == EnumFacing.UP || !(check = world.func_180495_p(pos.func_177972_a(facing))).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(facing)) && !world.func_175623_d(pos.func_177972_a(facing))) continue;
                    validDirections.add(facing);
                }
                for (int i = 0; i < ret.size(); ++i) {
                    ItemStack item = (ItemStack)ret.get(i);
                    if (item.func_190926_b()) continue;
                    EnumFacing ejectdir = validDirections.isEmpty() ? (axis.func_176720_b() ? EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)] : EnumFacing.DOWN) : (EnumFacing)validDirections.get(world.field_73012_v.nextInt(validDirections.size()));
                    EntityItem result = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f + (float)ejectdir.func_82601_c() * 0.2f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f + (float)ejectdir.func_82599_e() * 0.2f), item.func_77946_l());
                    result.field_70159_w = (double)ejectdir.func_82601_c() * 0.2;
                    result.field_70181_x = 0.0;
                    result.field_70179_y = (double)ejectdir.func_82599_e() * 0.2;
                    result.func_174869_p();
                    if (world.field_72995_K) continue;
                    world.func_72838_d((Entity)result);
                }
                if (recipe.consumesSpindle) {
                    world.func_175698_g(pos);
                }
            }
        }
    }

    public int func_149738_a(World world) {
        return 40;
    }

    public EnumFacing getFacingFromAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.EAST;
            }
            case Y: {
                return EnumFacing.UP;
            }
            case Z: {
                return EnumFacing.NORTH;
            }
        }
        return null;
    }
}

