/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockScaffold
extends BlockBase {
    protected BlockScaffold(String name) {
        super(name, Material.field_151575_d);
        this.func_149711_c(2.5f);
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockScaffold.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375));
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).func_70617_f_() && this.isLadder(state, (IBlockAccess)worldIn, pos, (EntityLivingBase)entityIn)) {
            float f5 = 0.15f;
            if (entityIn.field_70159_w < (double)(-f5)) {
                entityIn.field_70159_w = -f5;
            }
            if (entityIn.field_70159_w > (double)f5) {
                entityIn.field_70159_w = f5;
            }
            if (entityIn.field_70179_y < (double)(-f5)) {
                entityIn.field_70179_y = -f5;
            }
            if (entityIn.field_70179_y > (double)f5) {
                entityIn.field_70179_y = f5;
            }
            entityIn.field_70143_R = 0.0f;
            if (entityIn.field_70181_x < -0.15) {
                entityIn.field_70181_x = -0.15;
            }
            if (entityIn.field_70181_x < 0.0 && entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
                entityIn.field_70181_x = 0.05;
                return;
            }
            if (entityIn.field_70123_F) {
                entityIn.field_70181_x = 0.2;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        IBlockState bottomState = world.func_180495_p(pos.func_177977_b());
        if (bottomState.func_177230_c() != this && !bottomState.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState bottomState = world.func_180495_p(pos.func_177977_b());
        return bottomState.func_177230_c() == this || bottomState.isSideSolid((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn == null) {
            return false;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!playerIn.func_70093_af() && stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            if (worldIn.field_72995_K) {
                return true;
            }
            if (this.placeOnTop(worldIn, pos.func_177984_a(), this.func_176223_P(), this.getLowerSupport(worldIn, pos))) {
                stack.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeOnTop(World world, BlockPos pos, IBlockState stateToPlace, int support) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos);
        while (support > 0) {
            IBlockState checkState = world.func_180495_p((BlockPos)checkPos);
            if (checkState.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos)) {
                world.func_175656_a((BlockPos)checkPos, stateToPlace);
                return true;
            }
            if (checkState.func_177230_c() != this) break;
            support = Math.max(support, this.getSurroundingSupport(world, (BlockPos)checkPos));
            --support;
            checkPos.func_189536_c(EnumFacing.UP);
        }
        return false;
    }

    private int getLowerSupport(World world, BlockPos pos) {
        int support = 0;
        for (int i = 0; i < 8; ++i) {
            support = Math.max(support, this.getSurroundingSupport(world, pos.func_177979_c(i)) - i);
        }
        return support;
    }

    private int getSurroundingSupport(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!world.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d())) continue;
            return 8;
        }
        return 0;
    }
}

