/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockContainerBase;
import betterwithaddons.tileentity.TileEntityRopeSideways;
import betterwithaddons.util.BoundingUtil;
import betterwithaddons.util.ItemUtil;
import betterwithmods.api.block.PropertyObject;
import betterwithmods.common.BWMBlocks;
import betterwithmods.util.InvUtils;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockRopeSideways
extends BlockContainerBase {
    private static AxisAlignedBB AABB_X = new AxisAlignedBB(0.0, 0.75, 0.4375, 1.0, 0.875, 0.5625);
    private static AxisAlignedBB AABB_Z = new AxisAlignedBB(0.4375, 0.75, 0.0, 0.5625, 0.875, 1.0);
    private static AxisAlignedBB AABB_CROSS = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 0.875, 1.0);
    private static AxisAlignedBB AABB_PLATFORM = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    public static HashSet<Block> FASTENABLE_BLOCKS = new HashSet();
    public static final IProperty<EnumRopeShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumRopeShape.class);
    public static final PropertyBool HAS_PLANKS = PropertyBool.func_177716_a((String)"has_planks");
    public static final PropertyObject<ItemStack> HELD_PLANKS = new PropertyObject("held_planks", ItemStack.class);
    private static ImmutableList<AxisAlignedBB> CROSS_BOUNDS = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.75, 0.4375, 1.0, 0.875, 0.5625), (Object)new AxisAlignedBB(0.4375, 0.75, 0.0, 0.5625, 0.875, 1.0));

    protected BlockRopeSideways(String name) {
        super(name, Material.field_151575_d);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_PLANKS, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (((Boolean)blockState.func_177229_b((IProperty)HAS_PLANKS)).booleanValue()) {
            return 2.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public static void addFastenableBlock(Block block) {
        FASTENABLE_BLOCKS.add(block);
    }

    public static boolean canFastenBlock(Block block) {
        return FASTENABLE_BLOCKS.contains(block);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        if (((Boolean)state.func_177229_b((IProperty)HAS_PLANKS)).booleanValue() && (te = world.func_175625_s(pos)) instanceof TileEntityRopeSideways && !world.field_72995_K) {
            TileEntityRopeSideways tile = (TileEntityRopeSideways)te;
            BlockRopeSideways.func_180635_a((World)world, (BlockPos)pos, (ItemStack)tile.getPlanks());
            tile.setPlanks(ItemStack.field_190927_a);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(BWMBlocks.ROPE));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityRopeSideways) {
            InvUtils.ejectStackWithOffset((World)worldIn, (BlockPos)pos, (ItemStack)((TileEntityRopeSideways)te).getPlanks());
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn == null) {
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (te instanceof TileEntityRopeSideways && !playerIn.func_70093_af() && ItemUtil.matchesOreDict(stack, "plankWood")) {
            TileEntityRopeSideways tile = (TileEntityRopeSideways)te;
            if (worldIn.field_72995_K) {
                return true;
            }
            if (tile.getPlanks().func_190926_b()) {
                tile.setPlanks(stack.func_77979_a(1));
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean supportedx = this.isSupported(worldIn, pos, state, EnumFacing.Axis.X);
        boolean supportedz = this.isSupported(worldIn, pos, state, EnumFacing.Axis.Z);
        switch ((EnumRopeShape)((Object)state.func_177229_b(SHAPE))) {
            case X: {
                if (supportedx) break;
                this.dropBlock(worldIn, pos, state, null);
                break;
            }
            case Z: {
                if (supportedz) break;
                this.dropBlock(worldIn, pos, state, null);
                break;
            }
            case CROSS: {
                if (!supportedx && !supportedz) {
                    this.dropBlock(worldIn, pos, state, null);
                }
                if (!supportedx) {
                    this.dropBlock(worldIn, pos, state, EnumRopeShape.Z);
                    break;
                }
                if (supportedz) break;
                this.dropBlock(worldIn, pos, state, EnumRopeShape.X);
            }
        }
    }

    private void dropBlock(World world, BlockPos pos, IBlockState state, EnumRopeShape remainingRope) {
        this.func_176226_b(world, pos, state, 0);
        if (remainingRope == null) {
            world.func_175698_g(pos);
        } else {
            world.func_175656_a(pos, state.func_177226_a(SHAPE, (Comparable)((Object)remainingRope)));
        }
    }

    private boolean isSupported(World world, BlockPos pos, IBlockState state, EnumFacing.Axis axis) {
        EnumRopeShape shape = (EnumRopeShape)((Object)state.func_177229_b(SHAPE));
        EnumFacing forward = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
        EnumFacing back = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
        IBlockState state1 = world.func_180495_p(pos.func_177972_a(forward));
        IBlockState state2 = world.func_180495_p(pos.func_177972_a(back));
        return (BlockRopeSideways.canFastenBlock(state1.func_177230_c()) || state1.func_177230_c() == this && ((EnumRopeShape)((Object)state1.func_177229_b(SHAPE))).has(shape)) && (BlockRopeSideways.canFastenBlock(state2.func_177230_c()) || state2.func_177230_c() == this && ((EnumRopeShape)((Object)state2.func_177229_b(SHAPE))).has(shape));
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRopeSideways();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)HAS_PLANKS) != false ? AABB_PLATFORM : field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)HAS_PLANKS) != false ? AABB_PLATFORM : ((EnumRopeShape)((Object)state.func_177229_b(SHAPE))).getAABB();
    }

    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (state.func_177229_b(SHAPE) == EnumRopeShape.CROSS && !((Boolean)state.func_177229_b((IProperty)HAS_PLANKS)).booleanValue()) {
            return BoundingUtil.raytraceMultiAABB(CROSS_BOUNDS, pos, start, end);
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)EnumRopeShape.byMetadata(meta & 3))).func_177226_a((IProperty)HAS_PLANKS, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumRopeShape)((Object)state.func_177229_b(SHAPE))).getMetadata() | ((Boolean)state.func_177229_b((IProperty)HAS_PLANKS) != false ? 4 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{SHAPE, HAS_PLANKS}, new IUnlistedProperty[]{HELD_PLANKS});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        ItemStack planks = ItemStack.field_190927_a;
        if (te instanceof TileEntityRopeSideways) {
            TileEntityRopeSideways tile = (TileEntityRopeSideways)te;
            planks = tile.getPlanks();
        }
        return ((IExtendedBlockState)state).withProperty(HELD_PLANKS, (Object)planks);
    }

    static /* synthetic */ AxisAlignedBB access$000() {
        return AABB_X;
    }

    static /* synthetic */ AxisAlignedBB access$100() {
        return AABB_Z;
    }

    static /* synthetic */ AxisAlignedBB access$200() {
        return AABB_CROSS;
    }

    public static enum EnumRopeShape implements IStringSerializable
    {
        X(0, "x", BlockRopeSideways.access$000(), EnumFacing.Axis.X),
        Z(1, "z", BlockRopeSideways.access$100(), EnumFacing.Axis.Z),
        CROSS(2, "cross", BlockRopeSideways.access$200(), null);

        private static final EnumRopeShape[] VALUES;
        private final int meta;
        private final String name;
        private final AxisAlignedBB aabb;
        private final EnumFacing.Axis axis;

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public AxisAlignedBB getAABB() {
            return this.aabb;
        }

        public EnumFacing.Axis getAxis() {
            return this.axis;
        }

        private EnumRopeShape(int metaIn, String nameIn, AxisAlignedBB aabbIn, EnumFacing.Axis axis) {
            this.meta = metaIn;
            this.name = nameIn;
            this.aabb = aabbIn;
            this.axis = axis;
        }

        public static EnumRopeShape byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public EnumRopeShape add(EnumRopeShape otherShape) {
            return this != otherShape ? CROSS : otherShape;
        }

        public boolean has(EnumRopeShape otherShape) {
            return otherShape != null && (this == CROSS || otherShape == CROSS || this == otherShape);
        }

        public boolean has(EnumFacing.Axis axis) {
            return axis.func_176722_c() && (this == CROSS || this.axis == axis);
        }

        public String toString() {
            return this.name;
        }

        static {
            VALUES = EnumRopeShape.values();
        }
    }
}

