/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockMetal;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import ferro2000.immersivetech.api.craftings.SolarTowerRecipes;
import ferro2000.immersivetech.common.Config;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockSolarTower;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntitySolarReflector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySolarTower
extends TileEntityMultiblockMetal<TileEntitySolarTower, SolarTowerRecipes>
implements IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IAdvancedSelectionBounds,
IEBlockInterfaces.IAdvancedCollisionBounds {
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(32000), new FluidTank(32000)};
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private int reflectorNum;
    private int processTime = 0;
    public int ref0;
    public int ref1;
    public int ref2;
    public int ref3;
    private boolean wasActive = false;

    public TileEntitySolarTower() {
        super((MultiblockHandler.IMultiblock)MultiblockSolarTower.instance, new int[]{7, 3, 3}, 0, true);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.ref0 = nbt.func_74762_e("ref0");
        this.ref1 = nbt.func_74762_e("ref1");
        this.ref2 = nbt.func_74762_e("ref2");
        this.ref3 = nbt.func_74762_e("ref3");
        if (!descPacket) {
            this.inventory = Utils.readInventory((NBTTagList)nbt.func_150295_c("inventory", 10), (int)6);
        }
    }

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("ref0", this.ref0);
        nbt.func_74768_a("ref1", this.ref1);
        nbt.func_74768_a("ref2", this.ref2);
        nbt.func_74768_a("ref3", this.ref3);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public void func_73660_a() {
        ItemStack emptyContainer;
        SolarTowerRecipes recipe;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || this.isDummy()) {
            return;
        }
        boolean update = false;
        if (this.processQueue.size() < this.getProcessQueueMaxLength() && this.checkReflector() && this.tanks[0].getFluidAmount() > 0 && (recipe = SolarTowerRecipes.findRecipe(this.tanks[0].getFluid())) != null) {
            this.processTime += this.getSpeed();
            if (this.processTime > 30) {
                this.processTime = 0;
                TileEntityMultiblockMetal.MultiblockProcessInMachine process = new TileEntityMultiblockMetal.MultiblockProcessInMachine((IMultiblockRecipe)recipe, new int[0]).setInputTanks(new int[]{0});
                if (this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, true)) {
                    this.addProcessToQueue((TileEntityMultiblockMetal.MultiblockProcess)process, false);
                    update = true;
                }
            }
        }
        if (this.processQueue.size() > 0) {
            this.wasActive = true;
        } else if (this.wasActive) {
            this.wasActive = false;
            update = true;
        }
        if (this.tanks[1].getFluidAmount() > 0) {
            ItemStack filledContainer = Utils.fillFluidContainer((IFluidHandler)this.tanks[1], (ItemStack)((ItemStack)this.inventory.get(2)), (ItemStack)((ItemStack)this.inventory.get(3)), null);
            if (!filledContainer.func_190926_b()) {
                if (!((ItemStack)this.inventory.get(3)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)filledContainer, (boolean)true)) {
                    ((ItemStack)this.inventory.get(3)).func_190917_f(filledContainer.func_190916_E());
                } else if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
                    this.inventory.set(3, (Object)filledContainer.func_77946_l());
                }
                ((ItemStack)this.inventory.get(2)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(2)).func_190916_E() <= 0) {
                    this.inventory.set(2, (Object)ItemStack.field_190927_a);
                }
                update = true;
            }
            if (this.tanks[1].getFluidAmount() > 0) {
                int accepted;
                FluidStack out = Utils.copyFluidStackWithAmount((FluidStack)this.tanks[1].getFluid(), (int)Math.min(this.tanks[1].getFluidAmount(), 100), (boolean)false);
                BlockPos outputPos = this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(this.facing, 3);
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (EnumFacing)this.facing);
                if (output != null && (accepted = output.fill(out, false)) > 0) {
                    int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
                    this.tanks[1].drain(drained, true);
                    update = true;
                }
            }
        }
        if (!(emptyContainer = Utils.drainFluidContainer((IFluidHandler)this.tanks[0], (ItemStack)((ItemStack)this.inventory.get(0)), (ItemStack)((ItemStack)this.inventory.get(1)), null)).func_190926_b() && emptyContainer.func_190916_E() > 0) {
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)emptyContainer, (boolean)true)) {
                ((ItemStack)this.inventory.get(1)).func_190917_f(emptyContainer.func_190916_E());
            } else if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
                this.inventory.set(1, (Object)emptyContainer.func_77946_l());
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (((ItemStack)this.inventory.get(0)).func_190916_E() <= 0) {
                this.inventory.set(0, (Object)ItemStack.field_190927_a);
            }
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
    }

    protected boolean checkReflector() {
        boolean ver = false;
        int maxRange = Config.ITConfig.Machines.solarTower_maxRange;
        int minRange = Config.ITConfig.Machines.solarTower_minRange;
        int refNum = 0;
        block0: for (int cont = 0; cont < 4; ++cont) {
            EnumFacing fw = this.facing;
            if (cont == 1) {
                fw = fw.func_176735_f();
            } else if (cont == 2) {
                fw = fw.func_176734_d();
            } else if (cont == 3) {
                fw = fw.func_176746_e();
            }
            this.setReflectorNum(0, cont);
            for (int i = minRange; i < maxRange + 2; ++i) {
                BlockPos pos = cont == 0 ? this.func_174877_v().func_177967_a(fw, i + 2).func_177982_a(0, 2, 0) : (cont % 2 != 0 ? this.func_174877_v().func_177967_a(this.facing, 1).func_177967_a(fw, i + 1).func_177982_a(0, 2, 0) : this.func_174877_v().func_177967_a(fw, i).func_177982_a(0, 2, 0));
                if (Utils.isBlockAt((World)this.field_145850_b, (BlockPos)pos, (Block)Blocks.field_150350_a, (int)0)) continue;
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (!(tile instanceof TileEntitySolarReflector)) continue block0;
                EnumFacing fr = ((TileEntitySolarReflector)tile).facing;
                if (cont % 2 == 0 && (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) || cont % 2 != 0 && (this.facing == EnumFacing.EAST || this.facing == EnumFacing.WEST)) {
                    if (fr != EnumFacing.NORTH && fr != EnumFacing.SOUTH) continue;
                    if (!((TileEntitySolarReflector)tile).getSunState()) continue block0;
                    ver = true;
                    this.setReflectorNum(1, cont);
                    ++refNum;
                    continue block0;
                }
                if (fr != EnumFacing.EAST && fr != EnumFacing.WEST) continue;
                if (!((TileEntitySolarReflector)tile).getSunState()) continue block0;
                ver = true;
                this.setReflectorNum(1, cont);
                ++refNum;
                continue block0;
            }
        }
        this.reflectorNum = refNum;
        return ver;
    }

    protected void setReflectorNum(int value, int ind) {
        switch (ind) {
            case 0: {
                this.ref0 = value;
                break;
            }
            case 1: {
                this.ref1 = value;
                break;
            }
            case 2: {
                this.ref2 = value;
                break;
            }
            case 3: {
                this.ref3 = value;
            }
        }
    }

    protected int getSpeed() {
        int i = 1;
        if (this.reflectorNum > 1) {
            i = this.reflectorNum;
        }
        return i;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void doGraphicalUpdates(int slot) {
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
    }

    public float[] getBlockBounds() {
        if (this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
        }
        if (this.field_174879_c == 62 || this.field_174879_c == 60 || this.field_174879_c == 54 || this.field_174879_c == 52) {
            return new float[]{0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public boolean canOpenGui() {
        return this.formed;
    }

    public int getGuiID() {
        return 1;
    }

    public TileEntity getGuiMaster() {
        return this.master();
    }

    protected SolarTowerRecipes readRecipeFromNBT(NBTTagCompound tag) {
        return SolarTowerRecipes.loadFromNBT(tag);
    }

    public int[] getEnergyPos() {
        return new int[0];
    }

    public int[] getRedstonePos() {
        return new int[]{10};
    }

    public IFluidTank[] getInternalTanks() {
        return this.tanks;
    }

    public SolarTowerRecipes findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    public int[] getOutputSlots() {
        return new int[0];
    }

    public int[] getOutputTanks() {
        return new int[]{1};
    }

    public boolean additionalCanProcessCheck(TileEntityMultiblockMetal.MultiblockProcess<SolarTowerRecipes> process) {
        return true;
    }

    public void doProcessOutput(ItemStack output) {
        BlockPos pos = this.func_174877_v().func_177967_a(this.facing, 2);
        TileEntity inventoryTile = this.field_145850_b.func_175625_s(pos);
        if (inventoryTile != null) {
            output = Utils.insertStackIntoInventory((TileEntity)inventoryTile, (ItemStack)output, (EnumFacing)this.facing.func_176734_d());
        }
        if (output != null) {
            Utils.dropStackAtPos((World)this.field_145850_b, (BlockPos)pos, (ItemStack)output, (EnumFacing)this.facing);
        }
    }

    public void doProcessFluidOutput(FluidStack output) {
    }

    public void onProcessFinish(TileEntityMultiblockMetal.MultiblockProcess<SolarTowerRecipes> process) {
    }

    public int getMaxProcessPerTick() {
        return 1;
    }

    public int getProcessQueueMaxLength() {
        return 1;
    }

    public float getMinProcessDistance(TileEntityMultiblockMetal.MultiblockProcess<SolarTowerRecipes> process) {
        return 0.0f;
    }

    public boolean isInWorldProcessingMachine() {
        return false;
    }

    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntitySolarTower master = (TileEntitySolarTower)this.master();
        if (master != null) {
            if (!(this.field_174879_c != 3 && this.field_174879_c != 5 || side != null && side.func_176740_k() != this.facing.func_176735_f().func_176740_k())) {
                return new FluidTank[]{master.tanks[0]};
            }
            if (this.field_174879_c == 7 && (side == null || side == this.facing)) {
                return new FluidTank[]{master.tanks[1]};
            }
        }
        return new FluidTank[0];
    }

    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        if (!(this.field_174879_c != 3 && this.field_174879_c != 5 || side != null && side.func_176740_k() != this.facing.func_176735_f().func_176740_k())) {
            SolarTowerRecipes incompleteRecipes2;
            TileEntitySolarTower master = (TileEntitySolarTower)this.master();
            FluidStack resourceClone = Utils.copyFluidStackWithAmount((FluidStack)resource, (int)1000, (boolean)false);
            FluidStack resourceClone2 = Utils.copyFluidStackWithAmount((FluidStack)master.tanks[0].getFluid(), (int)1000, (boolean)false);
            if (master == null || master.tanks[iTank].getFluidAmount() >= master.tanks[iTank].getCapacity()) {
                return false;
            }
            if (master.tanks[0].getFluid() == null) {
                SolarTowerRecipes incompleteRecipes = SolarTowerRecipes.findRecipe(resourceClone);
                return incompleteRecipes != null;
            }
            SolarTowerRecipes incompleteRecipes1 = SolarTowerRecipes.findRecipe(resourceClone);
            return incompleteRecipes1 == (incompleteRecipes2 = SolarTowerRecipes.findRecipe(resourceClone2));
        }
        return false;
    }

    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return this.field_174879_c == 7 && (side == null || side == this.facing);
    }

    public TileEntitySolarTower getTileForPos(int targetPos) {
        BlockPos target = this.getBlockPosForPos(targetPos);
        TileEntity tile = this.field_145850_b.func_175625_s(target);
        return tile instanceof TileEntitySolarTower ? (TileEntitySolarTower)tile : null;
    }

    public List<AxisAlignedBB> getAdvancedColisionBounds() {
        return this.getAdvancedSelectionBounds();
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        EnumFacing fl = this.facing;
        EnumFacing fw = this.facing.func_176746_e();
        int h = (this.field_174879_c - this.field_174879_c % 9) / 9;
        if (this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8 || this.field_174879_c == 62 || this.field_174879_c == 60 || this.field_174879_c == 56 || this.field_174879_c == 54) {
            float minZ;
            float maxX;
            float minX;
            float minY = 0.0f;
            float maxY = 0.5f;
            if (h == 6) {
                minY = 0.5f;
                maxY = 1.0f;
            }
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, (double)minY, 0.0, 1.0, (double)maxY, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            if (this.field_174879_c == 6 || this.field_174879_c == 8 || this.field_174879_c == 60 || this.field_174879_c == 62) {
                fl = fl.func_176734_d();
            }
            if (this.field_174879_c == 2 || this.field_174879_c == 8 || this.field_174879_c == 56 || this.field_174879_c == 62) {
                fw = fw.func_176734_d();
            }
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f2 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f3 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            minY = 0.5f;
            maxY = 1.0f;
            if (this.field_174879_c > 8) {
                minY = 0.0f;
                maxY = 0.5f;
            }
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f4 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.0f));
            maxX = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 1.0f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, (double)minY, 0.0, (double)maxX, (double)maxY, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f5 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.NORTH ? 0.0f : 0.5f));
            maxZ = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.0f : (fw == EnumFacing.NORTH ? 0.5f : 1.0f));
            list.add(new AxisAlignedBB(0.0, (double)minY, (double)minZ, 1.0, (double)maxY, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c != 0 && this.field_174879_c != 54 && this.field_174879_c % 9 == 0) {
            float minZ;
            float maxX;
            float minX;
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f6 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f7 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f8 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.0f));
            maxX = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 1.0f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, 0.0, 0.0, (double)maxX, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f9 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.NORTH ? 0.0f : 0.5f));
            maxZ = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.0f : (fw == EnumFacing.NORTH ? 0.5f : 1.0f));
            list.add(new AxisAlignedBB(0.0, 0.0, (double)minZ, 1.0, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 2 + 9 * h) {
            float minZ;
            float maxX;
            float minX;
            fw = fw.func_176734_d();
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f10 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f11 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f12 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.0f));
            maxX = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 1.0f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, 0.0, 0.0, (double)maxX, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f13 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.NORTH ? 0.0f : 0.5f));
            maxZ = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.0f : (fw == EnumFacing.NORTH ? 0.5f : 1.0f));
            list.add(new AxisAlignedBB(0.0, 0.0, (double)minZ, 1.0, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 6 + 9 * h) {
            float minZ;
            float maxX;
            float minX;
            float f = (fl = fl.func_176734_d()) == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f14 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f15 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f16 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.0f));
            maxX = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 1.0f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, 0.0, 0.0, (double)maxX, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f17 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.NORTH ? 0.0f : 0.5f));
            maxZ = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.0f : (fw == EnumFacing.NORTH ? 0.5f : 1.0f));
            list.add(new AxisAlignedBB(0.0, 0.0, (double)minZ, 1.0, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        if (this.field_174879_c == 8 + 9 * h) {
            float minZ;
            float maxX;
            float minX;
            fl = fl.func_176734_d();
            fw = fw.func_176734_d();
            float f = fl == EnumFacing.WEST ? 0.6875f : (fl == EnumFacing.EAST ? 0.0625f : (minX = fw == EnumFacing.EAST ? 0.0625f : 0.6875f));
            float f18 = fl == EnumFacing.EAST ? 0.3125f : (fl == EnumFacing.WEST ? 0.9375f : (maxX = fw == EnumFacing.EAST ? 0.3125f : 0.9375f));
            float f19 = fl == EnumFacing.NORTH ? 0.6875f : (fl == EnumFacing.SOUTH ? 0.0625f : (minZ = fw == EnumFacing.SOUTH ? 0.0625f : 0.6875f));
            float maxZ = fl == EnumFacing.SOUTH ? 0.3125f : (fl == EnumFacing.NORTH ? 0.9375f : (fw == EnumFacing.SOUTH ? 0.3125f : 0.9375f));
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)maxX, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p())});
            float f20 = fl == EnumFacing.EAST ? 0.5f : (fl == EnumFacing.WEST ? 0.0f : (minX = fw == EnumFacing.EAST ? 0.5f : 0.0f));
            maxX = fl == EnumFacing.EAST ? 1.0f : (fl == EnumFacing.WEST ? 0.5f : (fw == EnumFacing.EAST ? 1.0f : 0.5f));
            list.add(new AxisAlignedBB((double)minX, 0.0, 0.0, (double)maxX, 1.0, 1.0).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            float f21 = fl == EnumFacing.NORTH ? 0.0f : (fl == EnumFacing.SOUTH ? 0.5f : (minZ = fw == EnumFacing.NORTH ? 0.0f : 0.5f));
            maxZ = fl == EnumFacing.NORTH ? 0.5f : (fl == EnumFacing.SOUTH ? 1.0f : (fw == EnumFacing.NORTH ? 0.5f : 1.0f));
            list.add(new AxisAlignedBB(0.0, 0.0, (double)minZ, 1.0, 1.0, (double)maxZ).func_72317_d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()));
            return list;
        }
        return null;
    }

    public boolean isOverrideBox(AxisAlignedBB box, EntityPlayer player, RayTraceResult mop, ArrayList<AxisAlignedBB> list) {
        return false;
    }
}

