/*
 * Decompiled with CFR 0.152.
 */
package be.nevoka.projects.bringbedrockback.utils;

import be.nevoka.projects.bringbedrockback.BringBedrockBack;
import be.nevoka.projects.bringbedrockback.config.BBBConfig;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bringbedrockback")
public class RetrogenHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onEvent(ChunkEvent.Load event) {
        Chunk theChunk = event.getChunk();
        if (BBBConfig.enableRegeneration) {
            RetrogenHandler.regenerateBedrockLayer(theChunk);
        }
    }

    public static void regenerateBedrockLayer(Chunk chunk) {
        Random rnd;
        if (Arrays.stream(BBBConfig.flooredDimensions).anyMatch(e -> e == chunk.func_177412_p().field_73011_w.func_186058_p().func_186068_a()) && !chunk.func_186032_a((rnd = new Random()).nextInt(16), 0, rnd.nextInt(16)).func_177230_c().equals(Blocks.field_150357_h)) {
            if (BBBConfig.enableLogOutput) {
                BringBedrockBack.logger.info("Regenerate bedrock chunk at:" + chunk.func_76632_l().toString());
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (chunk.func_186032_a(x, 0, z).func_177230_c().equals(Blocks.field_150357_h)) continue;
                    if (BBBConfig.flooredBedrockLevel != -1) {
                        chunk.func_177436_a(new BlockPos(x, BBBConfig.flooredBedrockLevel, z), Blocks.field_150357_h.func_176223_P());
                    }
                    if (BBBConfig.flooredBedrockLevel == -1 || !Arrays.stream(BBBConfig.roofedDimensions).anyMatch(e -> e == chunk.func_177412_p().field_73011_w.func_186058_p().func_186068_a())) continue;
                    chunk.func_177436_a(new BlockPos(x, BBBConfig.roofedBedrockLevel, z), Blocks.field_150357_h.func_176223_P());
                }
            }
            chunk.func_76630_e();
        }
    }
}

