/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityContainer
implements ICapabilityProvider {
    @Nonnull
    private final List<ICapabilityProvider> capabilityProviders = new ArrayList<ICapabilityProvider>();

    public CapabilityContainer addCapability(ICapabilityProvider capabilityProvider) {
        this.capabilityProviders.add(capabilityProvider);
        return this;
    }

    public CapabilityContainer addCapability(Collection<ICapabilityProvider> capabilityProvider) {
        this.capabilityProviders.addAll(capabilityProvider);
        return this;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.capabilityProviders.stream().anyMatch(cap -> cap.hasCapability(capability, facing));
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return this.capabilityProviders.stream().map(cap -> cap.getCapability(capability, facing)).filter(o -> o != null).findAny().orElse(null);
    }
}

