/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.helper.InvalidConfigException;
import tschipp.carryon.common.helper.StringParser;

public class ModelOverridesHandler {
    public static HashMap<NBTTagCompound, Object> OVERRIDE_OBJECTS = new HashMap();

    public static void initOverrides() {
        String[] overrides = CarryOnConfig.modelOverrides.modelOverrides;
        for (int i = 0; i < overrides.length; ++i) {
            ModelOverridesHandler.parseOverride(overrides[i], i);
        }
    }

    public static void parseOverride(String overrideStr, int i) {
        Object overrideObject;
        int meta;
        Object toOverrideObject;
        boolean errored = false;
        NBTTagCompound tag = new NBTTagCompound();
        String currentline = overrideStr;
        if (StringUtils.isEmpty((CharSequence)currentline) || !StringUtils.contains((CharSequence)currentline, (CharSequence)"->")) {
            new InvalidConfigException("Missing Override Model at line " + i + " : " + currentline).printException();
        }
        String[] sa = currentline.split("->");
        String toOverride = "";
        String override = "";
        try {
            toOverride = sa[0];
            override = sa[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            errored = true;
            new InvalidConfigException("Missing Override Model at line " + i + " : " + currentline).printException();
        }
        if (toOverride.contains("{")) {
            if (!toOverride.contains("}")) {
                errored = true;
                new InvalidConfigException("Missing } at line " + i + " : " + currentline).printException();
            }
            String nbt = toOverride.substring(toOverride.indexOf("{"));
            toOverride = toOverride.replace(nbt, "");
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                errored = true;
                new InvalidConfigException("Error while parsing NBT at line " + i + " : " + e.getMessage()).printException();
            }
        } else if (toOverride.contains("}")) {
            errored = true;
            new InvalidConfigException("Missing { at line " + i + " : " + currentline).printException();
        }
        String overridetype = "item";
        if (override.contains("(")) {
            if (!override.contains(")")) {
                errored = true;
                new InvalidConfigException("Missing ) at line " + i + " : " + currentline).printException();
            }
            overridetype = override.substring(0, override.indexOf(")") + 1);
            override = override.replace(overridetype, "");
            overridetype = overridetype.replace("(", "");
            overridetype = overridetype.replace(")", "");
        } else if (override.contains(")")) {
            errored = true;
            new InvalidConfigException("Missing ( at line " + i + " : " + currentline).printException();
        }
        String modidToOverride = "minecraft";
        String modidOverride = "minecraft";
        if (toOverride.contains(":")) {
            modidToOverride = toOverride.replace(toOverride.substring(toOverride.indexOf(":")), "");
        }
        if (override.contains(":")) {
            modidOverride = override.replace(override.substring(override.indexOf(":")), "");
        }
        if (Loader.isModLoaded((String)modidOverride) && Loader.isModLoaded((String)modidToOverride) && !errored && (toOverrideObject = (meta = StringParser.getMeta(toOverride)) == 0 ? StringParser.getBlock(toOverride) : StringParser.getBlockState(toOverride)) != null && (overrideObject = overridetype.equals("block") ? StringParser.getBlockState(override) : StringParser.getItemStack(override)) != null) {
            NBTTagCompound keyComp = new NBTTagCompound();
            keyComp.func_74782_a("nbttag", (NBTBase)tag);
            if (toOverrideObject instanceof Block) {
                keyComp.func_74778_a("block", toOverrideObject.getRegistryName().toString());
            } else {
                keyComp.func_74768_a("stateid", Block.func_176210_f((IBlockState)((IBlockState)toOverrideObject)));
                keyComp.func_74778_a("block", ((IBlockState)toOverrideObject).func_177230_c().getRegistryName().toString());
            }
            OVERRIDE_OBJECTS.put(keyComp, overrideObject);
        }
    }

    public static boolean hasCustomOverrideModel(IBlockState state, NBTTagCompound tag) {
        if (OVERRIDE_OBJECTS.isEmpty()) {
            return false;
        }
        int stateid = Block.func_176210_f((IBlockState)state);
        NBTTagCompound[] keys = new NBTTagCompound[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (NBTTagCompound key : keys) {
            int id = key.func_74762_e("stateid");
            Block block = StringParser.getBlock(key.func_74779_i("block"));
            if (!(id == 0 ? block == state.func_177230_c() : id == stateid)) continue;
            NBTTagCompound toCheckForCompound = key.func_74775_l("nbttag");
            Set kSetToCheck = toCheckForCompound.func_150296_c();
            Set kSetTile = tag.func_150296_c();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NBTUtil.func_181123_a((NBTBase)tag.func_74781_a(skey), (NBTBase)toCheckForCompound.func_74781_a(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static IBakedModel getCustomOverrideModel(IBlockState state, NBTTagCompound tag, World world, EntityPlayer player) {
        int stateid = Block.func_176210_f((IBlockState)state);
        NBTTagCompound[] keys = new NBTTagCompound[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (NBTTagCompound key : keys) {
            int id = key.func_74762_e("stateid");
            Block block = StringParser.getBlock(key.func_74779_i("block"));
            if (!(id == 0 ? block == state.func_177230_c() : id == stateid)) continue;
            NBTTagCompound toCheckForCompound = key.func_74775_l("nbttag");
            Set kSetToCheck = toCheckForCompound.func_150296_c();
            Set kSetTile = tag.func_150296_c();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NBTUtil.func_181123_a((NBTBase)tag.func_74781_a(skey), (NBTBase)toCheckForCompound.func_74781_a(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            Object override = OVERRIDE_OBJECTS.get(key);
            if (override == null) {
                return null;
            }
            if (override instanceof IBlockState) {
                return Minecraft.func_71410_x().func_175602_ab().func_184389_a((IBlockState)override);
            }
            return Minecraft.func_71410_x().func_175599_af().func_184393_a((ItemStack)override, world, (EntityLivingBase)player);
        }
        return null;
    }

    public static Object getOverrideObject(IBlockState state, NBTTagCompound tag) {
        int stateid = Block.func_176210_f((IBlockState)state);
        NBTTagCompound[] keys = new NBTTagCompound[OVERRIDE_OBJECTS.size()];
        OVERRIDE_OBJECTS.keySet().toArray(keys);
        for (NBTTagCompound key : keys) {
            int id = key.func_74762_e("stateid");
            Block block = StringParser.getBlock(key.func_74779_i("block"));
            if (!(id == 0 ? block == state.func_177230_c() : id == stateid)) continue;
            NBTTagCompound toCheckForCompound = key.func_74775_l("nbttag");
            Set kSetToCheck = toCheckForCompound.func_150296_c();
            Set kSetTile = tag.func_150296_c();
            boolean flag = true;
            if (!kSetTile.containsAll(kSetToCheck)) continue;
            for (String skey : kSetToCheck) {
                if (NBTUtil.func_181123_a((NBTBase)tag.func_74781_a(skey), (NBTBase)toCheckForCompound.func_74781_a(skey), (boolean)true)) continue;
                flag = false;
            }
            if (!flag) continue;
            Object override = OVERRIDE_OBJECTS.get(key);
            return override;
        }
        return null;
    }
}

