/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api;

import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.event.FuelBurnTimeEvent;
import com.shinoow.abyssalcraft.api.internal.DummyMethodHandler;
import com.shinoow.abyssalcraft.api.internal.DummyNecroDataHandler;
import com.shinoow.abyssalcraft.api.internal.IInternalMethodHandler;
import com.shinoow.abyssalcraft.api.internal.IInternalNecroDataHandler;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.item.ItemEngraving;
import com.shinoow.abyssalcraft.api.item.ItemUpgradeKit;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import com.shinoow.abyssalcraft.api.recipe.CrystallizerRecipes;
import com.shinoow.abyssalcraft.api.recipe.EngraverRecipes;
import com.shinoow.abyssalcraft.api.recipe.Materialization;
import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.abyssalcraft.api.recipe.TransmutatorRecipes;
import com.shinoow.abyssalcraft.api.recipe.UpgradeKitRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbyssalCraftAPI {
    public static final String API_VERSION = "1.29.1";
    public static Enchantment coralium_enchantment;
    public static Enchantment dread_enchantment;
    public static Enchantment light_pierce;
    public static Enchantment iron_wall;
    public static Enchantment sapping;
    public static Enchantment multi_rend;
    public static Potion coralium_plague;
    public static Potion dread_plague;
    public static Potion antimatter_potion;
    public static final DamageSource coralium;
    public static final DamageSource dread;
    public static final DamageSource antimatter;
    public static final DamageSource shadow;
    public static final DamageSource acid;
    private static final List<ItemStack> crystals;
    private static final Map<NecroData, Integer> necroData;
    private static final Map<Item, ResourceLocation> ghoul_helmet;
    private static final Map<Item, ResourceLocation> ghoul_chestplate;
    private static final Map<Item, ResourceLocation> ghoul_leggings;
    private static final Map<Item, ResourceLocation> ghoul_boots;
    private static final Map<Integer, Integer> gateway_key_overrides;
    public static final EnumCreatureAttribute SHADOW;
    public static final ItemArmor.ArmorMaterial abyssalniteArmor;
    public static final ItemArmor.ArmorMaterial dreadedAbyssalniteArmor;
    public static final ItemArmor.ArmorMaterial refinedCoraliumArmor;
    public static final ItemArmor.ArmorMaterial platedCoraliumArmor;
    public static final ItemArmor.ArmorMaterial depthsArmor;
    public static final ItemArmor.ArmorMaterial dreadiumArmor;
    public static final ItemArmor.ArmorMaterial dreadiumSamuraiArmor;
    public static final ItemArmor.ArmorMaterial ethaxiumArmor;
    public static final Item.ToolMaterial darkstoneTool;
    public static final Item.ToolMaterial abyssalniteTool;
    public static final Item.ToolMaterial refinedCoraliumTool;
    public static final Item.ToolMaterial dreadiumTool;
    public static final Item.ToolMaterial ethaxiumTool;
    public static EnumEnchantmentType STAFF_OF_RENDING;
    private static IInternalNecroDataHandler internalNDHandler;
    private static IInternalMethodHandler internalMethodHandler;
    public static Fluid liquid_coralium_fluid;
    public static Fluid liquid_antimatter_fluid;
    public static final Logger logger;
    @SideOnly(value=Side.CLIENT)
    private static FontRenderer aklo_font;

    public static void setInternalNDHandler(IInternalNecroDataHandler handler) {
        if (internalNDHandler.getClass().getName().equals(DummyNecroDataHandler.class.getName()) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION && Loader.instance().activeModContainer().getModId().equals("abyssalcraft")) {
            internalNDHandler = handler;
        }
    }

    public static void setInternalMethodHandler(IInternalMethodHandler handler) {
        if (internalMethodHandler.getClass().getName().equals(DummyMethodHandler.class.getName()) && Loader.instance().getLoaderState() == LoaderState.PREINITIALIZATION && Loader.instance().activeModContainer().getModId().equals("abyssalcraft")) {
            internalMethodHandler = handler;
        }
    }

    public static IInternalNecroDataHandler getInternalNDHandler() {
        return internalNDHandler;
    }

    public static IInternalMethodHandler getInternalMethodHandler() {
        return internalMethodHandler;
    }

    public static void setRepairItems() {
        abyssalniteArmor.setRepairItem(new ItemStack(ACItems.abyssalnite_ingot));
        dreadedAbyssalniteArmor.setRepairItem(new ItemStack(ACItems.dreaded_shard_of_abyssalnite));
        refinedCoraliumArmor.setRepairItem(new ItemStack(ACItems.refined_coralium_ingot));
        platedCoraliumArmor.setRepairItem(new ItemStack(ACItems.coralium_plate));
        depthsArmor.setRepairItem(new ItemStack(ACItems.coralium_gem_cluster_9));
        dreadiumArmor.setRepairItem(new ItemStack(ACItems.dreadium_ingot));
        dreadiumSamuraiArmor.setRepairItem(new ItemStack(ACItems.dreadium_plate));
        ethaxiumArmor.setRepairItem(new ItemStack(ACItems.ethaxium_ingot));
        darkstoneTool.setRepairItem(new ItemStack(ACBlocks.cobblestone, 1, 0));
        abyssalniteTool.setRepairItem(new ItemStack(ACItems.abyssalnite_ingot));
        refinedCoraliumTool.setRepairItem(new ItemStack(ACItems.refined_coralium_ingot));
        dreadiumTool.setRepairItem(new ItemStack(ACItems.dreadium_ingot));
        ethaxiumTool.setRepairItem(new ItemStack(ACItems.ethaxium_ingot));
    }

    public static void addCrystallization(Block input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.instance().crystallize(input, output1, output2, xp);
    }

    public static void addCrystallization(Item input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.instance().crystallize(input, output1, output2, xp);
    }

    public static void addCrystallization(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.instance().crystallize(input, output1, output2, xp);
    }

    public static void addSingleCrystallization(Block input, ItemStack output, float xp) {
        AbyssalCraftAPI.addCrystallization(input, output, ItemStack.field_190927_a, xp);
    }

    public static void addSingleCrystallization(Item input, ItemStack output, float xp) {
        AbyssalCraftAPI.addCrystallization(input, output, ItemStack.field_190927_a, xp);
    }

    public static void addSingleCrystallization(ItemStack input, ItemStack output, float xp) {
        AbyssalCraftAPI.addCrystallization(input, output, ItemStack.field_190927_a, xp);
    }

    public static void addTransmutation(Block input, ItemStack output, float xp) {
        TransmutatorRecipes.instance().transmute(input, output, xp);
    }

    public static void addTransmutation(Item input, ItemStack output, float xp) {
        TransmutatorRecipes.instance().transmute(input, output, xp);
    }

    public static void addTransmutation(ItemStack input, ItemStack output, float xp) {
        TransmutatorRecipes.instance().transmute(input, output, xp);
    }

    public static void addOreSmelting(String input, String output, float xp) {
        if (!OreDictionary.getOres((String)output).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                FurnaceRecipes.func_77602_a().func_151394_a(stack, (ItemStack)OreDictionary.getOres((String)output).get(0), xp);
            }
        }
    }

    public static void addCrystallization(String input, String output1, String output2, float xp) {
        if (!OreDictionary.getOres((String)output1).isEmpty() && !OreDictionary.getOres((String)output2).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addCrystallization(stack, (ItemStack)OreDictionary.getOres((String)output1).get(0), (ItemStack)OreDictionary.getOres((String)output2).get(0), xp);
            }
        }
    }

    public static void addCrystallization(String input, String output1, int out1, String output2, int out2, float xp) {
        if (!OreDictionary.getOres((String)output1).isEmpty() && !OreDictionary.getOres((String)output2).isEmpty()) {
            ItemStack o1 = ((ItemStack)OreDictionary.getOres((String)output1).get(0)).func_77946_l();
            o1.func_190920_e(out1);
            ItemStack o2 = ((ItemStack)OreDictionary.getOres((String)output2).get(0)).func_77946_l();
            o2.func_190920_e(out2);
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addCrystallization(stack, o1, o2, xp);
            }
        }
    }

    public static void addSingleCrystallization(String input, String output, float xp) {
        if (!OreDictionary.getOres((String)output).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addSingleCrystallization(stack, (ItemStack)OreDictionary.getOres((String)output).get(0), xp);
            }
        }
    }

    public static void addSingleCrystallization(String input, String output, int out, float xp) {
        if (!OreDictionary.getOres((String)output).isEmpty()) {
            ItemStack o = ((ItemStack)OreDictionary.getOres((String)output).get(0)).func_77946_l();
            o.func_190920_e(out);
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addSingleCrystallization(stack, o, xp);
            }
        }
    }

    public static void addTransmutation(String input, String output, float xp) {
        if (!OreDictionary.getOres((String)output).isEmpty()) {
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addTransmutation(stack, (ItemStack)OreDictionary.getOres((String)output).get(0), xp);
            }
        }
    }

    public static void addTransmutation(String input, String output, int out, float xp) {
        if (!OreDictionary.getOres((String)output).isEmpty()) {
            ItemStack o = ((ItemStack)OreDictionary.getOres((String)output).get(0)).func_77946_l();
            o.func_190920_e(out);
            for (ItemStack stack : OreDictionary.getOres((String)input)) {
                AbyssalCraftAPI.addTransmutation(stack, o, xp);
            }
        }
    }

    public static void addCoin(ItemStack coin) {
        if (!EngraverRecipes.instance().getCoinList().contains(coin)) {
            EngraverRecipes.instance().addCoin(coin);
        } else {
            logger.log(Level.ERROR, "This Coin is already registered!");
        }
    }

    public static void addCoin(Item coin) {
        if (!EngraverRecipes.instance().getCoinList().contains(new ItemStack(coin))) {
            EngraverRecipes.instance().addCoin(coin);
        } else {
            logger.log(Level.ERROR, "This Coin is already registered!");
        }
    }

    public static void addEngraving(ItemStack coin, ItemEngraving engraving, float xp) {
        if (!EngraverRecipes.instance().getEngravings().containsKey(engraving) && !EngraverRecipes.instance().getEngravings().containsValue(coin)) {
            EngraverRecipes.instance().addEngraving(coin, engraving, xp);
        } else {
            logger.log(Level.ERROR, "This Engraving Template and/or Engraved Coin is already registered!");
        }
    }

    public static void addEngraving(Item coin, ItemEngraving engraving, float xp) {
        if (!EngraverRecipes.instance().getEngravings().containsKey(engraving) && !EngraverRecipes.instance().getEngravings().containsValue(new ItemStack(coin))) {
            EngraverRecipes.instance().addEngraving(coin, engraving, xp);
        } else {
            logger.log(Level.ERROR, "This Engraving Template and/or Engraved Coin is already registered!");
        }
    }

    @Deprecated
    public static void addMaterialization(ItemStack[] input, ItemStack output) {
        AbyssalCraftAPI.addMaterialization(output, input);
    }

    public static void addMaterialization(ItemStack output, ItemStack ... input) {
        for (ItemStack item : input) {
            if (APIUtils.isCrystal(item)) continue;
            throw new ClassCastException("All of the input items has to be Crystals!");
        }
        if (input.length > 0 && input != null) {
            if (input.length <= 5) {
                MaterializerRecipes.instance().materialize(input, output);
            } else {
                logger.log(Level.ERROR, "This Materializer recipe has more than 5 inputs! ({})", (Object)input.length);
            }
        } else {
            logger.log(Level.ERROR, "This Materializer recipe has no inputs!");
        }
    }

    public static void addMaterialization(Materialization materialization) {
        MaterializerRecipes.instance().materialize(materialization);
    }

    public static void addMaterialization(String output, ItemStack ... input) {
        OreDictionary.getOres((String)output).forEach(stack -> {
            if (stack.func_77981_g() && stack.func_77960_j() == Short.MAX_VALUE) {
                NonNullList list = NonNullList.func_191196_a();
                stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), list);
                list.stream().filter(Predicates.not(ItemStack::func_190926_b)).forEach(is -> AbyssalCraftAPI.addMaterialization(is, input));
            } else {
                AbyssalCraftAPI.addMaterialization(stack, input);
            }
        });
    }

    @Deprecated
    public static void registerFuelHandler(IFuelHandler handler, FuelType type) {
    }

    public static int getFuelValue(ItemStack itemStack, FuelType type) {
        if (type == FuelType.FURNACE) {
            return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack);
        }
        FuelBurnTimeEvent event = new FuelBurnTimeEvent(itemStack, type);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getBurnTime();
    }

    public static void addCrystal(ItemStack crystal) {
        crystals.add(crystal);
    }

    public static List<ItemStack> getCrystals() {
        return crystals;
    }

    public static void registerNecronomiconData(NecroData data, int bookType) {
        if (bookType <= 4 && bookType >= 0) {
            necroData.put(data, bookType);
        } else {
            logger.log(Level.ERROR, "Necronomicon book type does not exist: {}", (Object)bookType);
        }
    }

    public static Map<NecroData, Integer> getNecronomiconData() {
        return necroData;
    }

    public static void addGhoulHelmetTexture(Item helmet, ResourceLocation res) {
        if (helmet == null || res == null) {
            return;
        }
        if (ghoul_helmet.containsKey(helmet)) {
            logger.log(Level.INFO, "Mod {} is overwriting the texture for Helmet {}", (Object)Loader.instance().activeModContainer().getModId(), (Object)helmet.getRegistryName());
        }
        ghoul_helmet.put(helmet, res);
    }

    public static void addGhoulChestplateTexture(Item chestplate, ResourceLocation res) {
        if (chestplate == null || res == null) {
            return;
        }
        if (ghoul_chestplate.containsKey(chestplate)) {
            logger.log(Level.INFO, "Mod {} is overwriting the texture for Chestplate {}", (Object)Loader.instance().activeModContainer().getModId(), (Object)chestplate.getRegistryName());
        }
        ghoul_chestplate.put(chestplate, res);
    }

    public static void addGhoulLeggingsTexture(Item leggings, ResourceLocation res) {
        if (leggings == null || res == null) {
            return;
        }
        if (ghoul_leggings.containsKey(leggings)) {
            logger.log(Level.INFO, "Mod {} is overwriting the texture for Leggings {}", (Object)Loader.instance().activeModContainer().getModId(), (Object)leggings.getRegistryName());
        }
        ghoul_leggings.put(leggings, res);
    }

    public static void addGhoulBootsTexture(Item boots, ResourceLocation res) {
        if (boots == null || res == null) {
            return;
        }
        if (ghoul_boots.containsKey(boots)) {
            logger.log(Level.INFO, "Mod {} is overwriting the texture for Boots {}", (Object)Loader.instance().activeModContainer().getModId(), (Object)boots.getRegistryName());
        }
        ghoul_boots.put(boots, res);
    }

    public static void addGhoulHelmetTexture(Item helmet, String res) {
        AbyssalCraftAPI.addGhoulHelmetTexture(helmet, new ResourceLocation(res));
    }

    public static void addGhoulChestplateTexture(Item chestplate, String res) {
        AbyssalCraftAPI.addGhoulChestplateTexture(chestplate, new ResourceLocation(res));
    }

    public static void addGhoulLeggingsTexture(Item leggings, String res) {
        AbyssalCraftAPI.addGhoulLeggingsTexture(leggings, new ResourceLocation(res));
    }

    public static void addGhoulBootsTexture(Item boots, String res) {
        AbyssalCraftAPI.addGhoulBootsTexture(boots, new ResourceLocation(res));
    }

    public static void addGhoulArmorTextures(Item helmet, Item chestplate, Item leggings, Item boots, ResourceLocation res1, ResourceLocation res2) {
        AbyssalCraftAPI.addGhoulHelmetTexture(helmet, res1);
        AbyssalCraftAPI.addGhoulChestplateTexture(chestplate, res1);
        AbyssalCraftAPI.addGhoulLeggingsTexture(leggings, res2);
        AbyssalCraftAPI.addGhoulBootsTexture(boots, res1);
    }

    public static void addGhoulArmorTextures(Item helmet, Item chestplate, Item leggings, Item boots, String res1, String res2) {
        AbyssalCraftAPI.addGhoulArmorTextures(helmet, chestplate, leggings, boots, new ResourceLocation(res1), new ResourceLocation(res2));
    }

    public static ResourceLocation getGhoulHelmetTexture(Item helmet) {
        return ghoul_helmet.get(helmet);
    }

    public static ResourceLocation getGhoulChestplateTexture(Item chestplate) {
        return ghoul_chestplate.get(chestplate);
    }

    public static ResourceLocation getGhoulLeggingsTexture(Item leggings) {
        return ghoul_leggings.get(leggings);
    }

    public static ResourceLocation getGhoulBootsTexture(Item boots) {
        return ghoul_boots.get(boots);
    }

    public static void addGatewayKeyOverride(int dimId, int type) {
        gateway_key_overrides.put(dimId, type);
    }

    public static int getGatewayKeyOverride(int dimId) {
        return !gateway_key_overrides.containsKey(dimId) ? -1 : gateway_key_overrides.get(dimId);
    }

    public static void addUpgrade(ItemUpgradeKit kit, ItemStack input, ItemStack output) {
        UpgradeKitRecipes.instance().addUpgrade(kit, input, output);
    }

    public static void addUpgradeKit(ItemUpgradeKit kit) {
        UpgradeKitRecipes.instance().addUpgradeKit(kit);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setAkloFont(FontRenderer font) {
        if (aklo_font == null && Loader.instance().getLoaderState() == LoaderState.INITIALIZATION && Loader.instance().activeModContainer().getModId().equals("abyssalcraft")) {
            aklo_font = font;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static FontRenderer getAkloFont() {
        return aklo_font;
    }

    static {
        coralium = new DamageSource("coralium").func_76348_h().func_82726_p();
        dread = new DamageSource("dread").func_76348_h().func_82726_p();
        antimatter = new DamageSource("antimatter").func_76348_h().func_151518_m().func_82726_p();
        shadow = new DamageSource("shadow").func_76348_h().func_151518_m();
        acid = new DamageSource("shoggoth_acid").func_76348_h().func_151518_m();
        crystals = new ArrayList<ItemStack>();
        necroData = new HashMap<NecroData, Integer>();
        ghoul_helmet = new HashMap<Item, ResourceLocation>();
        ghoul_chestplate = new HashMap<Item, ResourceLocation>();
        ghoul_leggings = new HashMap<Item, ResourceLocation>();
        ghoul_boots = new HashMap<Item, ResourceLocation>();
        gateway_key_overrides = new HashMap<Integer, Integer>();
        SHADOW = EnumHelper.addCreatureAttribute((String)"SHADOW");
        abyssalniteArmor = EnumHelper.addArmorMaterial((String)"Abyssalnite", (String)"abyssalcraft:abyssalnite", (int)35, (int[])new int[]{3, 6, 8, 3}, (int)13, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        dreadedAbyssalniteArmor = EnumHelper.addArmorMaterial((String)"Dread", (String)"abyssalcraft:dread", (int)36, (int[])new int[]{3, 6, 8, 3}, (int)15, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        refinedCoraliumArmor = EnumHelper.addArmorMaterial((String)"Coralium", (String)"abyssalcraft:coralium", (int)37, (int[])new int[]{3, 6, 8, 3}, (int)14, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        platedCoraliumArmor = EnumHelper.addArmorMaterial((String)"CoraliumP", (String)"abyssalcraft:coraliump", (int)55, (int[])new int[]{4, 7, 9, 4}, (int)14, (SoundEvent)SoundEvents.field_187725_r, (float)3.0f);
        depthsArmor = EnumHelper.addArmorMaterial((String)"Depths", (String)"abyssalcraft:depths", (int)33, (int[])new int[]{3, 6, 8, 3}, (int)25, (SoundEvent)SoundEvents.field_187725_r, (float)1.5f);
        dreadiumArmor = EnumHelper.addArmorMaterial((String)"Dreadium", (String)"abyssalcraft:dreadium", (int)40, (int[])new int[]{3, 6, 8, 3}, (int)15, (SoundEvent)SoundEvents.field_187725_r, (float)1.0f);
        dreadiumSamuraiArmor = EnumHelper.addArmorMaterial((String)"DreadiumS", (String)"abyssalcraft:dreadiums", (int)45, (int[])new int[]{3, 6, 8, 3}, (int)20, (SoundEvent)SoundEvents.field_187725_r, (float)1.5f);
        ethaxiumArmor = EnumHelper.addArmorMaterial((String)"Ethaxium", (String)"abyssalcraft:ethaxium", (int)50, (int[])new int[]{3, 6, 8, 3}, (int)25, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
        darkstoneTool = EnumHelper.addToolMaterial((String)"DARKSTONE", (int)1, (int)180, (float)5.0f, (float)1.0f, (int)5);
        abyssalniteTool = EnumHelper.addToolMaterial((String)"ABYSSALNITE", (int)4, (int)1261, (float)10.0f, (float)4.0f, (int)12);
        refinedCoraliumTool = EnumHelper.addToolMaterial((String)"CORALIUM", (int)5, (int)1800, (float)12.0f, (float)5.0f, (int)13);
        dreadiumTool = EnumHelper.addToolMaterial((String)"DREADIUM", (int)6, (int)2300, (float)14.0f, (float)6.0f, (int)14);
        ethaxiumTool = EnumHelper.addToolMaterial((String)"ETHAXIUM", (int)8, (int)2800, (float)16.0f, (float)8.0f, (int)20);
        internalNDHandler = new DummyNecroDataHandler();
        internalMethodHandler = new DummyMethodHandler();
        logger = LogManager.getLogger((String)"AbyssalCraftAPI");
    }

    public static class ACEntities {
        private static String[] mobNames = new String[]{"depthsghoul", "evilpig", "abyssalzombie", "Jzahar", "abygolem", "dreadgolem", "dreadguard", "dragonminion", "dragonboss", "shadowcreature", "shadowmonster", "dreadling", "dreadspawn", "demonpig", "gskeleton", "chagarothspawn", "chagarothfist", "chagaroth", "shadowbeast", "shadowboss", "antiabyssalzombie", "antibat", "antichicken", "anticow", "anticreeper", "antighoul", "antipig", "antiplayer", "antiskeleton", "antispider", "antizombie", "lessershoggoth", "shadowtitan", "omotholwarden", "jzaharminion", "omotholghoul", "remnant", "greaterdreadspawn", "lesserdreadbeast", "evilcow", "evilchicken", "demoncow", "demonchicken", "evilsheep", "demonsheep", "coraliumsquid"};
        public static String depths_ghoul = mobNames[0];
        public static String evil_pig = mobNames[1];
        public static String abyssal_zombie = mobNames[2];
        public static String jzahar = mobNames[3];
        public static String abyssalnite_golem = mobNames[4];
        public static String dreaded_abyssalnite_golem = mobNames[5];
        public static String dreadguard = mobNames[6];
        public static String spectral_dragon = mobNames[7];
        public static String asorah = mobNames[8];
        public static String shadow_creature = mobNames[9];
        public static String shadow_monster = mobNames[10];
        public static String dreadling = mobNames[11];
        public static String dread_spawn = mobNames[12];
        public static String demon_pig = mobNames[13];
        public static String skeleton_goliath = mobNames[14];
        public static String spawn_of_chagaroth = mobNames[15];
        public static String fist_of_chagaroth = mobNames[16];
        public static String chagaroth = mobNames[17];
        public static String shadow_beast = mobNames[18];
        public static String sacthoth = mobNames[19];
        public static String abyssal_anti_zombie = mobNames[20];
        public static String anti_bat = mobNames[21];
        public static String anti_chicken = mobNames[22];
        public static String anti_cow = mobNames[23];
        public static String anti_creeper = mobNames[24];
        public static String anti_ghoul = mobNames[25];
        public static String anti_pig = mobNames[26];
        public static String anti_player = mobNames[27];
        public static String anti_skeleton = mobNames[28];
        public static String anti_spider = mobNames[29];
        public static String anti_zombie = mobNames[30];
        public static String lesser_shoggoth = mobNames[31];
        public static String shadow_titan = mobNames[32];
        public static String omothol_warden = mobNames[33];
        public static String minion_of_the_gatekeeper = mobNames[34];
        public static String omothol_ghoul = mobNames[35];
        public static String remnant = mobNames[36];
        public static String greater_dread_spawn = mobNames[37];
        public static String lesser_dreadbeast = mobNames[38];
        public static String evil_cow = mobNames[39];
        public static String evil_chicken = mobNames[40];
        public static String demon_cow = mobNames[41];
        public static String demon_chicken = mobNames[42];
        public static String evil_sheep = mobNames[43];
        public static String demon_sheep = mobNames[44];
        public static String coralium_squid = mobNames[45];
    }

    public static enum FuelType {
        CRYSTALLIZER,
        TRANSMUTATOR,
        FURNACE;

    }
}

