/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.equipbauble;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipeAndRepair;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseCharm;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.LootTableRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemCharmVoid
extends BaseCharm
implements IHasRecipeAndRepair,
IContent {
    private static final int durability = 16;
    private static final int yLowest = -30;
    private static final int yDest = 255;
    private static final ItemStack craftItem = new ItemStack(Items.field_151061_bv);
    private boolean enabled;

    public ItemCharmVoid() {
        super(16);
    }

    @Override
    public String getContentName() {
        return "charm_void";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMBAUBLES);
        LootTableRegistry.registerLoot(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("VoidCharm", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public void onTick(ItemStack stack, EntityPlayer living) {
        if (!this.canTick(stack)) {
            return;
        }
        World worldIn = living.func_130014_f_();
        if (living.func_180425_c().func_177956_o() < -30) {
            UtilEntity.teleportWallSafe((EntityLivingBase)living, worldIn, new BlockPos(living.func_180425_c().func_177958_n(), 255, living.func_180425_c().func_177952_p()));
            super.damageCharm(living, stack);
            UtilSound.playSound(living, living.func_180425_c(), SoundEvents.field_187534_aX, living.func_184176_by());
            UtilParticle.spawnParticle(worldIn, EnumParticleTypes.PORTAL, living.func_180425_c());
        }
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == craftItem.func_77973_b();
    }

    @Override
    public IRecipe addRecipe() {
        return super.addRecipe(craftItem);
    }
}

