/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.registry.BlackLists;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.TileUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemDolly
extends ItemEnderUtilities {
    public ItemDolly(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        player.func_184609_a(hand);
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.isCarryingBlock(stack)) {
                this.tryPlaceDownBlock(stack, player, world, pos, side);
            } else {
                this.tryPickUpBlock(stack, player, world, pos, side);
            }
        }
        return world.field_72995_K ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
    }

    public String func_77653_i(ItemStack stack) {
        String nameBase = super.func_77653_i(stack);
        String name = this.getCarriedBlockName(stack);
        if (name != null) {
            return nameBase + " - " + name;
        }
        return nameBase;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        String name = this.getCarriedBlockName(stack);
        if (name != null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.carrying", (Object[])new Object[]{name}));
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, "Carrying", false);
        if (tag != null) {
            NBTTagCompound newTagCarrying = new NBTTagCompound();
            newTagCarrying.func_74778_a("Block", tag.func_74779_i("Block"));
            if (tag.func_150297_b("DisplayName", 8)) {
                newTagCarrying.func_74778_a("DisplayName", tag.func_74779_i("DisplayName"));
            }
            NBTTagCompound newTag = new NBTTagCompound();
            newTag.func_74782_a("Carrying", (NBTBase)newTagCarrying);
            return newTag;
        }
        return null;
    }

    @Nullable
    private String getCarriedBlockName(ItemStack stack) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, "Carrying", false);
        if (tag != null) {
            String name = tag.func_150297_b("DisplayName", 8) ? tag.func_74779_i("DisplayName") : tag.func_74779_i("Block");
            return name;
        }
        return null;
    }

    private boolean shouldTryToPickUpBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!BlackLists.isBlockAllowedForDolly(state)) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (state.func_185887_b(world, pos) < 0.0f) {
            if (!(te instanceof TileEntityEnderUtilitiesInventory)) {
                return false;
            }
            TileEntityEnderUtilitiesInventory teinv = (TileEntityEnderUtilitiesInventory)te;
            return !teinv.isCreative() && teinv.isMovableBy(player);
        }
        return te instanceof TileEntityEnderUtilitiesInventory || te instanceof IInventory || te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    private boolean tryPickUpBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (this.isCarryingBlock(stack) || !this.shouldTryToPickUpBlock(world, pos, side, player)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        String name = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)state.func_177230_c()).toString();
        int meta = state.func_177230_c().func_176201_c(state);
        NBTTagCompound tagCarrying = NBTUtils.getCompoundTag(stack, "Carrying", true);
        tagCarrying.func_74778_a("Block", name);
        tagCarrying.func_74774_a("Meta", (byte)meta);
        tagCarrying.func_74774_a("PickupFacing", (byte)EntityUtils.getHorizontalLookingDirection((Entity)player).func_176745_a());
        ItemStack stackBlock = state.func_177230_c().getPickBlock(state, EntityUtils.getRayTraceFromPlayer(world, player, false), world, pos, player);
        if (!stackBlock.func_190926_b()) {
            tagCarrying.func_74778_a("DisplayName", stackBlock.func_82833_r());
        }
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.func_189515_b(tag);
            tagCarrying.func_74782_a("te", (NBTBase)tag);
        }
        BlockUtils.setBlockToAirWithoutSpillingContents(world, pos);
        return true;
    }

    private boolean tryPlaceDownBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        pos = pos.func_177972_a(side);
        if (!this.isCarryingBlock(stack) || !world.func_175660_a(player, pos)) {
            return false;
        }
        NBTTagCompound tagCarrying = NBTUtils.getCompoundTag(stack, "Carrying", false);
        String name = tagCarrying.func_74779_i("Block");
        byte meta = tagCarrying.func_74771_c("Meta");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        try {
            if (block != null && block != Blocks.field_150350_a && world.func_190527_a(block, pos, false, side, (Entity)player)) {
                EnumFacing currentFacing;
                IBlockState state = block.func_176203_a((int)meta);
                EnumFacing pickupFacing = EnumFacing.func_82600_a((int)tagCarrying.func_74771_c("PickupFacing"));
                Rotation rotation = PositionUtils.getRotation(pickupFacing, currentFacing = EntityUtils.getHorizontalLookingDirection((Entity)player));
                if (world.func_175656_a(pos, state = state.func_185907_a(rotation))) {
                    TileEntity te = world.func_175625_s(pos);
                    if (te != null && tagCarrying.func_150297_b("te", 10)) {
                        NBTTagCompound nbt = tagCarrying.func_74775_l("te");
                        TileUtils.createAndAddTileEntity(world, pos, nbt, rotation, Mirror.NONE);
                    }
                    NBTUtils.removeCompoundTag(stack, null, "Carrying");
                    return true;
                }
            }
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to place down a block from the Dolly", (Throwable)e);
        }
        return false;
    }

    private boolean isCarryingBlock(ItemStack stack) {
        return NBTUtils.getCompoundTag(stack, "Carrying", false) != null;
    }

    @Override
    protected void addItemOverrides() {
        this.func_185043_a(new ResourceLocation("enderutilities", "carrying"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return ItemDolly.this.isCarryingBlock(stack) ? 1.0f : 0.0f;
            }
        });
    }
}

