/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.block.BlockElevator;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.event.GuiEventHandler;
import fi.dy.masa.enderutilities.gui.client.GuiHandyBag;
import fi.dy.masa.enderutilities.gui.client.GuiScreenBuilderWandTemplate;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.item.block.ItemBlockPlacementProperty;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.network.message.MessageKeyPressed;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.registry.Keybindings;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InputEventHandler {
    private static final Int2LongOpenHashMap KEY_PRESS_TIMES = new Int2LongOpenHashMap();
    private final Minecraft mc = Minecraft.func_71410_x();
    private static int scrollingMask = 0;
    private static int modifierMask = 0;
    public static int doubleTapLimit = 500;

    public static void resetModifiers() {
        scrollingMask = 0;
        modifierMask = 0;
    }

    public static boolean isHoldingKeyboundItem(EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, IKeyBound.class);
        return !stack.func_190926_b() && (!(stack.func_77973_b() instanceof ItemBlockPlacementProperty) || ((ItemBlockPlacementProperty)stack.func_77973_b()).hasPlacementProperty(stack));
    }

    public static boolean hasKeyBoundUnselectedItem(EntityPlayer player) {
        return !InventoryUtils.getFirstItemOfType(player, IKeyBoundUnselected.class).func_190926_b();
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        int keyCode = Keyboard.getEventKey();
        boolean keyState = Keyboard.getEventKeyState();
        this.onInputEvent(keyCode, keyState);
    }

    @SubscribeEvent
    public void onGuiKeyInputEventPre(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (event.getGui() instanceof GuiHandyBag) {
            int key = Keyboard.getEventKey();
            if (Keyboard.getEventKeyState() && (key == 42 || key == 54) && this.checkForDoubleTap(key)) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1001, 7, 0));
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        int dWheel = event.getDwheel();
        if (dWheel != 0) {
            EntityPlayerSP player;
            dWheel /= 120;
            if (scrollingMask != 0 && InputEventHandler.isHoldingKeyboundItem((EntityPlayer)(player = FMLClientHandler.instance().getClientPlayerEntity()))) {
                int key = 0x1000 | scrollingMask;
                if (dWheel > 0) {
                    key |= 0x100000;
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
            }
        } else if (this.onInputEvent(Mouse.getEventButton() - 100, Mouse.getEventButtonState())) {
            event.setCanceled(true);
        }
    }

    private boolean onInputEvent(int keyCode, boolean keyState) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null) {
            return false;
        }
        if (HotKeys.isModifierKey(keyCode)) {
            int mask = HotKeys.getModifierMask(keyCode);
            if (keyState) {
                modifierMask |= mask;
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
                    scrollingMask |= mask;
                }
            } else {
                modifierMask &= ~mask;
                scrollingMask &= ~mask;
            }
        }
        if (this.mc.field_71415_G) {
            if (keyState && Keybindings.keyToggleMode.isActiveAndMatches(keyCode)) {
                if (this.buildersWandClientSideHandling()) {
                    return false;
                }
                if (InputEventHandler.isHoldingKeyboundItem((EntityPlayer)player)) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(1 | modifierMask));
                    return false;
                }
            }
            if (keyState && Keybindings.keyActivateUnselected.isActiveAndMatches(keyCode) && InputEventHandler.hasKeyBoundUnselectedItem((EntityPlayer)player)) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(1 | modifierMask));
                return false;
            }
            if (this.mc.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                boolean shouldOpen = keyState && player.func_70093_af() == Configs.handyBagOpenRequiresSneak;
                GuiEventHandler.instance().setHandyBagShouldOpen(shouldOpen);
            } else if (keyCode == 1) {
                GuiEventHandler.instance().setHandyBagShouldOpen(false);
            } else if (keyState && this.mc.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                World world = player.func_130014_f_();
                RayTraceResult trace = EntityUtils.getRayTraceFromPlayer(world, (EntityPlayer)player, true);
                if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK) {
                    int key = 0x2000 | HotKeys.getActiveModifierMask();
                    BlockPos pos = trace.func_178782_a();
                    TileEntityEnderUtilities te = BlockEnderUtilities.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class);
                    if (te != null && te.onInputAction(key, (EntityPlayer)player, trace, world, pos)) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
                        return true;
                    }
                }
            } else if (keyState && (keyCode == this.mc.field_71474_y.field_74314_A.func_151463_i() || keyCode == this.mc.field_71474_y.field_74311_E.func_151463_i())) {
                BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                World world = player.func_130014_f_();
                if (world.func_180495_p(pos).func_177230_c() instanceof BlockElevator || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockElevator) {
                    int key = keyCode == this.mc.field_71474_y.field_74314_A.func_151463_i() ? 0x2000000 : 0x1000000;
                    PacketHandler.INSTANCE.sendToServer((IMessage)new MessageKeyPressed(key));
                }
            }
        }
        return false;
    }

    private boolean checkForDoubleTap(int key) {
        boolean ret;
        long currentTime = System.currentTimeMillis();
        boolean bl = ret = KEY_PRESS_TIMES.containsKey(key) && currentTime - KEY_PRESS_TIMES.get(key) <= (long)doubleTapLimit;
        if (!ret) {
            KEY_PRESS_TIMES.put(key, currentTime);
        } else {
            KEY_PRESS_TIMES.remove(key);
        }
        return ret;
    }

    private boolean buildersWandClientSideHandling() {
        if (GuiScreen.func_146272_n() || GuiScreen.func_146271_m() || GuiScreen.func_175283_s()) {
            return false;
        }
        ItemStack stack = this.mc.field_71439_g.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.BUILDERS_WAND && ItemBuildersWand.Mode.getMode(stack) == ItemBuildersWand.Mode.COPY) {
            this.mc.func_147108_a((GuiScreen)new GuiScreenBuilderWandTemplate());
            return true;
        }
        return false;
    }
}

