/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_ender.tile;

import com.valkyrieofnight.sg.m_generators.inventory.ContainerGenBase;
import com.valkyrieofnight.sg.m_generators.m_ender.GEnder;
import com.valkyrieofnight.sg.m_generators.m_ender.gui.GuiGenEnder;
import com.valkyrieofnight.sg.m_generators.tile.TileGenBaseItem;
import com.valkyrieofnight.vlib.core.util.StringUtils;
import com.valkyrieofnight.vliblegacy.lib.util.ConfigCategoryUtil;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileData;
import com.valkyrieofnight.vliblegacy.m_guide.registry.TileDataProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fml.common.Optional;

public class TileGenEnderUpgradable
extends TileGenBaseItem {
    public static ConfigCategoryUtil CCU;
    public static int GEN_CAPACITOR;
    public static int GEN_FUEL_RF_VALUE;
    public static int GEN_MODIFIER_SLOTS;
    public static TileDataProvider DP;

    public static void loadConfigs(ConfigCategory config) {
        GEN_CAPACITOR = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_upgradable_capacitor", (int)GEN_CAPACITOR, (int)8000, (int)32000000, (String)"How much RF can this gen store?");
        GEN_FUEL_RF_VALUE = ConfigCategoryUtil.getInt((ConfigCategory)config, (String)"gen_upgradable_fuel_rf_value", (int)GEN_FUEL_RF_VALUE, (int)1, (int)2000000, (String)"How much RF is generated from a fuel value of 1?");
    }

    public TileGenEnderUpgradable() {
        super(GEN_CAPACITOR, 4);
    }

    protected boolean isValidFuel(ItemStack fuel) {
        return GEnder.ENDER_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    protected int getRFTotal(ItemStack stack) {
        return GEnder.ENDER_REG_SIMPLE.getEnergyValue(stack);
    }

    @Override
    public EnumFacing[] validConectionDirections() {
        return EnumFacing.field_82609_l;
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 4;
    }

    @Override
    protected int getDurationFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel) / GEN_FUEL_RF_VALUE;
    }

    @Override
    protected int getRFTotalFromFuel(ItemStack fuel) {
        return this.getRFTotal(fuel);
    }

    @Override
    protected boolean isValidInputStack(ItemStack fuel) {
        return GEnder.ENDER_REG_SIMPLE.getEnergyValue(fuel) > 0;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiGenEnder(player, new ContainerGenBase(player.field_71071_by, this), this);
    }

    static {
        GEN_CAPACITOR = 1024000;
        GEN_FUEL_RF_VALUE = 160;
        GEN_MODIFIER_SLOTS = 4;
        DP = new TileDataProvider("ender_upgradable");
        DP.registerData(new TileData("capacitor"){

            public String getLocalizedData() {
                return "" + StringUtils.formatNumber((int)GEN_CAPACITOR);
            }
        });
        DP.registerData(new TileData("energy_tick"){

            public String getLocalizedData() {
                return "" + GEN_FUEL_RF_VALUE;
            }
        });
        DP.registerData(new TileData("modifierslots"){

            public String getLocalizedData() {
                return "" + GEN_MODIFIER_SLOTS;
            }
        });
    }
}

