/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot.traits;

import java.util.Map;
import mcjty.xnet.api.gui.IEditorGui;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.ynot.traits.Trait;

public class TraitEnum<T extends Enum>
extends Trait<T> {
    private final Class<T> tClass;
    private T mode;
    private T defaultValue;

    public TraitEnum(String tag, Class<T> tClass, T defaultValue) {
        super(tag);
        this.tClass = tClass;
        this.mode = defaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public void readFromNBT(NBTTagCompound cpt) {
        byte b = cpt.func_74771_c(this.tag);
        this.mode = ((Enum[])this.tClass.getEnumConstants()).length > b ? ((Enum[])this.tClass.getEnumConstants())[b] : this.defaultValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound cpt) {
        cpt.func_74774_a(this.tag, (byte)((Enum)this.mode).ordinal());
    }

    @Override
    public void update(Map<String, Object> data) {
        if (data.containsKey(this.tag)) {
            String s = ((String)data.get(this.tag)).toUpperCase();
            for (Enum e : (Enum[])this.tClass.getEnumConstants()) {
                if (!s.equals(e.toString().toUpperCase())) continue;
                this.mode = e;
            }
        }
    }

    @Override
    public T get() {
        return this.mode;
    }

    @Override
    public IEditorGui apply(String tip, IEditorGui gui) {
        return gui.choices(this.tag, tip, this.mode, (Enum[])this.tClass.getEnumConstants());
    }
}

