/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.PreparedRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeLoader;
import hellfirepvp.modularmachinery.common.crafting.adapter.RecipeAdapterAccessor;
import hellfirepvp.modularmachinery.common.data.DataLoadProfiler;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.ProgressManager;

public class RecipeRegistry {
    private static RecipeRegistry INSTANCE = new RecipeRegistry();
    private static Map<ResourceLocation, TreeMap<Integer, TreeSet<MachineRecipe>>> REGISTRY_RECIPE_BY_MACHINE;
    private static Map<ResourceLocation, MachineRecipe> RECIPE_REGISTRY;
    private List<PreparedRecipe> earlyRecipes = new LinkedList<PreparedRecipe>();

    private RecipeRegistry() {
    }

    public static RecipeRegistry getRegistry() {
        return INSTANCE;
    }

    @Nonnull
    public Iterable<MachineRecipe> getRecipesFor(DynamicMachine machine) {
        TreeMap<Integer, TreeSet<MachineRecipe>> recipes = REGISTRY_RECIPE_BY_MACHINE.get(machine.getRegistryName());
        if (recipes == null) {
            return Lists.newArrayList();
        }
        return Iterables.concat(recipes.values());
    }

    @Nullable
    public MachineRecipe getRecipe(ResourceLocation key) {
        return RECIPE_REGISTRY.get(key);
    }

    public void buildRegistry() {
        REGISTRY_RECIPE_BY_MACHINE = new HashMap<ResourceLocation, TreeMap<Integer, TreeSet<MachineRecipe>>>();
        RECIPE_REGISTRY = new HashMap<ResourceLocation, MachineRecipe>();
    }

    public Map<DynamicMachine, List<MachineRecipe>> loadRecipes(@Nullable EntityPlayer player) {
        ProgressManager.ProgressBar barRecipes = ProgressManager.push((String)"RecipeRegistry", (int)3);
        barRecipes.step("Discovering Files");
        DataLoadProfiler profiler = new DataLoadProfiler();
        boolean frozen = MachineRecipe.isFrozen();
        if (frozen) {
            MachineRecipe.unfreeze();
        }
        Map<RecipeLoader.FileType, List<File>> potentialRecipes = RecipeLoader.discoverDirectory(CommonProxy.dataHolder.getRecipeDirectory());
        barRecipes.step("Loading Recipes");
        List<MachineRecipe> recipes = RecipeLoader.loadRecipes(potentialRecipes, this.earlyRecipes);
        DataLoadProfiler.StatusLine sl = profiler.createLine("Load-Phase: ");
        DataLoadProfiler.Status success = sl.appendStatus("%s loaded");
        DataLoadProfiler.Status failed = sl.appendStatus("%s failed");
        success.setCounter(recipes.size());
        Map<String, Exception> failures = RecipeLoader.captureFailedAttempts();
        failed.setCounter(failures.size());
        if (failures.size() > 0) {
            ModularMachinery.log.warn("Encountered " + failures.size() + " problems while loading recipe!");
            for (String fileName : failures.keySet()) {
                ModularMachinery.log.warn("Couldn't load recipe from file " + fileName);
                failures.get(fileName).printStackTrace();
            }
        }
        HashMap<DynamicMachine, List<MachineRecipe>> out = new HashMap<DynamicMachine, List<MachineRecipe>>();
        DataLoadProfiler.StatusLine unknown = profiler.createLine("");
        DataLoadProfiler.Status unknownCounter = unknown.appendStatus("Unknown Machinery: %s");
        HashMap<DynamicMachine, Tuple> statusMap = new HashMap<DynamicMachine, Tuple>();
        HashMap<ResourceLocation, MachineRecipe> tempRegistry = new HashMap<ResourceLocation, MachineRecipe>();
        barRecipes.step("Validation");
        for (MachineRecipe mr : recipes) {
            MachineRecipe other;
            DynamicMachine m = mr.getOwningMachine();
            if (m == null) {
                unknownCounter.incrementCounter();
                ModularMachinery.log.warn("MachineRecipe loaded for unknown machine: " + mr.getOwningMachineIdentifier() + " - responsible file: " + mr.getRecipeFilePath());
                continue;
            }
            Tuple status = (Tuple)statusMap.get(m);
            if (status == null) {
                DataLoadProfiler.StatusLine line = profiler.createLine(m.getRegistryName() + " (Recipes): ");
                status = new Tuple((Object)line.appendStatus("%s loaded"), (Object)line.appendStatus("%s failed"));
                statusMap.put(m, status);
            }
            DataLoadProfiler.Status loaded = (DataLoadProfiler.Status)status.func_76341_a();
            DataLoadProfiler.Status fail = (DataLoadProfiler.Status)status.func_76340_b();
            if (tempRegistry.containsKey(mr.getRegistryName()) && (other = (MachineRecipe)tempRegistry.get(mr.getRegistryName())) != null) {
                ModularMachinery.log.warn("MachineRecipe with registryName " + mr.getRegistryName() + " already exists!");
                ModularMachinery.log.warn("Offending files: '" + mr.getRecipeFilePath() + "' and '" + other.getRecipeFilePath() + "' !");
                fail.incrementCounter();
                continue;
            }
            loaded.incrementCounter();
            tempRegistry.put(mr.getRegistryName(), mr);
            List recipeList = out.computeIfAbsent(mr.getOwningMachine(), r -> Lists.newArrayList());
            recipeList.add(mr);
        }
        profiler.printLines(player);
        ProgressManager.pop((ProgressManager.ProgressBar)barRecipes);
        if (frozen) {
            MachineRecipe.freezeChanges();
        }
        return out;
    }

    public void registerRecipes(Map<DynamicMachine, List<MachineRecipe>> map) {
        for (DynamicMachine machine : map.keySet()) {
            List<MachineRecipe> recipes = map.get(machine);
            for (MachineRecipe recipe : recipes) {
                RECIPE_REGISTRY.put(recipe.getRegistryName(), recipe);
                Map recipeList = REGISTRY_RECIPE_BY_MACHINE.computeIfAbsent(machine.getRegistryName(), k -> new TreeMap());
                TreeSet recipeSet = recipeList.computeIfAbsent(recipe.getConfiguredPriority(), inte -> new TreeSet());
                recipeSet.add(recipe);
            }
        }
        MachineRecipe.freezeChanges();
    }

    public void registerRecipeEarly(PreparedRecipe recipe) {
        this.earlyRecipes.add(recipe);
    }

    public void reloadAdapters() {
        boolean frozen = MachineRecipe.isFrozen();
        if (frozen) {
            MachineRecipe.unfreeze();
        }
        for (RecipeAdapterAccessor accessor : RecipeLoader.recipeAdapters) {
            Map machineRecipeList = REGISTRY_RECIPE_BY_MACHINE.get(accessor.getOwningMachine());
            for (MachineRecipe cached : accessor.getCachedRecipes()) {
                TreeSet recipeTreeSet;
                RECIPE_REGISTRY.remove(cached.getRegistryName());
                if (machineRecipeList == null || (recipeTreeSet = (TreeSet)machineRecipeList.get(cached.getConfiguredPriority())) == null) continue;
                recipeTreeSet.remove(cached);
            }
        }
        for (RecipeAdapterAccessor accessor : RecipeLoader.recipeAdapters) {
            for (MachineRecipe recipe : accessor.loadRecipesForAdapter()) {
                RECIPE_REGISTRY.put(recipe.getRegistryName(), recipe);
                Map recipeList = REGISTRY_RECIPE_BY_MACHINE.computeIfAbsent(accessor.getOwningMachine(), k -> new TreeMap());
                TreeSet recipeSet = recipeList.computeIfAbsent(recipe.getConfiguredPriority(), inte -> new TreeSet());
                recipeSet.add(recipe);
            }
        }
        if (frozen) {
            MachineRecipe.freezeChanges();
        }
    }

    public void clearLingeringRecipes() {
        this.earlyRecipes.clear();
    }
}

