/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.plugin;

import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.util.Environment;
import aroma1997.backup.common.util.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public class PluginLoader {
    private static List<BackupPlugin> plugins;

    private PluginLoader() {
    }

    public static void load() {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            PluginLoader.discover(new File(Environment.getEnv().getMCDir(), "mods"), list);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        URLClassLoader cl = new URLClassLoader(list.toArray(new URL[0]), PluginLoader.class.getClassLoader());
        ServiceLoader<BackupPlugin> serviceLoader = ServiceLoader.load(BackupPlugin.class, cl);
        plugins = new ArrayList<BackupPlugin>();
        for (BackupPlugin plugin : serviceLoader) {
            plugins.add(plugin);
        }
        Collections.sort(plugins);
    }

    public static Collection<BackupPlugin> getPlugins() {
        return plugins;
    }

    private static void discover(File file, List<URL> files) throws MalformedURLException {
        if (file.isDirectory()) {
            for (File next : file.listFiles()) {
                PluginLoader.discover(next, files);
            }
        }
        if (file.isFile() && Util.getExtension(file.getName()).equals("jar")) {
            files.add(file.toURI().toURL());
        }
    }
}

