/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.info;

import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public abstract class BackupInfo
implements Comparable<BackupInfo> {
    protected static final String FILE_ENDING = ".backupinfo";
    private final File backup;
    private final String world;

    protected BackupInfo(File backup, String world) {
        this.backup = backup;
        this.world = world;
    }

    public File getBackupFile() {
        return this.backup;
    }

    public String getWorld() {
        return this.world;
    }

    public abstract Date getBackupDate();

    public abstract File getParentFile();

    public boolean isIncremental() {
        return this.getParentFile() != null && this.getParentFile().exists();
    }

    @Override
    public int compareTo(BackupInfo other) {
        int ret = this.getBackupDate().compareTo(other.getBackupDate());
        if (ret == 0) {
            ret = this.getWorld().compareTo(other.getWorld());
        }
        return ret;
    }

    protected File getInfoFile() {
        File backup = this.getBackupFile();
        return new File(backup.getParent(), backup.getName().substring(0, backup.getName().length() - 1 - Util.getExtension(backup.getName()).length()) + FILE_ENDING);
    }

    public ExistingBackupInfo getParent() {
        if (this.getParentFile() != null && this.getParentFile().exists()) {
            try {
                return new ExistingBackupInfo(this.getParentFile());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public int getAmountParents() throws IOException {
        ExistingBackupInfo info = this.getParent();
        if (info == null) {
            return 0;
        }
        int idx = 1;
        while ((info = info.getParent()) != null) {
            ++idx;
        }
        return idx;
    }

    public int hashCode() {
        long date = this.getBackupDate().getTime();
        return (int)(date ^ date >> 32);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof BackupInfo)) {
            return false;
        }
        BackupInfo info = (BackupInfo)o;
        return this.getBackupDate().equals(info.getBackupDate()) && this.getWorld().equals(info.getWorld());
    }
}

