/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.moons.Ganymede.worldgen;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import com.mjr.mjrlegendslib.world.features.WorldGenSphere;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeDecoratorGanymede
extends BiomeDecoratorSpace {
    private WorldGenerator copperGen;
    private WorldGenerator tinGen;
    private WorldGenerator ironGen;
    private WorldGenerator gravelGen;
    private WorldGenerator fossilsGen;
    private WorldGenerator iceGen;
    private WorldGenerator iceSubSurfaceGen;
    private World currentWorld;
    private boolean isDecorating = false;

    public BiomeDecoratorGanymede() {
        if (Config.GENERATE_ORES_GANYMEDE) {
            this.copperGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 10, 5, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 2);
            this.tinGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 10, 4, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 2);
            this.ironGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 8, 3, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 2);
        }
        this.gravelGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.GANYMEDE_GRAVEL, 12, 0, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 2);
        this.fossilsGen = new WorldGenMinableMeta(ExtraPlanets_Blocks.FOSSIL, 3, 0, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 1);
        this.iceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 10, 0, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 2);
        this.iceSubSurfaceGen = new WorldGenMinableMeta(Blocks.field_150432_aD, 10, 0, true, ExtraPlanets_Blocks.GANYMEDE_BLOCKS, 1);
    }

    protected void setCurrentWorld(World world) {
        this.currentWorld = world;
    }

    protected World getCurrentWorld() {
        return this.currentWorld;
    }

    protected void decorate() {
        int i;
        if (this.isDecorating) {
            return;
        }
        this.isDecorating = true;
        if (Config.GENERATE_ORES_GANYMEDE) {
            this.generateOre(28, this.copperGen, 0, 60);
            this.generateOre(28, this.tinGen, 0, 60);
            this.generateOre(20, this.ironGen, 0, 64);
        }
        this.generateOre(15, this.gravelGen, 0, 80);
        this.generateOre(10, this.fossilsGen, 0, 256);
        this.generateOre(20, this.iceGen, 0, 80);
        this.generateOre(10, this.iceSubSurfaceGen, 0, 256);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        for (i = 0; i < 1; ++i) {
            if (this.rand.nextInt(100) != 0) continue;
            WorldGenUtilities.generateLake((World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (Block)ExtraPlanets_Fluids.INFECTED_WATER, (Block)ExtraPlanets_Blocks.MERCURY_BLOCKS);
        }
        if (Config.GENERATE_GANYMEDE_ICE_CHUNKS) {
            for (i = 0; i < 3; ++i) {
                if (this.rand.nextInt(5) != 1) continue;
                WorldGenUtilities.generateStructureWithRangeY((WorldGenerator)new WorldGenSphere(false, "extraplanets", Blocks.field_150432_aD.func_176223_P(), 12, 2), (World)this.currentWorld, (Random)this.rand, (BlockPos)new BlockPos(this.posX, 0, this.posZ), (int)6, (int)60);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.currentWorld, this.rand, new BlockPos(this.posX, 0, this.posZ)));
        this.isDecorating = false;
    }
}

