/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.data;

import com.buuz135.togetherforever.api.IOfflineSyncRecovery;
import com.buuz135.togetherforever.api.ISyncAction;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.WorldSavedData;

public class DataManager
extends WorldSavedData {
    public static final String NAME = "TogetherForever";
    public static final String TEAM = "Teams";
    public static final String RECOVERY = "Recovery";
    private List<ITogetherTeam> teams = new ArrayList<ITogetherTeam>();
    private List<IOfflineSyncRecovery> recoveries = new ArrayList<IOfflineSyncRecovery>();

    public DataManager(String string) {
        super(string);
    }

    public DataManager() {
        this(NAME);
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        this.teams = new ArrayList<ITogetherTeam>();
        NBTTagCompound raw = nbt.func_74775_l(NAME);
        NBTTagCompound teamCompound = raw.func_74775_l(TEAM);
        for (String teamNames : teamCompound.func_150296_c()) {
            NBTTagCompound team = teamCompound.func_74775_l(teamNames);
            String teamID = team.func_74779_i("TeamID");
            Class<? extends ITogetherTeam> aClass = TogetherRegistries.getTogetherTeamClass(teamID);
            if (aClass == null) continue;
            try {
                ITogetherTeam togetherTeam = aClass.newInstance();
                togetherTeam.readFromNBT(team.func_74775_l("Value"));
                this.teams.add(togetherTeam);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        NBTTagCompound offlineRecovery = nbt.func_74775_l(RECOVERY);
        for (String key : offlineRecovery.func_150296_c()) {
            ISyncAction<?, IOfflineSyncRecovery> action = TogetherRegistries.getSyncActionFromID(key);
            if (action == null) continue;
            try {
                IOfflineSyncRecovery recovery = action.getOfflineRecovery().newInstance();
                recovery.readFromNBT(offlineRecovery.func_74775_l(key));
                this.recoveries.add(recovery);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        NBTTagCompound custom = new NBTTagCompound();
        NBTTagCompound teamCompound = new NBTTagCompound();
        for (ITogetherTeam togetherTeam : this.teams) {
            NBTTagCompound team = new NBTTagCompound();
            team.func_74778_a("TeamID", TogetherRegistries.getTogetherTeamID(togetherTeam.getClass()));
            team.func_74782_a("Value", (NBTBase)togetherTeam.getNBTTag());
            teamCompound.func_74782_a(togetherTeam.getTeamName(), (NBTBase)team);
        }
        custom.func_74782_a(TEAM, (NBTBase)teamCompound);
        NBTTagCompound offlineRecovery = new NBTTagCompound();
        for (IOfflineSyncRecovery recovery : this.recoveries) {
            offlineRecovery.func_74782_a(TogetherRegistries.getSyncActionIdFromOfflineRecovery(recovery), (NBTBase)recovery.writeToNBT());
        }
        custom.func_74782_a(RECOVERY, (NBTBase)offlineRecovery);
        compound.func_74782_a(NAME, (NBTBase)custom);
        return compound;
    }

    public List<ITogetherTeam> getTeams() {
        return this.teams;
    }

    public List<IOfflineSyncRecovery> getRecoveries() {
        return this.recoveries;
    }
}

