/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.data.predicate;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class BlockPredicate {
    public static final BlockPredicate ANY = new BlockPredicate();
    private final Block block;
    private final Integer meta;
    private final Map<IProperty<?>, Object> properties;
    private final String oreDict;

    public BlockPredicate() {
        this.block = null;
        this.meta = null;
        this.properties = null;
        this.oreDict = null;
    }

    public BlockPredicate(@Nullable Block block, @Nullable Integer meta, @Nullable Map<IProperty<?>, Object> properties, @Nullable String oreDict) {
        this.block = block;
        this.meta = meta;
        this.properties = properties;
        this.oreDict = oreDict;
    }

    public boolean test(IBlockState state) {
        if (this.block != null && state.func_177230_c() != this.block) {
            return false;
        }
        if (this.properties != null) {
            for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
        }
        if (this.meta != null && state.func_177230_c().func_176201_c(state) != this.meta.intValue()) {
            return false;
        }
        if (this.oreDict != null) {
            Block block = state.func_177230_c();
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                ItemStack itemStack = new ItemStack(item, 1, block.func_180651_a(state));
                NonNullList ores = OreDictionary.getOres((String)this.oreDict, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack stack : ores) {
                        if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)itemStack, (boolean)false)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

