/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.data;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.predicate.BlockPredicate;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.oredict.OreDictionary;

public class BlockData {
    private String blockName;
    private Integer meta;
    private Map<IProperty<?>, Object> blockStateProps = new HashMap();
    private String oreDict;

    public BlockPredicate buildPredicate() {
        return new BlockPredicate(this.buildBlock(), this.meta, this.blockStateProps, this.oreDict);
    }

    public Block buildBlock() {
        Block block;
        if (this.blockName != null && (block = Block.func_149684_b((String)this.blockName)) != null) {
            return block;
        }
        return null;
    }

    public IBlockState buildBlockState() {
        Block block;
        if (this.blockName != null && (block = this.buildBlock()) != null) {
            if (this.meta != null) {
                return block.func_176203_a(this.meta.intValue());
            }
            return block.func_176223_P();
        }
        return null;
    }

    public Map<IProperty<?>, Object> getBlockStateProps() {
        return this.blockStateProps;
    }

    public Integer getMeta() {
        return this.meta;
    }

    @ScriptMethodDocumentation(args="String", usage="block id", notes="Sets the required block. This counts for any meta.")
    public void setBlock(String blockName) {
        this.setBlock(blockName, null);
    }

    @ScriptMethodDocumentation(args="String, Integer", usage="block id, meta", notes="Sets the required block with the provided meta.")
    public void setBlock(String blockName, Integer meta) {
        this.blockName = blockName;
        this.meta = meta;
        this.setBlockStateProps(meta);
    }

    public void setBlockStateProps(Integer meta) {
        Block block;
        if (meta != null && (block = this.buildBlock()) != null) {
            IBlockState state = block.func_176203_a(meta.intValue());
            this.blockStateProps.putAll((Map<IProperty<?>, Object>)state.func_177228_b());
        }
    }

    @ScriptMethodDocumentation(args="String", usage="ore dict name", notes="Sets the ore dictionary.")
    public void setOreDict(String oreDict) {
        if (OreDictionary.doesOreNameExist((String)oreDict)) {
            this.oreDict = oreDict;
        } else {
            DimensionalControl.instance.getLog().error((Object)("Ore dictionary " + oreDict + " does not exist!"));
        }
    }
}

