/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/DimensionalControl", classExplaination="This file is for basic mod options. It does nothing to modify dimensions. Dimensions can be traversed using custom portals or with the command /tpdim dimension <x> <y> <z>. If DimensionalControl.cfg does not exist, default configs and documentation will be printed.")
public class MainConfig {
    private boolean printDocumenation = true;
    private boolean printDefaultConfigs = true;
    private String defaultPreset = "Default";

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether DimensionalControl should print config documentation.", defaultValues="true")
    public void printDocumentation(boolean bool) {
        this.printDocumenation = bool;
    }

    @ScriptMethodDocumentation(args="boolean", usage="", notes="Used to set whether DC should print default config files. This will replace files. Always backup first!", defaultValues="true")
    public void printDefaultConfigs(boolean bool) {
        this.printDefaultConfigs = bool;
    }

    @ScriptMethodDocumentation(args="String", usage="preset name", notes="Sets the preset to be loaded when the default/no option is chosen.", defaultValues="Default")
    public void setDefaultPreset(String preset) {
        this.defaultPreset = preset;
    }

    public boolean shouldPrintDefaultConfigs() {
        return this.printDefaultConfigs;
    }

    public boolean shouldPrintDocumentation() {
        return this.printDocumenation;
    }

    public String getDefaultPreset() {
        return this.defaultPreset;
    }
}

