/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.blockreplacement;

import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacement;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.BlockData;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.LocationData;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.predicate.BlockPredicate;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldServer;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/blockreplacements/BlockReplacementFull", classExplaination="This extends BlockReplacement. Therefore, any script functions in BlockReplacement can be used for block replacements of this type. If no block to replace is set, it will replace any block.")
public class BlockReplacementFull
extends BlockReplacement {
    private BlockPredicate toReplace = null;
    private IBlockState replacement = Blocks.field_150350_a.func_176223_P();
    private LocationPredicate location = null;
    private final BlockData blockData = new BlockData();
    private final LocationData locationData = new LocationData();

    @Override
    public IBlockState replace(WorldServer world, IBlockState state, int x, int y, int z) {
        if (this.toReplace == null) {
            this.toReplace = this.blockData.buildPredicate();
        }
        if (this.toReplace.test(state)) {
            return this.replacement;
        }
        return state;
    }

    @Override
    public boolean shouldRunForLocation(WorldServer world, int x, int y, int z) {
        if (this.location == null) {
            this.location = this.locationData.buildLocationPredicate();
        }
        return this.location.func_193453_a(world, (float)x, (float)y, (float)z);
    }

    @ScriptMethodDocumentation(args="String", usage="block ID", notes="Sets the block replacement with a meta of 0.")
    public void setReplacement(String blockName) {
        this.setReplacement(blockName, 0);
    }

    @ScriptMethodDocumentation(args="String, int", usage="block ID, meta", notes="Sets the block replacement and meta.")
    public void setReplacement(String blockName, int meta) {
        IBlockState state;
        Block block = Block.func_149684_b((String)blockName);
        if (block != null && (state = block.func_176203_a(meta)) != null) {
            this.replacement = state;
        }
    }

    public void setReplacement(IBlockState state) {
        this.replacement = state;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the BlockData object for the block to be replaced so functions can be called on it.")
    public BlockData getBlockToReplace() {
        return this.blockData;
    }

    @ScriptMethodDocumentation(args="String", usage="block id", notes="Sets the block to be replaced. This counts for any meta.")
    public void setBlockToReplace(String blockName) {
        this.setBlockToReplace(blockName, null);
    }

    @ScriptMethodDocumentation(args="String, Integer", usage="block id, meta", notes="Sets the block to be replaced with the provided meta.")
    public void setBlockToReplace(String blockName, Integer meta) {
        this.blockData.setBlock(blockName, meta);
    }

    @ScriptMethodDocumentation(args="String", usage="ore dict name", notes="Sets the ore dictionary for the block to be replaced.")
    public void setBlockToReplaceOreDict(String oreDict) {
        this.blockData.setOreDict(oreDict);
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max X coordinates.")
    public void setXMinMax(float min, float max) {
        this.locationData.setXMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min X coordinate.")
    public void setXMin(float min) {
        this.locationData.setXMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max X coordinate.")
    public void setXMax(float max) {
        this.locationData.setXMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Y coordinates.")
    public void setYMinMax(float min, float max) {
        this.locationData.setYMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Y coordinate.")
    public void setYMin(float min) {
        this.locationData.setYMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Y coordinate.")
    public void setYMax(float max) {
        this.locationData.setYMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max Z coordinates.")
    public void setZMinMax(float min, float max) {
        this.locationData.setZMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min Z coordinate.")
    public void setZMin(float min) {
        this.locationData.setZMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max Z coordinate.")
    public void setZMax(float max) {
        this.locationData.setZMax(max);
    }

    @ScriptMethodDocumentation(args="String", usage="dimension type", notes="Sets the dimension type. Vanilla options are \"overworld\", \"the_nether\", \"the_end\"")
    public void setDimensionType(String type) {
        this.locationData.setDimensionType(type);
    }

    public void setMinHeight(int min) {
        this.setYMin(min);
    }

    public void setMaxHeight(int max) {
        this.setYMax(max);
    }
}

