/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevtweaks.common.compat.modules;

import com.google.common.collect.EvictingQueue;
import com.shinoow.abyssalcraft.common.structures.StructureShoggothPit;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import tv.darkosto.sevtweaks.SevTweaks;
import tv.darkosto.sevtweaks.common.compat.ICompat;
import tv.darkosto.sevtweaks.common.config.Configuration;

public class AbyssalCraft
extends ICompat {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        SevTweaks.logger.info("Registering ocean Shoggoth Lair generator");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ShoggothLairOceanGenerator(), (int)0);
    }

    @Override
    public void postInit() {
    }

    static class ShoggothLairOceanGenerator
    implements IWorldGenerator {
        final EvictingQueue<BlockPos> lairPositions = EvictingQueue.create((int)30);

        ShoggothLairOceanGenerator() {
        }

        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            boolean blacklisted = InitHandler.INSTANCE.isDimBlacklistedFromStructureGen(world.field_73011_w.getDimension());
            if (world.field_73011_w instanceof WorldProviderSurface && ACConfig.generateShoggothLairs && !blacklisted) {
                if (Configuration.worldGen.shoggothOceanSpawnRate == 0 || random.nextInt(Configuration.worldGen.shoggothOceanSpawnRate) != 0) {
                    return;
                }
                for (int i = 0; i < 32; ++i) {
                    BlockPos pos = world.func_175645_m(new BlockPos(chunkX * 16 + random.nextInt(16), 0, chunkZ * 16 + random.nextInt(16)));
                    if (!BiomeDictionary.hasType((Biome)world.func_180494_b(pos), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || !world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() || world.func_175623_d((pos = pos.func_177977_b()).func_177964_d(13)) || world.func_175623_d(pos.func_177964_d(20)) || world.func_175623_d(pos.func_177964_d(27))) continue;
                    BlockPos finalPos = pos;
                    if (this.lairPositions.stream().anyMatch(pos1 -> pos1.func_177951_i((Vec3i)finalPos) < 16384.0)) continue;
                    this.lairPositions.add((Object)pos);
                    new StructureShoggothPit().func_180709_b(world, random, pos);
                    break;
                }
            }
        }
    }
}

