/*
 * Decompiled with CFR 0.152.
 */
package igwmod.recipeintegration;

import igwmod.TextureSupplier;
import igwmod.WikiUtils;
import igwmod.api.FurnaceRetrievalEvent;
import igwmod.api.IRecipeIntegrator;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import igwmod.gui.LocatedStack;
import igwmod.gui.LocatedString;
import igwmod.gui.LocatedTexture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class IntegratorFurnace
implements IRecipeIntegrator {
    public static Map<String, ItemStack> autoMappedFurnaceRecipes = new HashMap<String, ItemStack>();

    @Override
    public String getCommandKey() {
        return "furnace";
    }

    @Override
    public void onCommandInvoke(String[] arguments, List<IReservedSpace> reservedSpaces, List<LocatedString> locatedStrings, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) throws IllegalArgumentException {
        int y;
        int x;
        if (arguments.length != 3 && arguments.length != 4) {
            throw new IllegalArgumentException("Code needs to contain 3 or 4 arguments: x, y, inputstack, outputstack. It now contains " + arguments.length + ".");
        }
        try {
            x = Integer.parseInt(arguments[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The first parameter (the x coordinate) contains an invalid number. Check for invalid characters!");
        }
        try {
            y = Integer.parseInt(arguments[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The second parameter (the y coordinate) contains an invalid number. Check for invalid characters!");
        }
        locatedTextures.add(new LocatedTexture(TextureSupplier.getTexture("igwmod:textures/GuiFurnace.png"), x, y, 164, 108));
        x = (int)((double)x * 0.5);
        y = (int)((double)y * 0.5);
        ItemStack inputStack = ItemStack.field_190927_a;
        ItemStack resultStack = ItemStack.field_190927_a;
        if (arguments[2].startsWith("key=")) {
            String resultStackCode = arguments[2].substring(4);
            inputStack = autoMappedFurnaceRecipes.get(resultStackCode);
            if (!inputStack.func_190926_b()) {
                resultStack = WikiUtils.getStackFromName(resultStackCode);
            } else {
                FurnaceRetrievalEvent recipeEvent = new FurnaceRetrievalEvent(resultStackCode);
                MinecraftForge.EVENT_BUS.post((Event)recipeEvent);
                inputStack = recipeEvent.inputStack;
                resultStack = recipeEvent.resultStack;
            }
        } else {
            inputStack = WikiUtils.getStackFromName(arguments[2]);
            resultStack = WikiUtils.getStackFromName(arguments[3]);
        }
        if (!inputStack.func_190926_b()) {
            locatedStacks.add(new LocatedStack(inputStack, x + 1, y + 1));
        }
        if (!resultStack.func_190926_b()) {
            locatedStacks.add(new LocatedStack(resultStack, x + 1 + 60, y + 1 + 18));
        }
    }
}

