/*
 * Decompiled with CFR 0.152.
 */
package igwmod;

import com.google.common.collect.ImmutableList;
import igwmod.ConfigHandler;
import igwmod.IProxy;
import igwmod.InfoSupplier;
import igwmod.TickHandler;
import igwmod.WikiUtils;
import igwmod.api.WikiRegistry;
import igwmod.gui.GuiWiki;
import igwmod.gui.tabs.BlockAndItemWikiTab;
import igwmod.gui.tabs.EntityWikiTab;
import igwmod.gui.tabs.IGWWikiTab;
import igwmod.lib.IGWLog;
import igwmod.recipeintegration.IntegratorComment;
import igwmod.recipeintegration.IntegratorCraftingRecipe;
import igwmod.recipeintegration.IntegratorFurnace;
import igwmod.recipeintegration.IntegratorImage;
import igwmod.recipeintegration.IntegratorStack;
import igwmod.render.TooltipOverlayHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.lwjgl.input.Keyboard;

public class ClientProxy
implements IProxy {
    public static KeyBinding openInterfaceKey;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipOverlayHandler());
        openInterfaceKey = new KeyBinding("igwmod.keys.wiki", 23, "igwmod.keys.category");
        ClientRegistry.registerKeyBinding((KeyBinding)openInterfaceKey);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        WikiRegistry.registerWikiTab(new IGWWikiTab());
        WikiRegistry.registerWikiTab(new BlockAndItemWikiTab());
        WikiRegistry.registerWikiTab(new EntityWikiTab());
        WikiRegistry.registerRecipeIntegrator(new IntegratorImage());
        WikiRegistry.registerRecipeIntegrator(new IntegratorCraftingRecipe());
        WikiRegistry.registerRecipeIntegrator(new IntegratorFurnace());
        WikiRegistry.registerRecipeIntegrator(new IntegratorStack());
        WikiRegistry.registerRecipeIntegrator(new IntegratorComment());
    }

    @SubscribeEvent
    public void onKeyBind(InputEvent.KeyInputEvent event) {
        if (openInterfaceKey.func_151468_f() && FMLClientHandler.instance().getClient().field_71415_G) {
            TickHandler.openWikiGui();
        }
    }

    @SubscribeEvent
    public void onGuiKeyBind(GuiScreenEvent.KeyboardInputEvent.Post event) {
        char chr = Keyboard.getEventCharacter();
        int key = Keyboard.getEventKey();
        if ((key == 0 && chr >= ' ' || Keyboard.getEventKeyState()) && key == openInterfaceKey.func_151463_i()) {
            this.handleSlotPresses();
        }
    }

    private void handleSlotPresses() {
        ItemStack stack;
        GuiContainer guiContainer;
        Slot slot;
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiContainer && (slot = (guiContainer = (GuiContainer)guiScreen).getSlotUnderMouse()) != null && !(stack = slot.func_75211_c()).func_190926_b()) {
            GuiWiki gui = new GuiWiki();
            FMLCommonHandler.instance().showGuiScreen((Object)gui);
            gui.setCurrentFile(stack);
        }
    }

    @Override
    public void postInit() {
        this.addDefaultKeys();
    }

    private void addDefaultKeys() {
        String blockCode;
        String modid;
        NonNullList allCreativeStacks = NonNullList.func_191196_a();
        IForgeRegistry itemReg = GameRegistry.findRegistry(Item.class);
        for (Item item : itemReg) {
            if (item == null || item.func_77640_w() == null) continue;
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, allCreativeStacks);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (ItemStack itemStack : allCreativeStacks) {
            List<String> info;
            if (itemStack.func_190926_b() || itemStack.func_77973_b() == null || Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b()) == null) continue;
            modid = "igwmod".toLowerCase();
            ResourceLocation id = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b());
            if (id != null && id.func_110624_b() != null) {
                modid = id.func_110624_b().toLowerCase();
            }
            if (itemStack.func_77977_a() == null || (info = InfoSupplier.getInfo(modid, WikiUtils.getNameFromStack(itemStack), true)) == null) continue;
            WikiRegistry.registerBlockAndItemPageEntry(itemStack);
        }
        for (ResourceLocation resourceLocation : EntityList.func_180124_b()) {
            modid = resourceLocation.func_110624_b();
            if (InfoSupplier.getInfo(modid, "entity/" + resourceLocation.func_110623_a(), true) == null) continue;
            WikiRegistry.registerEntityPageEntry(EntityList.getClass((ResourceLocation)resourceLocation));
        }
        for (IRecipe iRecipe : GameRegistry.findRegistry(IRecipe.class)) {
            if (iRecipe.func_77571_b() == null || iRecipe.func_77571_b().func_77973_b() == null) continue;
            try {
                if (iRecipe.func_77571_b().func_77977_a() == null) {
                    IGWLog.error("Item has no unlocalized name: " + iRecipe.func_77571_b().func_77973_b());
                    continue;
                }
                blockCode = WikiUtils.getNameFromStack(iRecipe.func_77571_b());
                if (IntegratorCraftingRecipe.autoMappedRecipes.containsKey(blockCode)) continue;
                IntegratorCraftingRecipe.autoMappedRecipes.put(blockCode, iRecipe);
            }
            catch (Throwable e) {
                IGWLog.error("IGW-Mod failed to add recipe handling support for " + iRecipe.func_77571_b());
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (entry.getValue() == null || ((ItemStack)entry.getValue()).func_77973_b() == null || IntegratorFurnace.autoMappedFurnaceRecipes.containsKey(blockCode = WikiUtils.getNameFromStack((ItemStack)entry.getValue()))) continue;
            IntegratorFurnace.autoMappedFurnaceRecipes.put(blockCode, (ItemStack)entry.getKey());
        }
        IGWLog.info("Registered " + WikiRegistry.getItemAndBlockPageEntries().size() + " Block & Item page entries.");
        IGWLog.info("Registered " + WikiRegistry.getEntityPageEntries().size() + " Entity page entries.");
    }

    @Override
    public void processIMC(FMLInterModComms.IMCEvent event) {
        ImmutableList messages = event.getMessages();
        for (FMLInterModComms.IMCMessage message : messages) {
            try {
                Class<?> clazz = Class.forName(message.key);
                try {
                    Method method = clazz.getMethod(message.getStringValue(), new Class[0]);
                    if (method == null) {
                        IGWLog.error("Couldn't find the \"" + message.key + "\" method. Make sure it's there and marked with the 'static' modifier!");
                        continue;
                    }
                    try {
                        method.invoke(null, new Object[0]);
                        IGWLog.info("Successfully gave " + message.getSender() + " a nudge! Happy to be doing business!");
                    }
                    catch (IllegalAccessException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be accessed: " + message.getStringValue());
                    }
                    catch (IllegalArgumentException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method has arguments or it isn't static: " + message.getStringValue());
                    }
                    catch (InvocationTargetException e) {
                        IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method threw an exception: " + message.getStringValue());
                        e.printStackTrace();
                    }
                }
                catch (NoSuchMethodException e) {
                    IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be found: " + message.getStringValue());
                }
                catch (SecurityException e) {
                    IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the method can NOT be accessed: " + message.getStringValue());
                }
            }
            catch (ClassNotFoundException e) {
                IGWLog.error(message.getSender() + " tried to register to IGW. Failed because the class can NOT be found: " + message.key);
            }
        }
    }

    @Override
    public String getSaveLocation() {
        try {
            return Minecraft.func_71410_x().field_71412_D.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            String mcDataLocation = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
            return mcDataLocation.substring(0, mcDataLocation.length() - 2);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

