/*
 * Decompiled with CFR 0.152.
 */
package magma_monsters;

import magma_monsters.ModSounds;
import magma_monsters.configs.ConfigHandler;
import magma_monsters.entities.EntityMagmaMonster;
import magma_monsters.entities.EntityMagmaMonsterGrunt;
import magma_monsters.network.QuenchMessage;
import magma_monsters.network.QuenchPacketHandler;
import magma_monsters.proxy.CommonProxy;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="magma_monsters", name="magma_monsters", version="0.3.0", guiFactory="magma_monsters.configs.ConfigGuiFactory", acceptedMinecraftVersions="[1.12]")
public class MagmaMonsters {
    @Mod.Instance(value="magma_monsters")
    public static MagmaMonsters INSTANCE;
    @SidedProxy(clientSide="magma_monsters.proxy.ClientProxy", serverSide="magma_monsters.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static SimpleNetworkWrapper NETWORK_WRAPPER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        ModSounds.init();
        EntityRegistry.registerModEntity((ResourceLocation)MagmaMonsters.getEntityResource("magma_monster"), EntityMagmaMonster.class, (String)"magma_monster", (int)1, (Object)this, (int)120, (int)1, (boolean)true, (int)0xFF0000, (int)440576);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMagmaMonster.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.registerModEntity((ResourceLocation)MagmaMonsters.getEntityResource("magma_monster_grunt"), EntityMagmaMonsterGrunt.class, (String)"magma_monster_grunt", (int)2, (Object)this, (int)120, (int)1, (boolean)true, (int)0xFF0000, (int)440576);
        EntitySpawnPlacementRegistry.setPlacementType(EntityMagmaMonsterGrunt.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        PROXY.registerRenderers();
        for (Biome allBiomes : ForgeRegistries.BIOMES.getValues()) {
            if (!BiomeDictionary.hasType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !BiomeDictionary.hasType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                if (ConfigHandler.MAGMA_OW_SPAWN) {
                    EntityRegistry.addSpawn(EntityMagmaMonster.class, (int)ConfigHandler.MAGMA_OW_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_OW_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_OW_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
                }
                if (ConfigHandler.MAGMA_GRUNT_OW_SPAWN) {
                    EntityRegistry.addSpawn(EntityMagmaMonsterGrunt.class, (int)ConfigHandler.MAGMA_GRUNT_OW_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_GRUNT_OW_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_GRUNT_OW_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
                }
            }
            if (!BiomeDictionary.hasType((Biome)allBiomes, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            if (ConfigHandler.MAGMA_HELL_SPAWN) {
                EntityRegistry.addSpawn(EntityMagmaMonster.class, (int)ConfigHandler.MAGMA_HELL_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_HELL_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_HELL_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
            }
            if (!ConfigHandler.MAGMA_GRUNT_HELL_SPAWN) continue;
            EntityRegistry.addSpawn(EntityMagmaMonsterGrunt.class, (int)ConfigHandler.MAGMA_GRUNT_HELL_SPAWN_PROBABILITY, (int)ConfigHandler.MAGMA_GRUNT_HELL_MIN_SPAWN_SIZE, (int)ConfigHandler.MAGMA_GRUNT_HELL_MAX_SPAWN_SIZE, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{allBiomes});
        }
    }

    private static ResourceLocation getEntityResource(String entityName) {
        return new ResourceLocation("magma_monsters", entityName);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)ConfigHandler.INSTANCE);
        NETWORK_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("magma_monsters");
        NETWORK_WRAPPER.registerMessage(QuenchPacketHandler.class, QuenchMessage.class, 0, Side.CLIENT);
    }
}

