/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableCellMultiBuilder {
    protected final List<Supplier<TableCellDefault>> cells = new ArrayList<Supplier<TableCellDefault>>();
    protected final List<BooleanSupplier> enabledSuppliers = new ArrayList<BooleanSupplier>();
    protected final TIntObjectMap<Supplier<Float>> sizers = new TIntObjectHashMap();
    public TableNavigator navigator;
    public TableDelegate delegate;
    public String title;
    public List<String> titleTooltip;

    private TableCellMultiBuilder(TableNavigator navigator, TableDelegate delegate) {
        this.navigator = navigator;
        this.delegate = delegate;
    }

    public static TableCellMultiBuilder create(TableNavigator navigator, TableDelegate delegate) {
        return new TableCellMultiBuilder(navigator, delegate);
    }

    @Nonnull
    private static TableCellButton defaultCell(Object title, Supplier<List<String>> tooltip, Runnable action) {
        TableCellButton cell = new TableCellButton(null, null, "");
        TableCellMultiBuilder.setVisuals(title, tooltip, cell);
        cell.addAction(action);
        return cell;
    }

    private static void setVisuals(Object title, Supplier<List<String>> tooltip, TableCellButton cell) {
        cell.setTitle("");
        cell.setTexture(null);
        if (title instanceof ResourceLocation) {
            cell.setTexture((ResourceLocation)title);
        } else if (title instanceof String) {
            cell.setTitle((String)title);
        }
        cell.setTooltip(tooltip != null ? tooltip.get() : null);
    }

    @Nonnull
    public TableCellMultiBuilder addCell(Supplier<TableCellDefault> cell) {
        this.cells.add(cell);
        this.enabledSuppliers.add(null);
        return this;
    }

    public TableCellMultiBuilder addAction(Runnable action, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> TableCellMultiBuilder.defaultCell(title.get(), tooltip, () -> {
            action.run();
            this.delegate.reloadData();
        }));
    }

    public TableCellMultiBuilder addSimpleNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> TableCellMultiBuilder.defaultCell(title.get(), tooltip, () -> this.lambda$null$2((Supplier)dataSource)));
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> {
            TableCellButton edit = TableCells.edit(true, this.navigator, this.delegate, dataSource);
            TableCellMultiBuilder.setVisuals(title.get(), tooltip, edit);
            return edit;
        });
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title) {
        return this.addNavigation(dataSource, title, null);
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource) {
        return this.addNavigation(dataSource, () -> IvTranslations.get("reccomplex.gui.edit"));
    }

    public TableCellMultiBuilder enabled(BooleanSupplier enabled) {
        this.enabledSuppliers.remove(this.enabledSuppliers.size() - 1);
        this.enabledSuppliers.add(enabled);
        return this;
    }

    public TableCellMultiBuilder sized(Supplier<Float> sizer) {
        this.sizers.put(this.cells.size() - 1, sizer);
        return this;
    }

    @Nonnull
    public TableDataSource buildDataSource() {
        return new TableDataSourceSupplied(this::build);
    }

    @Nonnull
    public TableCellMultiBuilder withTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public TableCellMultiBuilder withTitle(@Nullable String title, List<String> tooltip) {
        this.title = title;
        this.titleTooltip = tooltip;
        return this;
    }

    @Nonnull
    public TableCellDefault build() {
        ArrayList<TableCellDefault> cells = new ArrayList<TableCellDefault>();
        for (int i = 0; i < this.cells.size(); ++i) {
            TableCellDefault cell = this.cells.get(i).get();
            BooleanSupplier enabled = this.enabledSuppliers.get(i);
            if (enabled != null) {
                cell.setEnabled(enabled.getAsBoolean());
            }
            cells.add(cell);
        }
        TableCellMulti multi = new TableCellMulti(cells);
        this.sizers.forEachEntry((idx, supplier) -> {
            multi.setSize(idx, ((Float)supplier.get()).floatValue());
            return true;
        });
        return this.title != null ? new TitledCell(this.title, multi).withTitleTooltip(this.titleTooltip) : multi;
    }

    private /* synthetic */ void lambda$null$2(Supplier dataSource) {
        this.navigator.pushTable(new GuiTable(this.delegate, (TableDataSource)dataSource.get()));
    }
}

