/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.MCRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;

public class IvBlockMapper {
    private List<Block> mapping;

    public IvBlockMapper() {
        this.mapping = new ArrayList<Block>();
    }

    public IvBlockMapper(NBTTagCompound compound, String key, MCRegistry registry) {
        this(compound.func_150295_c(key, 8), registry);
    }

    public IvBlockMapper(NBTTagList list, MCRegistry registry) {
        this.mapping = new ArrayList<Block>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.mapping.add(registry.blockFromID(new ResourceLocation(list.func_150307_f(i))));
        }
    }

    public void addMapping(Block block) {
        if (!this.mapping.contains(block)) {
            this.mapping.add(block);
        }
    }

    public void addMapping(List<Block> blocks) {
        for (Block block : blocks) {
            this.addMapping(block);
        }
    }

    public int getMapping(Block block) {
        return this.mapping.indexOf(block);
    }

    public Block getBlock(int mapping) {
        return this.mapping.get(mapping);
    }

    public int getMapSize() {
        return this.mapping.size();
    }

    public NBTTagList createTagList() {
        NBTTagList list = new NBTTagList();
        for (Block block : this.mapping) {
            String name = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
            if (name != null) {
                list.func_74742_a((NBTBase)new NBTTagString(name));
                continue;
            }
            list.func_74742_a((NBTBase)new NBTTagString("minecraft:stone"));
            System.out.println("Did not find name for block '" + block + "' to map");
        }
        return list;
    }

    public NBTTagCompound createNBTForBlocks(List<Block> blocks) {
        NBTTagCompound compound = new NBTTagCompound();
        int[] vals = new int[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            vals[i] = this.getMapping(blocks.get(i));
        }
        NBTTagCompound compressed = new NBTTagCompound();
        IvNBTHelper.writeCompressed("data", vals, this.getMapSize() - 1, compressed);
        compound.func_74782_a("blocksCompressed", (NBTBase)compressed);
        return compound;
    }

    public Block[] createBlocksFromNBT(NBTTagCompound compound) {
        Block[] blocks;
        if (compound.func_74764_b("blocksCompressed")) {
            NBTTagCompound compressed = compound.func_74775_l("blocksCompressed");
            int[] vals = IvNBTHelper.readCompressed("data", compressed);
            blocks = new Block[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                blocks[i] = this.getBlock(vals[i]);
            }
        } else if (compound.func_74764_b("blockBytes")) {
            byte[] byteArray = compound.func_74770_j("blockBytes");
            blocks = new Block[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                blocks[i] = this.getBlock(byteArray[i]);
            }
        } else if (compound.func_74764_b("blockInts")) {
            int[] intArray = compound.func_74759_k("blockInts");
            blocks = new Block[intArray.length];
            for (int i = 0; i < intArray.length; ++i) {
                blocks[i] = this.getBlock(intArray[i]);
            }
        } else {
            throw new RuntimeException("Unrecognized block collection type " + compound);
        }
        return blocks;
    }
}

