/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.beneath.common.world.gen;

import com.shinoow.beneath.Beneath;
import com.shinoow.beneath.common.handler.BlockDecorationHandler;
import com.shinoow.beneath.common.handler.OreEntry;
import com.shinoow.beneath.common.handler.OreGenHandler;
import com.shinoow.beneath.common.world.gen.MapGenCavesDeepDank;
import com.shinoow.beneath.common.world.gen.WorldGenMinableDank;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderDeepDank
implements IChunkGenerator {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    private final World world;
    private final Random rand;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    private final WorldGenBush brownMushroomFeature = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush redMushroomFeature = new WorldGenBush(Blocks.field_150337_Q);
    private MapGenBase genDankCaves = new MapGenCavesDeepDank();
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;

    public ChunkProviderDeepDank(World worldIn, long seed) {
        this.world = worldIn;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        worldIn.func_181544_b(63);
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
    }

    public void prepareHeights(int p_185936_1_, int p_185936_2_, ChunkPrimer primer) {
        int i = 4;
        int k = i + 1;
        int l = 33;
        int i1 = i + 1;
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * i, 0, p_185936_2_ * i, k, l, i1);
        for (int j1 = 0; j1 < i; ++j1) {
            for (int k1 = 0; k1 < i; ++k1) {
                for (int l1 = 0; l1 < 32; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.buffer[((j1 + 0) * i1 + k1 + 0) * l + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * i1 + k1 + 1) * l + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * i1 + k1 + 0) * l + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * i1 + k1 + 1) * l + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * i1 + k1 + 0) * l + l1 + 1] - d1) * d0;
                    double d6 = (this.buffer[((j1 + 0) * i1 + k1 + 1) * l + l1 + 1] - d2) * d0;
                    double d7 = (this.buffer[((j1 + 1) * i1 + k1 + 0) * l + l1 + 1] - d3) * d0;
                    double d8 = (this.buffer[((j1 + 1) * i1 + k1 + 1) * l + l1 + 1] - d4) * d0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (d15 > 0.0) {
                                    iblockstate = STONE;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int p_185937_1_, int p_185937_2_, ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)p_185937_1_, (int)p_185937_2_, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        int i = this.world.func_181545_F() + 1;
        this.slowsandNoise = this.slowsandGravelNoiseGen.func_76304_a(this.slowsandNoise, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.gravelNoise = this.slowsandGravelNoiseGen.func_76304_a(this.gravelNoise, p_185937_1_ * 16, 109, p_185937_2_ * 16, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.depthBuffer = this.netherrackExculsivityNoiseGen.func_76304_a(this.depthBuffer, p_185937_1_ * 16, p_185937_2_ * 16, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                boolean flag = this.slowsandNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[j + k * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                int l = (int)(this.depthBuffer[j + k * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int i1 = -1;
                IBlockState iblockstate = STONE;
                IBlockState iblockstate1 = STONE;
                for (int j1 = 255; j1 >= 0; --j1) {
                    if (j1 < 255 - this.rand.nextInt(5) && j1 > this.rand.nextInt(5)) {
                        IBlockState iblockstate2 = primer.func_177856_a(k, j1, j);
                        if (iblockstate2.func_177230_c() != null && iblockstate2.func_185904_a() != Material.field_151579_a) {
                            if (iblockstate2.func_177230_c() != Blocks.field_150348_b) continue;
                            if (i1 == -1) {
                                if (l <= 0) {
                                    iblockstate = AIR;
                                    iblockstate1 = STONE;
                                } else if (j1 >= i - 4 && j1 <= i + 1) {
                                    iblockstate = STONE;
                                    iblockstate1 = STONE;
                                    if (flag1) {
                                        iblockstate = GRAVEL;
                                        iblockstate1 = STONE;
                                    }
                                    if (flag) {
                                        iblockstate = STONE;
                                        iblockstate1 = STONE;
                                    }
                                }
                                i1 = l;
                                if (j1 >= i - 1) {
                                    primer.func_177855_a(k, j1, j, iblockstate);
                                    continue;
                                }
                                primer.func_177855_a(k, j1, j, iblockstate1);
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            primer.func_177855_a(k, j1, j, iblockstate1);
                            continue;
                        }
                        i1 = -1;
                        continue;
                    }
                    primer.func_177855_a(k, j1, j, BEDROCK);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, chunkprimer);
        this.buildSurfaces(x, z, chunkprimer);
        this.genDankCaves.func_186125_a(this.world, x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] abiome = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)abiome[i]);
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] getHeights(double[] p_73164_1_, int p_73164_2_, int p_73164_3_, int p_73164_4_, int p_73164_5_, int p_73164_6_, int p_73164_7_) {
        int i2;
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_73164_1_, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        if (p_73164_1_ == null) {
            p_73164_1_ = new double[p_73164_5_ * p_73164_6_ * p_73164_7_];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.scaleNoise.func_76304_a(this.noiseData4, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 1.0, 0.0, 1.0);
        this.noiseData5 = this.depthNoise.func_76304_a(this.noiseData5, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 100.0, 0.0, 100.0);
        this.noiseData1 = this.perlinNoise1.func_76304_a(this.noiseData1, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.lperlinNoise1.func_76304_a(this.noiseData2, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        this.noiseData3 = this.lperlinNoise2.func_76304_a(this.noiseData3, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[p_73164_6_];
        for (i2 = 0; i2 < p_73164_6_; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)p_73164_6_) * 2.0;
            double d2 = i2;
            if (i2 > p_73164_6_ / 2) {
                d2 = p_73164_6_ - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < p_73164_5_; ++i2) {
            for (int k2 = 0; k2 < p_73164_7_; ++k2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)p_73164_6_ / 16.0;
                ++l1;
                for (int j2 = 0; j2 < p_73164_6_; ++j2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > p_73164_6_ - 4) {
                        d11 = (float)(j2 - (p_73164_6_ - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    p_73164_1_[k1] = d6;
                    ++k1;
                }
            }
        }
        return p_73164_1_;
    }

    public void func_185931_b(int x, int z) {
        int j2;
        int i2;
        int i3;
        int extraHeight;
        BlockPos pos1;
        int k1;
        int j1;
        int i1;
        int k;
        BlockFalling.field_149832_M = true;
        if (!Beneath.internalOreGen) {
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        }
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        if (!Beneath.internalOreGen) {
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.rand, blockpos));
        }
        if (Beneath.stalactiteChance > 0) {
            for (k = 0; k < Beneath.stalactiteChance; ++k) {
                i1 = this.rand.nextInt(22) + 2;
                pos1 = blockpos.func_177982_a(i1, j1 = this.rand.nextInt(246) + 5, k1 = this.rand.nextInt(22) + 2);
                if (this.world.func_175623_d(pos1) || !this.world.func_175623_d(pos1.func_177977_b()) || this.world.func_175623_d(pos1.func_177984_a())) continue;
                extraHeight = this.rand.nextInt(10);
                boolean b = true;
                for (int i22 = 1; i22 < 16 + extraHeight; ++i22) {
                    if (this.world.func_175623_d(pos1.func_177979_c(i22))) continue;
                    b = false;
                    break;
                }
                if (!b) continue;
                IBlockState state = Blocks.field_150348_b.func_176223_P();
                for (i3 = 0; i3 < 10 + extraHeight + this.rand.nextInt(5); ++i3) {
                    this.world.func_180501_a(pos1.func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177974_f().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177976_e().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177974_f().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177976_e().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177976_e().func_177979_c(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177974_f().func_177979_c(i3), state, 2);
                }
            }
        }
        if (Beneath.stalagmiteChance > 0) {
            for (k = 0; k < Beneath.stalagmiteChance; ++k) {
                i1 = this.rand.nextInt(22) + 2;
                pos1 = blockpos.func_177982_a(i1, j1 = this.rand.nextInt(246) + 5, k1 = this.rand.nextInt(22) + 2);
                if (this.world.func_175623_d(pos1) || !this.world.func_175623_d(pos1.func_177984_a()) || this.world.func_175623_d(pos1.func_177977_b())) continue;
                extraHeight = this.rand.nextInt(10);
                boolean b1 = true;
                for (int i23 = 1; i23 < 16 + extraHeight; ++i23) {
                    if (this.world.func_175623_d(pos1.func_177981_b(i23))) continue;
                    b1 = false;
                    break;
                }
                if (!b1) continue;
                IBlockState state = Blocks.field_150348_b.func_176223_P();
                for (i3 = 0; i3 < 10 + extraHeight + this.rand.nextInt(5); ++i3) {
                    this.world.func_180501_a(pos1.func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177974_f().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177976_e().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 5 + extraHeight + this.rand.nextInt(6); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177974_f().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177976_e().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177968_d().func_177976_e().func_177981_b(i3), state, 2);
                }
                for (i3 = 0; i3 < 3 + extraHeight + this.rand.nextInt(4); ++i3) {
                    this.world.func_180501_a(pos1.func_177978_c().func_177974_f().func_177981_b(i3), state, 2);
                }
            }
        }
        if (TerrainGen.decorate((World)this.world, (Random)this.rand, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            if (this.rand.nextBoolean()) {
                this.brownMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
            }
            if (this.rand.nextBoolean()) {
                this.redMushroomFeature.func_180709_b(this.world, this.rand, blockpos.func_177982_a(this.rand.nextInt(16) + 8, this.rand.nextInt(256), this.rand.nextInt(16) + 8));
            }
        }
        if (Beneath.lakeChance > 0) {
            for (Block block : Beneath.fluid_blocks) {
                if (this.rand.nextInt(Beneath.lakeChance) != 0) continue;
                int i12 = this.rand.nextInt(16) + 8;
                int j12 = this.rand.nextInt(236) + 10;
                int k12 = this.rand.nextInt(16) + 8;
                new WorldGenLakes(block).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i12, j12, k12));
            }
        }
        if (Beneath.dungeonChance > 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j22 = 0; j22 < Beneath.dungeonChance; ++j22) {
                int i32 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i32, l3, l1));
            }
        }
        if (Beneath.useDecorator) {
            for (OreEntry entry : BlockDecorationHandler.getBlockDeco()) {
                WorldGenMinableDank worldgenminable = new WorldGenMinableDank(entry.getOre(), entry.size, entry.getSource());
                for (k1 = 0; k1 < entry.veins; ++k1) {
                    int l1 = this.rand.nextInt(16);
                    i2 = this.rand.nextInt(entry.maxY - entry.minY) + entry.minY;
                    j2 = this.rand.nextInt(16);
                    worldgenminable.func_180709_b(this.world, this.rand, blockpos.func_177982_a(l1, i2, j2));
                }
            }
        }
        if (Beneath.internalOreGen) {
            for (OreEntry entry : OreGenHandler.getOregen()) {
                WorldGenMinableDank worldgenminable = new WorldGenMinableDank(entry.getOre(), entry.size, entry.getSource());
                for (k1 = 0; k1 < entry.veins; ++k1) {
                    int l1 = this.rand.nextInt(16);
                    i2 = this.rand.nextInt(entry.maxY - entry.minY) + entry.minY;
                    j2 = this.rand.nextInt(16);
                    worldgenminable.func_180709_b(this.world, this.rand, blockpos.func_177982_a(l1, i2, j2));
                }
            }
        }
        if (!Beneath.internalOreGen) {
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.rand, blockpos));
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (Beneath.disableMobSpawning) {
            return Collections.emptyList();
        }
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean bool) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

